/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class ManifestCreationFinalizer
extends AbstractArchiveFinalizer {
    private final MavenProject project;
    private final MavenSession session;
    private final MavenArchiveConfiguration archiveConfiguration;
    private final MavenArchiver mavenArchiver = new MavenArchiver();

    public ManifestCreationFinalizer(MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration) {
        this.session = session;
        this.project = project;
        this.archiveConfiguration = archiveConfiguration;
    }

    @Override
    public void finalizeArchiveCreation(Archiver archiver) {
        if (this.archiveConfiguration != null) {
            try {
                Manifest manifest;
                block21: {
                    File manifestFile = this.archiveConfiguration.getManifestFile();
                    if (manifestFile != null) {
                        try (InputStreamReader manifestFileReader = new InputStreamReader((InputStream)new FileInputStream(manifestFile), StandardCharsets.UTF_8);){
                            manifest = new Manifest(manifestFileReader);
                            break block21;
                        }
                        catch (FileNotFoundException e) {
                            throw new ArchiverException("Manifest not found: " + e.getMessage(), e);
                        }
                        catch (IOException e) {
                            throw new ArchiverException("Error processing manifest: " + e.getMessage(), e);
                        }
                    }
                    manifest = this.mavenArchiver.getManifest(this.session, this.project, this.archiveConfiguration);
                }
                if (manifest != null && archiver instanceof JarArchiver) {
                    JarArchiver jarArchiver = (JarArchiver)archiver;
                    jarArchiver.addConfiguredManifest(manifest);
                }
            }
            catch (ManifestException e) {
                throw new ArchiverException("Error creating manifest: " + e.getMessage(), e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new ArchiverException("Dependencies were not resolved: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public List<String> getVirtualFiles() {
        if (this.archiveConfiguration != null) {
            try {
                if (this.mavenArchiver.getManifest(this.project, this.archiveConfiguration.getManifest()) != null) {
                    return Collections.singletonList("META-INF/MANIFEST.MF");
                }
            }
            catch (DependencyResolutionRequiredException | ManifestException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

