/*
 * Decompiled with CFR 0.152.
 */
package com.pansoft.xbrl.xbrljson.config;

import com.pansoft.xbrl.xbrljson.config.model.JsonConfigItem;
import com.pansoft.xbrl.xbrljson.config.model.XbrlJsonConfig;
import com.pansoft.xbrl.xbrljson.model.Entity;
import com.pansoft.xbrl.xbrljson.model.SchemaRef;
import com.pansoft.xbrl.xbrljson.model.Unit;
import com.pansoft.xbrl.xbrljson.model.Xbrl;
import com.pansoft.xbrl.xbrljson.util.StringUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XbrlJsonConfigReader {
    private File configFile;

    public XbrlJsonConfig reafFile(URL fileUrl) {
        XbrlJsonConfig configObject = null;
        Document document = null;
        try {
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(fileUrl);
            Element rootNode = document.getRootElement();
            String rootName = rootNode.getName();
            if (!"xbrlJson".equals(rootName)) {
                return configObject;
            }
            String configId = rootNode.attributeValue("id");
            String configName = rootNode.attributeValue("name");
            configObject = new XbrlJsonConfig();
            configObject.setConfigId(configId);
            configObject.setConfigName(configName);
            List childList = rootNode.elements();
            if (childList == null || childList.size() == 0) {
                return configObject;
            }
            for (Element childItem : childList) {
                this.readConfigNode(childItem, configObject);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return configObject;
    }

    public XbrlJsonConfig reafFile(File configFile) {
        try {
            return this.reafFile(configFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void readConfigNode(Element childItem, XbrlJsonConfig configObject) {
        if (childItem == null || configObject == null) {
            return;
        }
        String nodeName = childItem.getName();
        if ("instanceDoc".equals(nodeName)) {
            this.readInstanceDocNode(childItem, configObject);
        } else if ("objectDefine".equals(nodeName)) {
            this.readObjectDefineNode(childItem, configObject);
        } else if ("jsonObject".equals(nodeName)) {
            this.readJsonObjectNode(childItem, configObject);
        }
    }

    private void readInstanceDocNode(Element node, XbrlJsonConfig configObject) {
        List childList = node.elements();
        if (childList == null || childList.size() == 0) {
            return;
        }
        for (Element childNode : childList) {
            String childNodeName = childNode.getName();
            if ("nameSpaceRef".equals(childNodeName)) {
                this.readNameSpaceNode(childNode, configObject);
                continue;
            }
            if ("SchemaLocationRef".equals(childNodeName)) {
                this.readSchemaLocationNode(childNode, configObject);
                continue;
            }
            if ("UnitRef".equals(childNodeName)) {
                this.readUnitNode(childNode, configObject);
                continue;
            }
            if ("SchemaRef".equals(childNodeName)) {
                this.readSchemaRefNode(childNode, configObject);
                continue;
            }
            if ("EntityRef".equals(childNodeName)) {
                this.readEntityRefNode(childNode, configObject);
                continue;
            }
            if (!"ContextInstantRef".equals(childNodeName)) continue;
            this.readContextInstantRefNode(childNode, configObject);
        }
    }

    private void readObjectDefineNode(Element node, XbrlJsonConfig configObject) {
    }

    private void readJsonObjectNode(Element node, XbrlJsonConfig configObject) {
        List childList = node.elements();
        if (childList == null || childList.size() == 0) {
            return;
        }
        JsonConfigItem jsonConfig = new JsonConfigItem();
        this.fillJsonConfig(jsonConfig, node);
        this.processJsonObject(node, jsonConfig);
        configObject.setJsonConfig(jsonConfig);
    }

    private void processJsonObject(Element parentNode, JsonConfigItem parentConfigItem) {
        List childList = parentNode.elements();
        if (childList == null || childList.size() == 0) {
            return;
        }
        for (Element item : childList) {
            JsonConfigItem jsonConfig = new JsonConfigItem();
            this.fillJsonConfig(jsonConfig, item);
            parentConfigItem.addChild(jsonConfig);
            this.processJsonObject(item, jsonConfig);
        }
    }

    private void fillJsonConfig(JsonConfigItem jsonConfig, Element node) {
        if (jsonConfig == null || node == null) {
            return;
        }
        jsonConfig.setContextType(node.attributeValue("contextType"));
        jsonConfig.setControlData(node.attributeValue("controlData"));
        jsonConfig.setDecimals(node.attributeValue("decimals"));
        jsonConfig.setElementName(node.attributeValue("elementName"));
        jsonConfig.setElementNsName(node.attributeValue("elementNsName"));
        jsonConfig.setElementValueType(node.attributeValue("elementValueType"));
        jsonConfig.setFieldName(node.getName());
        jsonConfig.setUnitId(node.attributeValue("unitId"));
    }

    private void readNameSpaceNode(Element node, XbrlJsonConfig configObject) {
        List nameSpaceList = node.elements();
        if (nameSpaceList == null || nameSpaceList.size() == 0) {
            return;
        }
        Xbrl xbrl = configObject.getXbrlTemp();
        for (Element item : nameSpaceList) {
            String itemName = item.getName();
            if (!itemName.equals("nameSpace")) continue;
            String prefix = item.attributeValue("nameSpacePrefix");
            String uri = item.attributeValue("nameSpaceURI");
            xbrl.addNameSpace(prefix, uri);
        }
    }

    private void readSchemaLocationNode(Element node, XbrlJsonConfig configObject) {
        String[] values;
        String value = node.attributeValue("value");
        if (StringUtil.isBlank(value)) {
            return;
        }
        HashSet<String> set = configObject.getXbrlTemp().getSchemaLocationSet();
        for (String item : values = value.split(" ")) {
            set.add(item);
        }
    }

    private void readUnitNode(Element childNode, XbrlJsonConfig configObject) {
        List unitList = childNode.elements();
        if (unitList == null || unitList.size() == 0) {
            return;
        }
        for (Element unitNode : unitList) {
            String[] values;
            String unitId = unitNode.attributeValue("id");
            String measure = unitNode.attributeValue("measure");
            String numerator = unitNode.attributeValue("numerator");
            String denominator = unitNode.attributeValue("denominator");
            if (StringUtil.isBlank(unitId)) {
                return;
            }
            HashMap<String, Unit> unitMap = configObject.getXbrlTemp().getUnitList();
            if (unitMap.containsKey(unitId)) {
                System.out.println("\u8d27\u5e01\u5355\u4f4d\u7f16\u53f7 " + unitId + " \u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u63d2\u5165");
                return;
            }
            Unit unit = new Unit();
            unit.setId(unitId);
            if (!StringUtil.isBlank(measure)) {
                for (String value : values = measure.split("@")) {
                    unit.addMeasure(value);
                }
            }
            if (!StringUtil.isBlank(numerator)) {
                for (String value : values = numerator.split("@")) {
                    unit.addNumerator(value);
                }
            }
            if (!StringUtil.isBlank(denominator)) {
                for (String value : values = denominator.split("@")) {
                    unit.addDenominator(value);
                }
            }
            unitMap.put(unitId, unit);
        }
    }

    private void readContextInstantRefNode(Element childNode, XbrlJsonConfig configObject) {
        String instant = childNode.attributeValue("instant");
        configObject.getXbrlTemp().setInstant(instant);
    }

    private void readEntityRefNode(Element childNode, XbrlJsonConfig configObject) {
        String scheme = childNode.attributeValue("scheme");
        String identifier = childNode.attributeValue("identifier");
        if (StringUtil.isBlank(scheme) || StringUtil.isBlank(identifier)) {
            return;
        }
        Entity defaultEntity = new Entity();
        defaultEntity.setScheme(scheme);
        defaultEntity.setIdentifier(identifier);
        if (identifier.indexOf("${") >= 0) {
            defaultEntity.setExp(true);
        }
        defaultEntity.setIdentifier(identifier);
        configObject.getXbrlTemp().setDefaultEntity(defaultEntity);
    }

    private void readSchemaRefNode(Element childNode, XbrlJsonConfig configObject) {
        String schemaRef = childNode.attributeValue("schemaRef");
        if (StringUtil.isBlank(schemaRef)) {
            return;
        }
        SchemaRef sr = new SchemaRef();
        sr.setHref(schemaRef);
        configObject.getXbrlTemp().setSchemaRef(sr);
    }
}

