/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.utils;

import com.cwca.certServer.common.utils.CertUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import sun.misc.BASE64Decoder;

public class RSAUtils {
    public static String encrypt(String str, String publicKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes("UTF-8")));
        return outStr;
    }

    public static String encrypt(byte[] orign, byte[] publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        byte[] res = cipher.doFinal(orign);
        String s = Base64.encodeBase64String(res);
        return s;
    }

    public static String encryptByP10(byte[] str, String p10) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException, IOException, BadPaddingException, IllegalBlockSizeException {
        PKCS10CertificationRequest p10cert = new PKCS10CertificationRequest(new BASE64Decoder().decodeBuffer(p10));
        PublicKey publicKey = p10cert.getPublicKey();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str));
        return outStr;
    }

    public static String decrypt(String str, String privateKey) throws Exception {
        byte[] inputByte = Base64.decodeBase64(str.getBytes("UTF-8"));
        byte[] decoded = Base64.decodeBase64(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }

    public static byte[] sign(byte[] data, PrivateKey privateKey, int sig) throws Exception {
        String sigStr = "SHA1withRSA";
        switch (sig) {
            case 0: {
                sigStr = "SHA1withRSA";
                break;
            }
            case 1: {
                sigStr = "SHA256withRSA";
                break;
            }
        }
        byte[] keyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(sigStr);
        signature.initSign(key);
        signature.update(data);
        return signature.sign();
    }

    public static boolean verify(byte[] srcData, PublicKey publicKey, byte[] sign, int sig) throws Exception {
        String sigStr = "SHA1withRSA";
        switch (sig) {
            case 0: {
                sigStr = "SHA1withRSA";
                break;
            }
            case 1: {
                sigStr = "SHA256withRSA";
                break;
            }
        }
        byte[] keyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey key = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(sigStr);
        signature.initVerify(key);
        signature.update(srcData);
        return signature.verify(sign);
    }

    public static PublicKey getPublicKeyByCert(String cert) {
        X509Certificate rsax509Certificate = CertUtils.getRSAX509Certificate(cert);
        PublicKey publicKey = rsax509Certificate.getPublicKey();
        return publicKey;
    }
}

