/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import sun.misc.BASE64Decoder;

public class JksUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getCerChain(String pcert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate[] certChain;
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] byt = decoder.decodeBuffer(pcert);
        try (InputStream sbs = null;){
            sbs = new ByteArrayInputStream(byt);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(sbs);
            Iterator<? extends Certificate> i = c.iterator();
            certChain = null;
            while (i.hasNext()) {
                X509Certificate cert = (X509Certificate)i.next();
                certChain = new Certificate[]{cert};
            }
        }
        return certChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WritePfx(String alias, PrivateKey priv, String password, Certificate[] certChain, String path) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        try (FileOutputStream out = null;){
            KeyStore outputKeyStore = KeyStore.getInstance("pkcs12");
            outputKeyStore.load(null, null);
            outputKeyStore.setKeyEntry(alias, priv, password.toCharArray(), certChain);
            out = new FileOutputStream(path);
            outputKeyStore.store(out, password.toCharArray());
        }
        return 0;
    }

    public byte[] DecKey(String EncryptedPrivateKey, String EncryptedSessionKey, PrivateKey priv) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] p = decoder.decodeBuffer(EncryptedPrivateKey);
        byte[] s = decoder.decodeBuffer(EncryptedSessionKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(2, priv);
        byte[] plainSession = cipher.doFinal(s);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(plainSession);
        byte[] md5Value = md5.digest();
        KeyGenerator gen = KeyGenerator.getInstance("RC4");
        gen.init(128, new SecureRandom(md5Value));
        SecretKey key = gen.generateKey();
        Cipher ci = Cipher.getInstance("RC4");
        ci.init(2, key);
        byte[] enckey = ci.doFinal(p);
        return enckey;
    }

    public PrivateKey BytPrivate(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey pri = keyFactory.generatePrivate(pkcs8KeySpec);
        return pri;
    }

    public String adminsn(String path, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        KeyStore pfx = KeyStore.getInstance("PKCS12");
        pfx.load(new FileInputStream(path), password.toCharArray());
        Certificate certificate = pfx.getCertificate(pfx.aliases().nextElement());
        String opertatorSn = ((X509Certificate)certificate).getSerialNumber().toString(16).toUpperCase();
        return opertatorSn;
    }

    public byte[] ChartoByt(char[] chars) {
        Charset cs = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }
}

