/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.utils;

import com.cwca.certServer.common.utils.DateUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileUtil {
    public static File createFile(String pathStr, String fileName) {
        File file;
        File path = new File(pathStr);
        if (!path.exists()) {
            path.mkdirs();
        }
        if ((file = new File(pathStr + "/" + fileName)).exists()) {
            int dotIndex = fileName.lastIndexOf(".");
            file = dotIndex != -1 ? new File(pathStr + "/" + fileName.substring(0, dotIndex) + System.currentTimeMillis() + fileName.substring(dotIndex, fileName.length())) : new File(pathStr + "/" + fileName + System.currentTimeMillis());
        }
        return file;
    }

    public static void newFolder(String folderPath) {
        try {
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
        }
        catch (Exception e) {
            System.out.println("\u65b0\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            System.out.println("\u5220\u9664\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + "/" + tempList[i]);
            FileUtil.delFolder(path + "/" + tempList[i]);
        }
    }

    public static boolean copyFile(String oldPath, String newPath) {
        boolean flag = false;
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
                flag = true;
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean copyFolder(String oldPath, String newPath) {
        boolean flag = false;
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
            flag = true;
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean copyFolder(String oldPath, String newPath, String filterDir) {
        boolean flag = false;
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory() || file[i].equals(filterDir)) continue;
                FileUtil.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i], filterDir);
            }
            flag = true;
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean moveFile(String oldPath, String newPath) {
        boolean flag = FileUtil.copyFile(oldPath, newPath);
        if (flag) {
            FileUtil.delFile(oldPath);
        }
        return flag;
    }

    public static void moveFolder(String oldPath, String newPath) {
        FileUtil.copyFolder(oldPath, newPath, null);
        FileUtil.delFolder(oldPath);
    }

    public static void delFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                File[] files;
                for (File f : files = file.listFiles()) {
                    FileUtil.delFile(f);
                }
                file.delete();
            }
        }
    }

    public static void delFile(String path) {
        FileUtil.delFile(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }

    public static File getFile(String fileName, String propertyName) throws Exception {
        String filePath = null;
        if (propertyName != null && !"".equals(propertyName)) {
            filePath = System.getProperty(propertyName);
        }
        File file = null;
        if (filePath == null || "".equals(filePath)) {
            URL url = FileUtil.class.getClassLoader().getResource(propertyName + fileName);
            if (url == null) {
                throw new FileNotFoundException(fileName + " not found!");
            }
            file = new File(url.getPath());
        } else {
            filePath = filePath.endsWith("/") ? filePath.concat(fileName) : filePath.concat("/").concat(fileName);
            file = new File(filePath);
        }
        return file;
    }

    public static String getFilePath(String fileName, String propertyName) throws Exception {
        String filePath = null;
        if (propertyName != null && !"".equals(propertyName)) {
            filePath = System.getProperty(propertyName);
        }
        if (filePath == null || "".equals(filePath)) {
            URL url = FileUtil.class.getClassLoader().getResource(propertyName + fileName);
            if (url == null) {
                throw new FileNotFoundException(fileName + " not found!");
            }
            filePath = url.getPath();
        } else {
            filePath = filePath.endsWith("/") ? filePath.concat(fileName) : filePath.concat("/").concat(fileName);
        }
        return filePath;
    }

    public static String getFileDir(String fileName, String propertyName) throws Exception {
        String filePath = null;
        if (propertyName != null && !"".equals(propertyName)) {
            filePath = System.getProperty(propertyName);
        }
        if (filePath == null || "".equals(filePath)) {
            URL url = FileUtil.class.getClassLoader().getResource(propertyName + fileName);
            if (url == null) {
                throw new FileNotFoundException(fileName + " not found!");
            }
            filePath = url.getPath();
            filePath = filePath.replace(fileName, "");
        } else {
            filePath = filePath.endsWith("/") ? filePath.concat(fileName) : filePath.concat("/").concat(fileName);
        }
        return filePath;
    }

    public static String read(File file, String charset) {
        byte[] content = FileUtil.read(file);
        return content == null ? "" : new String(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("The remote not exist or not a remote");
        }
        FileInputStream fis = null;
        byte[] content = null;
        try {
            fis = new FileInputStream(file);
            content = new byte[fis.available()];
            fis.read(content);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                fis = null;
            }
        }
        return content;
    }

    public static void saveProperties(String filePath, String parameterName, String parameterValue) {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(filePath);
            prop.load(fis);
            FileOutputStream fos = new FileOutputStream(filePath);
            prop.setProperty(parameterName, parameterValue);
            prop.store(fos, "Update '" + parameterName + "' value");
            ((InputStream)fis).close();
        }
        catch (IOException e) {
            System.err.println("Visit " + filePath + " for updating " + parameterName + " value error");
        }
    }

    public static List<Map<String, String>> listFile(String dir, String[] extArr) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        File file = new File(dir);
        if (!file.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        if (file.isFile()) {
            if (extArr != null) {
                for (int i = 0; i < extArr.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith(extArr[i])) continue;
                    hm.put("fileName", file.getName());
                    hm.put("isDir", "false");
                    hm.put("path", file.getPath());
                    hm.put("size", file.length() + "");
                    hm.put("isDir", "false");
                    hm.put("modified", DateUtil.longToDate(file.lastModified()));
                    hm.put("fileDir", file.getParent());
                    mapList.add(hm);
                }
            } else {
                hm.put("fileName", file.getName());
                hm.put("isDir", "false");
                hm.put("path", file.getPath());
                hm.put("size", file.length() + "");
                hm.put("modified", DateUtil.longToDate(file.lastModified()));
                hm.put("fileDir", file.getParent());
                mapList.add(hm);
            }
        } else {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                HashMap<String, String> hm_;
                if (files[i].isFile()) {
                    // empty if block
                }
                if (extArr != null) {
                    if (!file.getName().toLowerCase().endsWith(extArr[i])) continue;
                    hm_ = new HashMap();
                    hm_.put("fileName", files[i].getName());
                    hm_.put("isDir", "true");
                    hm_.put("path", files[i].getPath());
                    hm_.put("size", files[i].length() + "");
                    hm_.put("path", files[i].getPath());
                    hm_.put("modified", DateUtil.longToDate(files[i].lastModified()));
                    hm_.put("count", files[i].length() + "");
                    hm_.put("fileDir", files[i].getParent());
                    mapList.add(hm_);
                    continue;
                }
                hm_ = new HashMap<String, String>();
                hm_.put("fileName", files[i].getName());
                hm_.put("isDir", "true");
                hm_.put("path", files[i].getPath());
                hm_.put("size", files[i].length() + "");
                hm_.put("path", files[i].getPath());
                hm_.put("modified", DateUtil.longToDate(files[i].lastModified()));
                hm_.put("count", files[i].length() + "");
                hm_.put("fileDir", files[i].getParent());
                mapList.add(hm_);
            }
        }
        return mapList;
    }

    public static List<Map<String, String>> listFileAll(String path, String[] extArr) {
        List<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        File file = new File(path);
        if (file.exists()) {
            mapList = FileUtil.listChild(file, extArr, mapList);
        }
        return mapList;
    }

    private static List<Map<String, String>> listChild(File file, String[] extArr, List<Map<String, String>> mapList) {
        if (!file.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        if (file.isFile()) {
            if (extArr != null) {
                for (int i = 0; i < extArr.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith(extArr[i])) continue;
                    hm.put("fileName", file.getName());
                    hm.put("isDir", "false");
                    hm.put("path", file.getPath());
                    hm.put("size", file.length() + "");
                    hm.put("modified", DateUtil.longToDate(file.lastModified()));
                    hm.put("fileDir", file.getParent());
                    mapList.add(hm);
                }
            } else {
                hm.put("fileName", file.getName());
                hm.put("isDir", "false");
                hm.put("path", file.getPath());
                hm.put("size", file.length() + "");
                hm.put("modified", DateUtil.longToDate(file.lastModified()));
                hm.put("fileDir", file.getParent());
                mapList.add(hm);
            }
        } else {
            File[] files = file.listFiles();
            hm.put("fileName", file.getName());
            hm.put("isDir", "true");
            hm.put("path", file.getPath());
            hm.put("size", file.length() + "");
            hm.put("path", file.getPath());
            hm.put("modified", DateUtil.longToDate(file.lastModified()));
            hm.put("count", files.length + "");
            hm.put("fileDir", file.getParent());
            mapList.add(hm);
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listChild(files[i], extArr, mapList);
            }
        }
        return mapList;
    }

    public static void deleteFile(String filePath, String fileName) {
        File file = new File(filePath);
        if (file.exists()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(fileName)) continue;
                files[i].delete();
                return;
            }
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static void main(String[] arr) {
        FileUtil.copyFolder("C:\\test\\source_data\\ptgui\\0100002\\2015\\10-02\\ptgui_project", "E:\\outputfile\\result_data\\ptgui\\0100002\\2015\\10-02\\ptgui_project", "task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) {
        BufferedReader reader = null;
        String laststr = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr = laststr + tempString;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return laststr;
    }
}

