/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class DateUtil {
    private static String previousDateTime;

    public static synchronized String getUniqueDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = sdf.format(new Date());
        while (dateTime.equals(previousDateTime)) {
            dateTime = sdf.format(new Date());
        }
        previousDateTime = dateTime;
        return dateTime;
    }

    public static String longToDate(Long millSec) {
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date(millSec);
        return sdf.format(date);
    }

    public static String longToDateWithM(Long millSec) {
        String time = null;
        try {
            String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            Date date = new Date(millSec);
            time = sdf.format(date);
        }
        catch (Exception e) {
            return null;
        }
        return time;
    }

    public static String getDateTimeZone() {
        return new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date());
    }

    public static String getTimeZone() {
        return new SimpleDateFormat("HHmmssS").format(new Date());
    }

    public static String getCurrentDate(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String getDateTime(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static String getTime() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }

    public static boolean isDateAfter(String timeString, long rating) {
        try {
            Date date = DateUtil.addDay(timeString, rating);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            return nowmin - min > 600000L;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isAfter(String timeString, int rating) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(timeString);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            long count = rating * 60 * 1000;
            return nowmin - min > count;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBefore(String timeString, int rating) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(timeString);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            return nowmin - min < (long)(rating * 60 * 1000);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String formatDate(Date dDate, String sFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(sFormat);
        String dateString = formatter.format(dDate);
        return dateString;
    }

    public static String dateToString(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dDate);
        return dateString;
    }

    public static Date toDate(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dDate);
        return DateUtil.strToDate(dateString, "yyyy-MM-dd");
    }

    public static Date toDatetime(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dDate);
        return DateUtil.strToDate(dateString, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date strToDate(String s, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            Date theDate;
            Date date = theDate = formatter.parse(s);
            return date;
        }
        catch (Exception ex) {
            Date date1 = null;
            return date1;
        }
    }

    public static Date strToDateTime(String s) {
        return DateUtil.strToDate(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date strToDate(String s) {
        Date date = null;
        try {
            DateFormat df = DateFormat.getDateInstance();
            date = df.parse(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date addMinute(String sDate, long iNbTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(12, (int)iNbTime);
        Date date = cal.getTime();
        return date;
    }

    public static Date addHour(String sDate, long iNbTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(11, (int)iNbTime);
        Date date = cal.getTime();
        return date;
    }

    public static Date addDay(String sDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addDay(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date subDay(int days) {
        return DateUtil.addDay(-days);
    }

    public static Date subDay(Date specialDate, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(specialDate);
        cal.add(5, days);
        return DateUtil.addDay(-days);
    }

    public static Date addWeek(String sDate, long iNbWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(3, (int)iNbWeek);
        Date result = cal.getTime();
        return result;
    }

    public static Date addMonth(String sDate, int iNbMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        return cal.getTime();
    }

    public static Date addYear(Date dDate, int iNbYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int oldYear = cal.get(1);
        cal.set(1, iNbYear + oldYear);
        return cal.getTime();
    }

    public static int getWeek(Date dDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        return cal.get(7) - 1;
    }

    public static String getWeeks() {
        String[] dayNames = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        SimpleDateFormat sdfInput = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        try {
            date = sdfInput.parse(sdfInput.format(date));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        System.out.println("dayOfWeek:" + dayOfWeek);
        return dayNames[dayOfWeek - 1];
    }

    public static String getWeek(String sdate) {
        Date date = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static int getMonthOfDay(Date dDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        return cal.get(5);
    }

    public static int getMinuteOfHour(Date timeStamp) {
        if (timeStamp != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeStamp);
            return calendar.get(12);
        }
        return 0;
    }

    public static int getHourOfDay(Date timeStamp) {
        if (timeStamp != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeStamp);
            return calendar.get(11);
        }
        return 0;
    }

    public static String genRandomNum(int pwd_len) {
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return DateUtil.genRandNum(pwd_len, str);
    }

    public static String genRandNum(int pwd_len) {
        char[] str = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return DateUtil.genRandNum(pwd_len, str);
    }

    private static String genRandNum(int pwd_len, char[] str) {
        int maxNum = 36;
        int count = 0;
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String genRandomChar() {
        int maxNum = 25;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < 12) {
            int i = Math.abs(r.nextInt(25));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString().toUpperCase();
    }

    public static String getNowYear() {
        int year = Calendar.getInstance().get(1);
        return String.valueOf(year);
    }

    public static int getSeason() {
        int season = 0;
        int month = Calendar.getInstance().get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static long translateDateToSecond(Date date) {
        if (date != null) {
            return date.getTime() / 1000L;
        }
        return 0L;
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String encode(String src, String enCoding) {
        String target = null;
        if (src == null) {
            return null;
        }
        try {
            target = URLEncoder.encode(src, enCoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return target;
    }

    public static int getYearOfDate(Date date) {
        int year = 0;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            year = calendar.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return year;
    }

    public static int getMonthOfDate(Date date) {
        int month = 0;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            month = calendar.get(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return month;
    }

    public static int getDayOfDate(Date date) {
        int day = 0;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            day = calendar.get(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return day;
    }

    public static void main(String[] args) {
        Date date = new Date();
        System.out.println("\u5e74 \uff1a " + DateUtil.getYearOfDate(date));
        System.out.println("\u6708 \uff1a " + DateUtil.getMonthOfDate(date));
        System.out.println("\u65e5 \uff1a " + DateUtil.getDayOfDate(date));
    }
}

