/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CertUtils {
    public static Certificate[] getCerChain(String pcert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        keyStore.load(null, null);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] byt = decoder.decodeBuffer(pcert);
        ByteArrayInputStream sbs = new ByteArrayInputStream(byt);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> c = cf.generateCertificates(sbs);
        Iterator<? extends Certificate> i = c.iterator();
        Certificate[] certChain = null;
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            certChain = new Certificate[]{cert};
        }
        return certChain;
    }

    public static int writePfx(String alias, PrivateKey priv, String password, Certificate[] certChain, String path) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream out = null;
        KeyStore outputKeyStore = KeyStore.getInstance("pkcs12");
        outputKeyStore.load(null, null);
        outputKeyStore.setKeyEntry(alias, priv, password.toCharArray(), certChain);
        out = new FileOutputStream(path);
        outputKeyStore.store(out, password.toCharArray());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writePfx(String alias, PrivateKey priv, String password, Certificate[] certChain) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String res = null;
        try (ByteArrayOutputStream out = null;){
            KeyStore outputKeyStore = KeyStore.getInstance("pkcs12");
            outputKeyStore.load(null, null);
            outputKeyStore.setKeyEntry(alias, priv, password.toCharArray(), certChain);
            out = new ByteArrayOutputStream();
            outputKeyStore.store(out, password.toCharArray());
            byte[] resBytes = out.toByteArray();
            res = new BASE64Encoder().encode(resBytes).replace("\r", "").replace("\n", "");
        }
        return res;
    }

    public static byte[] DecKey(String EncryptedPrivateKey, String EncryptedSessionKey, PrivateKey priv) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] p = decoder.decodeBuffer(EncryptedPrivateKey);
        byte[] s = decoder.decodeBuffer(EncryptedSessionKey);
        ArrayUtils.reverse(s);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priv);
        byte[] plainSession = cipher.doFinal(s);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(plainSession);
        byte[] md5Value = md5.digest();
        SecretKeySpec key = new SecretKeySpec(md5Value, "RC4");
        Cipher ci = Cipher.getInstance("RC4");
        ci.init(2, key);
        byte[] enckey = ci.doFinal(p);
        return enckey;
    }

    public static PrivateKey bytPrivate(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey pri = keyFactory.generatePrivate(pkcs8KeySpec);
        return pri;
    }

    public static byte[] addArray(byte[] ... arrbyte) {
        byte[] result = new byte[]{};
        for (byte[] bs : arrbyte) {
            result = ArrayUtils.addAll(result, bs);
        }
        return result;
    }

    public static KeyPair getRsaBcKeyPair(int keyPairLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.addProvider(new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(keyPairLength, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        return keyPair;
    }

    public static byte[] parseEncKey(byte[] encKey) {
        byte[] result = null;
        result = 591 == encKey.length ? ArrayUtils.subarray(encKey, 259, 291) : ArrayUtils.subarray(encKey, 28, 60);
        return result;
    }

    public static byte[] parseRSAPrivateKey(byte[] prikey) {
        byte[] algId = new byte[]{0, 1, 0, 0};
        byte[] e = new byte[]{0, 1, 0, 1};
        if (prikey.length < 640 && prikey.length > 320) {
            byte[] n = Arrays.copyOfRange(prikey, 0, 128);
            byte[] p = Arrays.copyOfRange(prikey, 128, 192);
            byte[] q = Arrays.copyOfRange(prikey, 192, 256);
            byte[] dp = Arrays.copyOfRange(prikey, 256, 320);
            byte[] dq = Arrays.copyOfRange(prikey, 320, 384);
            byte[] coe = Arrays.copyOfRange(prikey, 384, 448);
            byte[] d = Arrays.copyOfRange(prikey, 448, 576);
            ArrayUtils.reverse(n);
            ArrayUtils.reverse(p);
            ArrayUtils.reverse(q);
            ArrayUtils.reverse(dp);
            ArrayUtils.reverse(dq);
            ArrayUtils.reverse(coe);
            ArrayUtils.reverse(d);
            byte[] mLen = new byte[]{0, 0, 4, 0};
            byte[] res = CertUtils.addArray(algId, mLen, n, e, d, p, q, dp, dq, coe);
            return res;
        }
        byte[] n = Arrays.copyOfRange(prikey, 0, 256);
        byte[] p = Arrays.copyOfRange(prikey, 256, 384);
        byte[] q = Arrays.copyOfRange(prikey, 384, 512);
        byte[] dp = Arrays.copyOfRange(prikey, 512, 640);
        byte[] dq = Arrays.copyOfRange(prikey, 640, 768);
        byte[] coe = Arrays.copyOfRange(prikey, 768, 896);
        byte[] d = Arrays.copyOfRange(prikey, 896, 1152);
        ArrayUtils.reverse(n);
        ArrayUtils.reverse(p);
        ArrayUtils.reverse(q);
        ArrayUtils.reverse(dp);
        ArrayUtils.reverse(dq);
        ArrayUtils.reverse(coe);
        ArrayUtils.reverse(d);
        byte[] mLen = new byte[]{0, 0, 8, 0};
        byte[] res = CertUtils.addArray(algId, mLen, n, e, d, p, q, dp, dq, coe);
        return res;
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = CertUtils.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509CertificateStructure getSM2CerByCertStr(String certStr) {
        ASN1Sequence seq = null;
        FilterInputStream aIn = null;
        X509CertificateStructure cert = null;
        BASE64Decoder bs = new BASE64Decoder();
        try {
            byte[] decodeBuffer = bs.decodeBuffer(certStr);
            aIn = new ASN1InputStream(new ByteArrayInputStream(decodeBuffer));
            seq = (ASN1Sequence)((ASN1InputStream)aIn).readObject();
            cert = new X509CertificateStructure(seq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != aIn) {
                try {
                    aIn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getRSAX509Certificate(String certStr) {
        X509Certificate x509Certificate = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(certStr));
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate2 = x509Certificate = (X509Certificate)certificateFactory.generateCertificate(bis);
            return x509Certificate2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

