/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.common.config;

import com.cwca.certServer.common.utils.DateUtil;
import com.cwca.certServer.common.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class ConfigHelper {
    private static Properties properties;
    private static String filePath;

    public static Properties loadProperties(String fileName) {
        return ConfigHelper.loadProperties(fileName, "");
    }

    public static Properties loadProperties(String fileName, String filePath) {
        Properties prop = new Properties();
        try {
            File file = FileUtil.getFile(fileName, filePath);
            if (file != null) {
                FileInputStream input = new FileInputStream(file);
                prop.load(new InputStreamReader((InputStream)input, "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static String getValue(String key) {
        String value = null;
        try {
            value = new String(properties.getProperty(key).getBytes(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static {
        System.out.println("[" + DateUtil.getDateTime() + "] Loading config.properties");
        try {
            filePath = FileUtil.getFilePath("config.properties", "");
            if (filePath != null) {
                properties = ConfigHelper.loadProperties("config.properties");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

