/*
 * Decompiled with CFR 0.152.
 */
package com.cwca.certServer.api;

import XiZangCertServicesEndPoint.services.client.hxra.aisino.com.XiZangCertServicesBeanProxy;
import com.cwca.certServer.common.config.ConfigHelper;
import com.cwca.certServer.domain.Cert;
import com.cwca.certServer.domain.OperatorCert;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertApi {
    private static final Logger LOG = LoggerFactory.getLogger(CertApi.class);
    private static XiZangCertServicesBeanProxy xcs;
    private static volatile CertApi certApi;
    private static boolean isInit;
    private static OperatorCert operatorCert;
    private static Map<String, OperatorCert> operatorCertMap;

    private CertApi() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertApi getInstance() {
        LOG.info("------>>>\u5f00\u59cb\u83b7\u53d6CertApi\u5b9e\u4f8b<<<------");
        if (!isInit) {
            LOG.info("------>>>\u672a\u8fdb\u884cinit\u521d\u59cb\u5316,\u5f00\u59cb\u8fdb\u884c\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316<<<------");
            try {
                CertApi.init_common(ConfigHelper.getValue("wb_ip"), ConfigHelper.getValue("wb_port"), ConfigHelper.getValue("useHTTPS"), ConfigHelper.getValue("jksPath"), ConfigHelper.getValue("certPath"), ConfigHelper.getValue("certPassword"));
                isInit = true;
                LOG.info("------>>>\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u6210\u529f<<<------");
            }
            catch (Exception e) {
                LOG.info("------>>>\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25<<<------");
                e.printStackTrace();
            }
        }
        if (null != certApi) return certApi;
        Class<CertApi> clazz = CertApi.class;
        synchronized (CertApi.class) {
            if (null != certApi) return certApi;
            certApi = new CertApi();
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return certApi;
        }
    }

    public static boolean init(String ip, String port, String useHTTPS, String jksPath, String certPath, String certPassword) {
        LOG.info("------>>>\u5f00\u59cb\u8c03\u7528init\u521d\u59cb\u5316<<<------");
        try {
            if (isInit) {
                LOG.info("------>>>init\u5df2\u521d\u59cb\u5316\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u521d\u59cb\u5316<<<------");
                return isInit;
            }
            CertApi.init_common(ip, port, useHTTPS, jksPath, certPath, certPassword);
            certApi = new CertApi();
            isInit = true;
            LOG.info("------>>>init\u521d\u59cb\u5316\u6210\u529f<<<------");
            return isInit;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        LOG.info("------>>>init\u521d\u59cb\u5316\u5931\u8d25<<<------");
        return isInit;
    }

    private static void init_common(String ip, String port, String useHTTPS, String jksPath, String ctPath, String ctPassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        xcs = new XiZangCertServicesBeanProxy(useHTTPS, ip, port);
        if ("1".equals(useHTTPS)) {
            System.setProperty("javax.net.ssl.trustStore", jksPath);
        }
        CertApi.loadCert(ctPath, ctPassword, "default");
        operatorCert = operatorCertMap.get("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCert(String ctPath, String ctPassword, String name) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        OperatorCert opc = new OperatorCert();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(ctPath));
            KeyStore adminKs = KeyStore.getInstance("PKCS12");
            adminKs.load(bis, ctPassword.toCharArray());
            Certificate certificate = adminKs.getCertificate(adminKs.aliases().nextElement());
            X509Certificate x = (X509Certificate)certificate;
            String operatorSn = x.getSerialNumber().toString(16).toUpperCase();
            opc.setCertPath(ctPath);
            opc.setCertPassword(ctPassword);
            opc.setOperatorSn(operatorSn);
            opc.setAdminKs(adminKs);
            operatorCertMap.put(name, opc);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean addOperator(String ctPath, String ctPassword, String name) {
        LOG.info("------>>>\u5f00\u59cb\u6dfb\u52a0\u64cd\u4f5c\u5458<<<------");
        boolean flag = false;
        try {
            if ("default".equalsIgnoreCase(name)) {
                LOG.info("------>>>\u6dfb\u52a0\u64cd\u4f5c\u5458\u7ed3\u675f,\u540d\u79f0\u4e0d\u80fd\u4e3adefault<<<------");
                return false;
            }
            CertApi.loadCert(ctPath, ctPassword, name);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        LOG.info("------>>>\u6dfb\u52a0\u64cd\u4f5c\u5458\u7ed3\u675f,\u7ed3\u679c: " + flag + "<<<------");
        return flag;
    }

    public static boolean switchOperator(String name) {
        LOG.info("------>>>\u5f00\u59cb\u5207\u6362\u64cd\u4f5c\u5458 : " + name + "<<<------");
        boolean flag = false;
        try {
            OperatorCert opc = operatorCertMap.get(name);
            if (null == operatorCert) {
                LOG.info("------>>>\u5207\u6362\u64cd\u4f5c\u5458\u7ed3\u675f,\u6ca1\u6709\u627e\u5230\u64cd\u4f5c\u5458 : " + name + "<<<------");
                return flag;
            }
            operatorCert = opc;
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        LOG.info("------>>>\u5207\u6362\u64cd\u4f5c\u5458\u7ed3\u675f,\u7ed3\u679c:" + flag + "<<<------");
        return flag;
    }

    public String se_generateCertBasic(String doubleFlag, String p10String, String dn, String ctId, String validity, String userType, String name, String credentialType, String credentialId, String phone, String email, String postcode, String address, String registeredAddress, String contactAddress, String linkmanName, String contactPhone, String transactorName, String transactorPhone, String transactorAddress, String transactorCredentialType, String transactorCredentialId, String tempPubKey) throws RemoteException {
        String sn = operatorCert.getOperatorSn();
        String result = xcs.generateCert(sn, doubleFlag, p10String, dn, ctId, validity, userType, name, credentialType, credentialId, phone, email, postcode, address, registeredAddress, contactAddress, linkmanName, contactPhone, transactorName, transactorPhone, transactorAddress, transactorCredentialType, transactorCredentialId, tempPubKey);
        return result;
    }

    public String se_updateCertBasic(String p10String, String sn, String tempPubKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, DocumentException, UnrecoverableKeyException, KeyStoreException, CertificateException {
        sn = sn.toUpperCase();
        String subject = xcs.getSubject(sn);
        Document dmt = DocumentHelper.parseText(subject);
        String dn = dmt.getRootElement().element("Msg").getText();
        Security.addProvider(new BouncyCastleProvider());
        String data = "xzca||" + sn + "||" + p10String;
        String sig = new String(Base64.encode(CertApi.adminCertSign(data.getBytes())));
        String updateCert = xcs.updateCert(p10String, sn, dn, tempPubKey, sig);
        return updateCert;
    }

    public String se_revokeCertByOper(String certSn, int reason) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        String operSn = operatorCert.getOperatorSn();
        certSn = certSn.toUpperCase();
        String data = "xzra||" + certSn + "||" + operSn;
        String sig = new String(Base64.encode(CertApi.adminCertSign(data.getBytes())));
        String revokeCertByOper = xcs.revokeCertByOper(certSn, reason, operSn, sig);
        return revokeCertByOper;
    }

    public String se_checkUpdateStatus(String sn) throws RemoteException {
        sn = sn.toUpperCase();
        String checkUpdateStatus = xcs.checkUpdateStatus(sn);
        return checkUpdateStatus;
    }

    private boolean se_modifyUpdateStatus(String sn, String status) throws RemoteException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, SignatureException {
        sn = sn.toUpperCase();
        String data = "xzra||" + sn;
        String sig = new String(Base64.encode(CertApi.adminCertSign(data.getBytes())));
        boolean modifyUpdateStatus = xcs.modifyUpdateStatus(sn, status, sig);
        return modifyUpdateStatus;
    }

    public String se_modifyUpdateStatusV2(String sn, String status) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, InvalidKeyException, SignatureException {
        sn = sn.toUpperCase();
        String operSn = operatorCert.getOperatorSn();
        String data = "xzra||" + sn + "||" + operSn;
        String sig = new String(Base64.encode(CertApi.adminCertSign(data.getBytes())));
        String result = xcs.modifyUpdateStatusV2(sn, status, operSn, sig);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cert getCert(String certPath, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Cert cert;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(new File(certPath)));
            KeyStore kst = KeyStore.getInstance("PKCS12");
            kst.load(bis, password.toCharArray());
            Certificate certificate = kst.getCertificate(kst.aliases().nextElement());
            X509Certificate x = (X509Certificate)certificate;
            int version = x.getVersion();
            String sn = x.getSerialNumber().toString(16).toUpperCase();
            cert = new Cert();
            cert.setVersion(version);
            cert.setSn(sn);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return cert;
    }

    public static Cert getAdminCert() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        Cert cert = CertApi.getCert(operatorCert.getCertPath(), operatorCert.getCertPassword());
        return cert;
    }

    public static byte[] adminCertSign(byte[] dataArr) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        String password = operatorCert.getCertPassword();
        PrivateKey prk = (PrivateKey)operatorCert.getAdminKs().getKey(operatorCert.getAdminKs().aliases().nextElement(), password.toCharArray());
        X509Certificate x509Certificate = (X509Certificate)operatorCert.getAdminKs().getCertificate(operatorCert.getAdminKs().aliases().nextElement());
        Signature sig = Signature.getInstance(x509Certificate.getSigAlgName());
        sig.initSign(prk);
        sig.update(dataArr);
        return sig.sign();
    }

    public static boolean adminCertVerify(byte[] data, byte[] sign) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509Certificate x509Certificate = (X509Certificate)operatorCert.getAdminKs().getCertificate(operatorCert.getAdminKs().aliases().nextElement());
        Signature sig = Signature.getInstance(x509Certificate.getSigAlgName());
        PublicKey publicKey = x509Certificate.getPublicKey();
        sig.initVerify(publicKey);
        sig.update(data);
        return sig.verify(sign);
    }

    public static byte[] addArray(byte[] ... arrbyte) {
        byte[] result = new byte[]{};
        for (byte[] bs : arrbyte) {
            result = ArrayUtils.addAll(result, bs);
        }
        return result;
    }

    public String getVersion() {
        return "1.0.2.20200702";
    }

    static {
        isInit = false;
        operatorCertMap = new HashMap<String, OperatorCert>();
    }
}

