/*
 * Decompiled with CFR 0.152.
 */
package com.aisino.xbrl.util;

import com.aisino.xbrl.bean.ELR;
import com.aisino.xbrl.bean.EinvoiceIssuer;
import com.aisino.xbrl.bean.EinvoiceIssuerDetailItems;
import com.aisino.xbrl.bean.EinvoiceReceiver;
import com.aisino.xbrl.bean.InformationOfAccountingDocumentsTuple;
import com.aisino.xbrl.bean.InformationOfDebitAndCreditEntryTuple;
import com.aisino.xbrl.enums.ElrType;
import com.aisino.xbrl.util.ComUtil;
import com.aisino.xbrl.util.FileUtil;
import com.aisino.xbrl.util.GsonUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XbrlApi {
    private static Map<String, String> templateCache = new HashMap<String, String>();
    public static final String CHARSET_DEF = "UTF-8";
    private static String templatePath = "";
    public static List<String> setAttrs = Arrays.asList("contextRef", "decimals", "unitRef");
    public static List<String> elrCodes = Arrays.asList("100301", "100302", "100303", "100304", "100305", "100306");
    public static ArrayList<String> issuerFieldNames = new ArrayList();
    public static ArrayList<String> itemFieldNames = new ArrayList();
    public static ArrayList<String> receiverFieldNames = new ArrayList();
    public static ArrayList<String> docTupleFieldNames = new ArrayList();
    public static ArrayList<String> debitTupleFieldNames = new ArrayList();

    private static void setAttrs(Element ele, Map<String, String> attrsMap) {
        for (String setAttr : setAttrs) {
            Attribute attr = ele.attribute(setAttr);
            if (attr == null) continue;
            switch (setAttr) {
                case "contextRef": {
                    attr.setValue(attrsMap.get("contextRef"));
                    break;
                }
                case "decimals": {
                    String text = ele.getText();
                    attr.setValue(ComUtil.getDecimalsBits(text));
                    break;
                }
                case "unitRef": {
                    attr.setValue(attrsMap.get("unitRef"));
                    break;
                }
            }
        }
    }

    private static void setVal(Element ele, Object obj, Map<String, String> attrsMap) {
        try {
            Class<?> aClass = obj.getClass();
            Field field = aClass.getDeclaredField(ComUtil.firstCharToLowerCase(ele.getName()));
            if (field != null) {
                field.setAccessible(true);
                Object valObj = field.get(obj);
                if (valObj == null) {
                    ele.getParent().remove(ele);
                } else {
                    String val = (String)valObj;
                    if (StringUtils.isEmpty(val)) {
                        ele.getParent().remove(ele);
                    } else {
                        ele.setText(val);
                        XbrlApi.setAttrs(ele, attrsMap);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("setVal Exception: " + e);
        }
    }

    private static void setDoc(Element rootElement, EinvoiceIssuer issuer) {
        boolean isAirTicket = false;
        isAirTicket = StringUtils.isNotEmpty(issuer.getNumberOfAirTransportReceipt());
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        String dateOfIssue = "";
        String contextId = "";
        String unitId = rootElement.element("unit").attribute("id").getValue();
        if (isAirTicket) {
            dateOfIssue = issuer.getIssueDate();
            contextId = "C1";
        } else {
            dateOfIssue = issuer.getDateOfIssue();
            contextId = ("As_Of_" + dateOfIssue).replaceAll("-", "_");
        }
        attrsMap.put("contextRef", contextId);
        attrsMap.put("unitRef", unitId);
        String taxpayerIdentificationNumberOfSeller = "";
        taxpayerIdentificationNumberOfSeller = isAirTicket ? issuer.getIssueParty() : issuer.getTaxpayerIdentificationNumberOfSeller();
        String specialInvoiceType = issuer.getSpecialInvoiceType();
        String codeOfELR = issuer.getCodeOfELR();
        boolean isTollFee = false;
        if ("100303".equals(codeOfELR)) {
            isTollFee = true;
        }
        List<EinvoiceIssuerDetailItems> einvoiceIssuerDetailItems = issuer.getEinvoiceIssuerDetailItems();
        Element goodsItemEle = rootElement.element("InformationOfTaxableGoodsOrServicesDetailItemsTuple");
        Element tollFeeItemEle = rootElement.element("InformationOfTollFeeDetailItemsTuple");
        Element airTicketItemEle = rootElement.element("DetailInformationOfAirTicketTuple");
        if (einvoiceIssuerDetailItems == null || einvoiceIssuerDetailItems.size() == 0) {
            if (goodsItemEle != null) {
                rootElement.remove(goodsItemEle);
            }
            if (tollFeeItemEle != null) {
                rootElement.remove(tollFeeItemEle);
            }
            if (airTicketItemEle != null) {
                rootElement.remove(airTicketItemEle);
            }
        } else {
            int detailItemSizes;
            Element cloneEle;
            if (!elrCodes.contains(codeOfELR)) {
                EinvoiceIssuerDetailItems detailItem1 = einvoiceIssuerDetailItems.get(0);
                isTollFee = StringUtils.isNotEmpty(detailItem1.getNameOfTollFeeItems()) || StringUtils.isNotEmpty(detailItem1.getPlateNumber()) || StringUtils.isNotEmpty(detailItem1.getTypesOfVehicle()) || StringUtils.isNotEmpty(detailItem1.getEntranceDate()) || StringUtils.isNotEmpty(detailItem1.getExitDate()) || "\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968".equals(issuer.getTypeOfInvoice()) || specialInvoiceType != null && specialInvoiceType.contains("\u901a\u884c\u8d39");
                boolean bl = isAirTicket = StringUtils.isNotEmpty(detailItem1.getCarrier()) || StringUtils.isNotEmpty(detailItem1.getClazz()) || StringUtils.isNotEmpty(detailItem1.getFlight());
            }
            if (isTollFee) {
                cloneEle = tollFeeItemEle;
                if (goodsItemEle != null) {
                    rootElement.remove(goodsItemEle);
                }
                if (airTicketItemEle != null) {
                    rootElement.remove(airTicketItemEle);
                }
            } else if (isAirTicket) {
                cloneEle = airTicketItemEle;
                if (goodsItemEle != null) {
                    rootElement.remove(goodsItemEle);
                }
                if (tollFeeItemEle != null) {
                    rootElement.remove(tollFeeItemEle);
                }
            } else {
                cloneEle = goodsItemEle;
                if (tollFeeItemEle != null) {
                    rootElement.remove(tollFeeItemEle);
                }
                if (airTicketItemEle != null) {
                    rootElement.remove(airTicketItemEle);
                }
            }
            if ((detailItemSizes = einvoiceIssuerDetailItems.size()) > 1) {
                for (int i = 0; i < detailItemSizes - 1; ++i) {
                    rootElement.add((Element)cloneEle.clone());
                }
            }
        }
        int detailItemIndex = 0;
        block15: for (Element ele : rootElement.elements()) {
            String fieldName;
            String eleName = ele.getName();
            switch (fieldName = ComUtil.firstCharToLowerCase(eleName)) {
                case "schemaRef": {
                    break;
                }
                case "context": {
                    ele.attribute("id").setValue(contextId);
                    ele.element("entity").element("identifier").setText(taxpayerIdentificationNumberOfSeller);
                    ele.element("period").element("instant").setText(dateOfIssue);
                    break;
                }
                case "unit": {
                    break;
                }
                case "informationOfTaxableGoodsOrServicesDetailItemsTuple": 
                case "detailInformationOfAirTicketTuple": 
                case "informationOfTollFeeDetailItemsTuple": {
                    EinvoiceIssuerDetailItems item = einvoiceIssuerDetailItems.get(detailItemIndex);
                    ++detailItemIndex;
                    for (Element itemEle : ele.elements()) {
                        String itemEleFieldName = ComUtil.firstCharToLowerCase(itemEle.getName());
                        if (!itemFieldNames.contains(itemEleFieldName)) continue;
                        XbrlApi.setVal(itemEle, item, attrsMap);
                    }
                    continue block15;
                }
                default: {
                    if (!issuerFieldNames.contains(fieldName)) continue block15;
                    XbrlApi.setVal(ele, issuer, attrsMap);
                }
            }
        }
    }

    private static void setDoc(Element rootElement, EinvoiceReceiver receiver) {
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        String postingDate = "";
        List<InformationOfAccountingDocumentsTuple> docTupleList = receiver.getInformationOfAccountingDocumentsTuple();
        Element informationOfAccountingDocumentsTuple = rootElement.element("InformationOfAccountingDocumentsTuple");
        if (docTupleList == null || docTupleList.size() == 0) {
            rootElement.remove(informationOfAccountingDocumentsTuple);
        } else {
            int docTupulSizes = docTupleList.size();
            if (docTupulSizes > 1) {
                for (int i = 0; i < docTupulSizes - 1; ++i) {
                    rootElement.add((Element)informationOfAccountingDocumentsTuple.clone());
                }
            }
            postingDate = docTupleList.get(0).getPostingDate();
        }
        String contextId = ("As_Of_" + postingDate).replaceAll("-", "_");
        attrsMap.put("contextRef", contextId);
        attrsMap.put("unitRef", rootElement.element("unit").attribute("id").getValue());
        String unifiedSocialCreditCodeOfAccountingEntity = receiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        int docIndex = 0;
        block13: for (Element ele : rootElement.elements()) {
            String fieldName;
            String eleName = ele.getName();
            switch (fieldName = ComUtil.firstCharToLowerCase(eleName)) {
                case "schemaRef": {
                    break;
                }
                case "context": {
                    ele.attribute("id").setValue(contextId);
                    ele.element("entity").element("identifier").setText(unifiedSocialCreditCodeOfAccountingEntity);
                    ele.element("period").element("instant").setText(postingDate);
                    break;
                }
                case "unit": {
                    break;
                }
                case "informationOfAccountingDocumentsTuple": {
                    InformationOfAccountingDocumentsTuple docItem = docTupleList.get(docIndex);
                    ++docIndex;
                    List<InformationOfDebitAndCreditEntryTuple> debitTupleList = docItem.getInformationOfDebitAndCreditEntryTuple();
                    Element informationOfDebitAndCreditEntryTuple = ele.element("InformationOfDebitAndCreditEntryTuple");
                    if (debitTupleList == null || debitTupleList.size() == 0) {
                        ele.remove(informationOfDebitAndCreditEntryTuple);
                    } else {
                        int debitTupleSize = debitTupleList.size();
                        if (debitTupleSize > 1) {
                            for (int i = 0; i < debitTupleSize - 1; ++i) {
                                ele.add((Element)informationOfDebitAndCreditEntryTuple.clone());
                            }
                        }
                    }
                    int debitTupleIndex = 0;
                    for (Element docItemEle : ele.elements()) {
                        String docItemEleFieldName = ComUtil.firstCharToLowerCase(docItemEle.getName());
                        if ("informationOfDebitAndCreditEntryTuple".equals(docItemEleFieldName)) {
                            InformationOfDebitAndCreditEntryTuple debitItem = debitTupleList.get(debitTupleIndex);
                            ++debitTupleIndex;
                            for (Element debitEle : docItemEle.elements()) {
                                String debitEleFieldName = ComUtil.firstCharToLowerCase(debitEle.getName());
                                if (!debitTupleFieldNames.contains(debitEleFieldName)) continue;
                                XbrlApi.setVal(debitEle, debitItem, attrsMap);
                            }
                            continue;
                        }
                        if (!docTupleFieldNames.contains(docItemEleFieldName)) continue;
                        XbrlApi.setVal(docItemEle, docItem, attrsMap);
                    }
                    continue block13;
                }
                default: {
                    if (!receiverFieldNames.contains(fieldName)) continue block13;
                    XbrlApi.setVal(ele, receiver, attrsMap);
                }
            }
        }
    }

    private static String generateXBRL(ELR elr, String templateName) {
        return XbrlApi.generateXBRL(elr, templateName, OutputFormat.createPrettyPrint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateXBRL(ELR elr, String templateName, OutputFormat xbrlFormat) {
        String result = "";
        StringWriter stringWriter = null;
        XMLWriter xmlWriter = null;
        try {
            String template = null;
            if (templateCache.containsKey(templateName)) {
                template = templateCache.get(templateName);
            } else {
                template = ComUtil.readResource("template", templateName);
                templateCache.put(templateName, template);
            }
            Document doc = DocumentHelper.parseText(template);
            Element rootElement = doc.getRootElement();
            if (elr instanceof EinvoiceIssuer) {
                XbrlApi.setDoc(rootElement, (EinvoiceIssuer)elr);
            } else if (elr instanceof EinvoiceReceiver) {
                XbrlApi.setDoc(rootElement, (EinvoiceReceiver)elr);
            }
            stringWriter = new StringWriter();
            xmlWriter = new XMLWriter(stringWriter, xbrlFormat);
            xmlWriter.write(doc);
            result = stringWriter.toString();
        }
        catch (IOException | DocumentException e) {
            System.err.println("generateXBRL Exception: " + e);
        }
        finally {
            try {
                if (stringWriter != null) {
                    stringWriter.close();
                }
            }
            catch (IOException e) {
                System.err.println("generateXBRL stringWriter Exception: " + e);
            }
            try {
                if (xmlWriter != null) {
                    xmlWriter.close();
                }
            }
            catch (IOException e) {
                System.err.println("generateXBRL xmlWriter Exception: " + e);
            }
        }
        return result;
    }

    public static String getXbrl(EinvoiceIssuer einvoiceIssuer) {
        ElrType elrEnum = ElrType.getByELR(einvoiceIssuer);
        return XbrlApi.generateXBRL(einvoiceIssuer, elrEnum.getTemplate());
    }

    public static String getXbrl(EinvoiceReceiver einvoiceReceiver) {
        ElrType elrEnum = ElrType.getByELR(einvoiceReceiver);
        return XbrlApi.generateXBRL(einvoiceReceiver, elrEnum.getTemplate());
    }

    public static String getXbrl(ELR elr) {
        ElrType elrEnum = ElrType.getByELR(elr);
        return XbrlApi.generateXBRL(elr, elrEnum.getTemplate());
    }

    public static void getXbrl(ELR elr, String filePath) throws IOException {
        String xbrl = XbrlApi.getXbrl(elr);
        FileUtil.save(xbrl, filePath);
    }

    public static String getXbrl(String json, Class<? extends ELR> tClass) throws Exception {
        ELR elr = GsonUtil.fromJson(json, tClass);
        ElrType elrEnum = ElrType.getByELR(elr);
        return XbrlApi.generateXBRL(elr, elrEnum.getTemplate());
    }

    @Deprecated
    public static String xbrl2JSON(String xbrlSrc) throws DocumentException {
        JsonObject xml2json = new JsonObject();
        Document document = DocumentHelper.parseText(xbrlSrc);
        Element rootElement = document.getRootElement();
        ComUtil.dom4j2Json(rootElement, xml2json);
        return xml2json.toString();
    }

    public static <T> T xbrl2ELR(String xbrlStr, Class<T> tClass) throws Exception {
        return GsonUtil.fromJson(XbrlApi.xbrl2JSON(xbrlStr), tClass);
    }

    static {
        templatePath = Thread.currentThread().getContextClassLoader().getResource("template").toString().replaceFirst("file:/", "");
        String osName = System.getProperty("os.name");
        if (!osName.toLowerCase().startsWith("win")) {
            templatePath = "/" + templatePath;
        }
        for (Field field : EinvoiceIssuer.class.getDeclaredFields()) {
            issuerFieldNames.add(field.getName());
        }
        for (Field field : EinvoiceIssuerDetailItems.class.getDeclaredFields()) {
            itemFieldNames.add(field.getName());
        }
        for (Field field : EinvoiceReceiver.class.getDeclaredFields()) {
            receiverFieldNames.add(field.getName());
        }
        for (Field field : InformationOfAccountingDocumentsTuple.class.getDeclaredFields()) {
            docTupleFieldNames.add(field.getName());
        }
        for (Field field : InformationOfDebitAndCreditEntryTuple.class.getDeclaredFields()) {
            debitTupleFieldNames.add(field.getName());
        }
    }
}

