/*
 * Decompiled with CFR 0.152.
 */
package com.aisino.xbrl.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ComUtil {
    public static void dom4j2Json(Element rootElement, JsonObject json) {
        List childElements = rootElement.elements();
        if (childElements.isEmpty() && StringUtils.isNotEmpty(rootElement.getText())) {
            json.addProperty(ComUtil.firstCharToLowerCase(rootElement.getName()), rootElement.getText());
        }
        for (Element e : childElements) {
            if (!e.elements().isEmpty()) {
                JsonArray jsonArr;
                JsonObject childJson = new JsonObject();
                ComUtil.dom4j2Json(e, childJson);
                JsonElement jsonElement = json.get(ComUtil.firstCharToLowerCase(e.getName()));
                if (jsonElement != null) {
                    jsonArr = null;
                    if (jsonElement.isJsonObject()) {
                        json.remove(ComUtil.firstCharToLowerCase(e.getName()));
                        jsonArr = new JsonArray();
                        jsonArr.add(jsonElement);
                        jsonArr.add(childJson);
                    }
                    if (jsonElement.isJsonArray()) {
                        jsonArr = jsonElement.getAsJsonArray();
                        jsonArr.add(childJson);
                    }
                    json.add(ComUtil.firstCharToLowerCase(e.getName()), jsonArr);
                    continue;
                }
                if (childJson.isJsonNull()) continue;
                if (e.getName() != null && e.getName().endsWith("Tuple")) {
                    jsonArr = new JsonArray();
                    jsonArr.add(childJson);
                    json.add(ComUtil.firstCharToLowerCase(e.getName()), jsonArr);
                    continue;
                }
                json.add(ComUtil.firstCharToLowerCase(e.getName()), childJson);
                continue;
            }
            if (e.getText().isEmpty()) continue;
            json.addProperty(ComUtil.firstCharToLowerCase(e.getName()), e.getText());
        }
    }

    public static String firstCharToLowerCase(String src) {
        if (StringUtils.isNotEmpty(src)) {
            src = src.substring(0, 1).toLowerCase() + src.substring(1);
        }
        if ("class".equals(src)) {
            src = "clazz";
        }
        return src;
    }

    public static String getDecimalsBits(String src) {
        String bit = "0";
        if (StringUtils.isNotEmpty(src) && src.lastIndexOf(".") >= 0) {
            String dotStr = src.trim();
            dotStr = dotStr.substring(dotStr.lastIndexOf("."));
            bit = dotStr.length() - 1 + "";
        }
        return bit;
    }

    public static void jsonConvert(JsonElement element, JsonObject newJson, JsonElement parent, String key) {
        if (element.isJsonArray()) {
            JsonArray newArr = new JsonArray();
            if (parent != null) {
                if (parent.isJsonArray()) {
                    parent.getAsJsonArray().add(newArr);
                } else {
                    parent.getAsJsonObject().add(key, newArr);
                }
            } else {
                newJson.add(key, newArr);
            }
            JsonArray jsonArray = element.getAsJsonArray();
            if (jsonArray.size() != 0) {
                for (JsonElement ele : jsonArray) {
                    ComUtil.jsonConvert(ele, newJson, newArr, key);
                }
            }
        } else if (element.isJsonObject()) {
            JsonObject newObj = newJson;
            if (parent != null && parent.isJsonArray()) {
                newObj = new JsonObject();
                parent.getAsJsonArray().add(newObj);
            }
            JsonObject asJsonObject = element.getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : asJsonObject.entrySet()) {
                ComUtil.jsonConvert(entry.getValue(), newJson, newObj, ComUtil.firstCharToLowerCase(entry.getKey()));
            }
        } else if (parent != null) {
            if (parent.isJsonArray()) {
                parent.getAsJsonArray().add(element);
            } else {
                parent.getAsJsonObject().add(key, element);
            }
        } else {
            newJson.add(key, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String directory, String file) {
        StringBuilder str = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = ComUtil.class.getResourceAsStream("/" + directory + "/" + file);
            br = new BufferedReader(new InputStreamReader(inputStream));
            String readStr = null;
            while ((readStr = br.readLine()) != null) {
                str.append(readStr);
            }
        }
        catch (IOException e) {
            System.err.println("readResource Exception: " + e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                System.err.println("readResource Exception: " + e);
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                System.err.println("readResource Exception: " + e);
            }
        }
        return str.toString();
    }
}

