/*
 * Decompiled with CFR 0.152.
 */
package com.aisino.xbrl.enums;

import com.aisino.xbrl.bean.ELR;
import com.aisino.xbrl.bean.EinvoiceIssuer;
import com.aisino.xbrl.bean.EinvoiceReceiver;

public enum ElrType {
    ORDINARY_EINVOICE_ISSUER("100301", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u5f00\u5177\u65b9", EinvoiceIssuer.class, "100301.xml", "100301 - Document - Ordinary VAT e-invoice - issuer \uff08\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u5f00\u5177\u65b9\uff09"),
    SPECIAL_EINVOICE_ISSUER("100302", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968-\u5f00\u5177\u65b9", EinvoiceIssuer.class, "100302.xml", "100302 - Document - Special VAT e-invoice - issuer \uff08\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968-\u5f00\u5177\u65b9\uff09"),
    ORDINARY_EINVOICE_OF_TOLL_FEE_ISSUER("100303", "\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u5f00\u5177\u65b9", EinvoiceIssuer.class, "100303.xml", "100303 - Document - Ordinary VAT e-invoice of toll fee - issuer \uff08\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u5f00\u5177\u65b9\uff09"),
    ORDINARY_EINVOICE_RECEIVER("100304", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u63a5\u6536\u65b9", EinvoiceReceiver.class, "100304.xml", "100304 - Document - Ordinary VAT e-invoice - receiver \uff08\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u63a5\u6536\u65b9\uff09"),
    SPECIAL_EINVOICE_RECEIVER("100305", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968-\u63a5\u6536\u65b9", EinvoiceReceiver.class, "100305.xml", "100305 - Document - Special VAT e-invoice - receiver \uff08\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968-\u63a5\u6536\u65b9\uff09"),
    ORDINARY_EINVOICE_OF_TOLL_FEE_RECEIVER("100306", "\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u63a5\u6536\u65b9", EinvoiceReceiver.class, "100306.xml", "100306 - Document - Ordinary VAT e-invoice of toll fee - receiver \uff08\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968-\u63a5\u6536\u65b9\uff09"),
    ITINERARY_EINVOICE_OF_AIRTICKET_ISSUER("100307", "\u822a\u7a7a\u8fd0\u8f93\u5ba2\u7968\u7535\u5b50\u884c\u7a0b\u5355-\u5f00\u5177\u65b9", EinvoiceReceiver.class, "100307.xml", "100307 - Document - air Transport Ticket Electronic Itinerary - issuer \uff08\u822a\u7a7a\u8fd0\u8f93\u5ba2\u7968\u7535\u5b50\u884c\u7a0b\u5355-\u5f00\u5177\u65b9\uff09"),
    ISSUER("issuer", "\u5f00\u5177\u65b9", EinvoiceIssuer.class, "issuer.xml", "\u5f00\u5177\u65b9\u901a\u7528"),
    RECEIVER("receiver", "\u63a5\u6536\u65b9", EinvoiceReceiver.class, "receiver.xml", "\u63a5\u6536\u65b9\u901a\u7528");

    private String code;
    private String name;
    private String template;
    private String desc;
    private Class<? extends ELR> clazz;

    private ElrType(String code, String name, Class<? extends ELR> clazz, String template, String desc) {
        this.code = code;
        this.name = name;
        this.clazz = clazz;
        this.template = template;
        this.desc = desc;
    }

    public static ElrType getByELR(ELR elr) {
        for (ElrType elrIns : ElrType.values()) {
            if (!elrIns.getCode().equals(elr.getCodeOfELR())) continue;
            return elrIns;
        }
        if (elr instanceof EinvoiceReceiver) {
            return RECEIVER;
        }
        if (elr instanceof EinvoiceIssuer) {
            return ISSUER;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public ElrType setCode(String code) {
        this.code = code;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ElrType setName(String name) {
        this.name = name;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public ElrType setTemplate(String template) {
        this.template = template;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public ElrType setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public Class<? extends ELR> getClazz() {
        return this.clazz;
    }

    public ElrType setClazz(Class<? extends ELR> clazz) {
        this.clazz = clazz;
        return this;
    }

    public String toString() {
        return "XbrlELR{code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", template='" + this.template + '\'' + ", className=" + this.clazz.getName() + '}';
    }
}

