/*
 * Decompiled with CFR 0.152.
 */
package com.aisino.xbrl.convert;

import com.aisino.xbrl.bean.ELR;
import com.aisino.xbrl.bean.EinvoiceIssuer;
import com.aisino.xbrl.bean.EinvoiceReceiver;
import com.aisino.xbrl.convert.Xbrl;
import com.aisino.xbrl.enums.ElrType;
import com.aisino.xbrl.util.GsonUtil;
import com.aisino.xbrl.util.XbrlApi;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;

public class XbrlConvertor
implements Xbrl {
    private OutputFormat xbrlFormat;
    private String charset = "UTF-8";

    public XbrlConvertor(String charset, OutputFormat xbrlFormat) {
        this.charset = charset;
        this.xbrlFormat = xbrlFormat;
    }

    public OutputFormat getXbrlFormat() {
        if (this.xbrlFormat == null) {
            return OutputFormat.createCompactFormat();
        }
        return this.xbrlFormat;
    }

    public XbrlConvertor setXbrlFormat(OutputFormat xbrlFormat) {
        this.xbrlFormat = xbrlFormat;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public XbrlConvertor setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String toXbrl(EinvoiceIssuer einvoiceIssuer) {
        ElrType elrEnum = ElrType.getByELR(einvoiceIssuer);
        return XbrlApi.generateXBRL(einvoiceIssuer, elrEnum.getTemplate(), this.getXbrlFormat());
    }

    @Override
    public String toXbrl(EinvoiceReceiver einvoiceReceiver) {
        ElrType elrEnum = ElrType.getByELR(einvoiceReceiver);
        return XbrlApi.generateXBRL(einvoiceReceiver, elrEnum.getTemplate(), this.getXbrlFormat());
    }

    @Override
    public String toXbrl(ELR elr) {
        ElrType elrEnum = ElrType.getByELR(elr);
        return XbrlApi.generateXBRL(elr, elrEnum.getTemplate(), this.getXbrlFormat());
    }

    @Override
    public void toXbrl(ELR elr, String filePath) throws IOException {
        String xbrl = this.toXbrl(elr);
        Files.write(Paths.get(filePath, new String[0]), xbrl.getBytes(this.charset), new OpenOption[0]);
    }

    @Override
    public String toXbrl(String json, Class<? extends ELR> tClass) throws Exception {
        ELR elr = GsonUtil.fromJson(json, tClass);
        ElrType elrEnum = ElrType.getByELR(elr);
        return XbrlApi.generateXBRL(elr, elrEnum.getTemplate(), this.getXbrlFormat());
    }

    @Override
    @Deprecated
    public String toJSON(String xbrlSrc) throws DocumentException {
        return XbrlApi.xbrl2JSON(xbrlSrc);
    }

    @Override
    public <T> T toBean(String xbrlStr, Class<T> tClass) throws Exception {
        return XbrlApi.xbrl2ELR(xbrlStr, tClass);
    }
}

