/*
 * Decompiled with CFR 0.152.
 */
package com.aisino.ofd.signature.utils;

import com.aisino.ofd.signature.signature.PDFTest;
import java.math.BigInteger;
import java.security.MessageDigest;

public class SM3Digest
extends MessageDigest {
    public static final byte[] ecc_a = new BigInteger(PDFTest.anyValidIdentifierName("5O5O5O5L5O5O5O5O5O5O5O5O5O5O5O5O5O5O5O5OC9C9C9C95O5O5O5O5O5O5O5J"), 16).toByteArray();
    public static final byte[] ecc_b = new BigInteger(PDFTest.anyValidIdentifierName("A1605HJLJMJOFL@=GMFHJLGK0OE<C02>5:J>K05<B<2KKOJ;7M1J1MG8GMJ=CLJ:"), 16).toByteArray();
    public static final byte[] ecc_gx = new BigInteger(PDFTest.anyValidIdentifierName("@;0=2LAJBOB0K8B0FOJ0C=G?EH@000J=KO6:CK1O5;E?CK68D8FHG<K0@:GJD=0>"), 16).toByteArray();
    public static final byte[] ecc_gy = new BigInteger(PDFTest.anyValidIdentifierName("1J@>@?2;5=5?D>JJF01M0L6:EKE0A8F:7920K>DJ0?AHG>G9C;7O@;6<A8@05929"), 16).toByteArray();
    public static final byte[] USER_ID = PDFTest.anyValidIdentifierName("B;@=F?D1B;@=F?D1").getBytes();
    public static final int DIGEST_LENGTH = 32;
    private int[] H;
    private int[] X;
    private int xOff;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;

    public SM3Digest() {
        super(PDFTest.anyValidIdentifierName("Z>:"));
        SM3Digest IiiIiIiiII;
        IiiIiIiiII.xBuf = new byte[4];
        IiiIiIiiII.X = new int[16];
        IiiIiIiiII.H = new int[8];
        IiiIiIiiII.engineReset();
    }

    public SM3Digest(SM3Digest IiiIiIiiII) {
        super(PDFTest.anyValidIdentifierName("Z>:"));
        SM3Digest IiiIiIiiII2;
        IiiIiIiiII2.xBuf = (byte[])IiiIiIiiII.xBuf.clone();
        IiiIiIiiII2.xBufOff = IiiIiIiiII.xBufOff;
        IiiIiIiiII2.byteCount = IiiIiIiiII.byteCount;
        IiiIiIiiII2.X = (int[])IiiIiIiiII.X.clone();
        IiiIiIiiII2.xOff = IiiIiIiiII.xOff;
        IiiIiIiiII2.H = (int[])IiiIiIiiII.H.clone();
    }

    public void setPublicKey(byte[] IiiIiIiiII) {
        byte[] IiiIiIiiII2 = new byte[64];
        if (IiiIiIiiII != null && IiiIiIiiII.length == 65 && IiiIiIiiII[0] == 4) {
            SM3Digest IiiIiIiiII3;
            System.arraycopy(IiiIiIiiII, 1, IiiIiIiiII2, 0, 64);
            byte[] IiiIiIiiII4 = SM3Digest.getSignDigestHead(IiiIiIiiII2);
            IiiIiIiiII3.engineUpdate(IiiIiIiiII4, 0, IiiIiIiiII4.length);
        }
    }

    private static byte[] getSignDigestHead(byte[] IiiIiIiiII) {
        SM3Digest IiiIiIiiII2 = new SM3Digest();
        IiiIiIiiII2.engineUpdate((byte)(USER_ID.length >> 5));
        IiiIiIiiII2.engineUpdate((byte)(USER_ID.length << 3));
        IiiIiIiiII2.engineUpdate(USER_ID, 0, USER_ID.length);
        IiiIiIiiII2.engineUpdate(ecc_a, ecc_a.length - 32, 32);
        IiiIiIiiII2.engineUpdate(ecc_b, ecc_b.length - 32, 32);
        IiiIiIiiII2.engineUpdate(ecc_gx, ecc_gx.length - 32, 32);
        IiiIiIiiII2.engineUpdate(ecc_gy, ecc_gy.length - 32, 32);
        IiiIiIiiII2.engineUpdate(IiiIiIiiII, 0, IiiIiIiiII.length);
        return IiiIiIiiII2.engineDigest();
    }

    public String getAlgorithmName() {
        return PDFTest.anyValidIdentifierName("Z>:");
    }

    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void engineReset() {
        SM3Digest IiiIiIiiII;
        int IiiIiIiiII2;
        IiiIiIiiII.byteCount = 0L;
        IiiIiIiiII.xBufOff = 0;
        for (IiiIiIiiII2 = 0; IiiIiIiiII2 < IiiIiIiiII.xBuf.length; ++IiiIiIiiII2) {
            IiiIiIiiII.xBuf[IiiIiIiiII2] = 0;
        }
        IiiIiIiiII.H[0] = 1937774191;
        IiiIiIiiII.H[1] = 1226093241;
        IiiIiIiiII.H[2] = 388252375;
        IiiIiIiiII.H[3] = -628488704;
        IiiIiIiiII.H[4] = -1452330820;
        IiiIiIiiII.H[5] = 372324522;
        IiiIiIiiII.H[6] = -477237683;
        IiiIiIiiII.H[7] = -1325724082;
        IiiIiIiiII.xOff = 0;
        for (IiiIiIiiII2 = 0; IiiIiIiiII2 < IiiIiIiiII.X.length; ++IiiIiIiiII2) {
            IiiIiIiiII.X[IiiIiIiiII2] = 0;
        }
    }

    @Override
    protected byte[] engineDigest() {
        SM3Digest IiiIiIiiII;
        byte[] IiiIiIiiII2 = new byte[32];
        IiiIiIiiII.doFinal(IiiIiIiiII2, 0);
        return IiiIiIiiII2;
    }

    @Override
    protected void engineUpdate(byte[] IiiIiIiiII, int IiiIiIiiII2, int IiiIiIiiII3) {
        SM3Digest IiiIiIiiII4;
        while (IiiIiIiiII4.xBufOff != 0 && IiiIiIiiII3 > 0) {
            IiiIiIiiII4.engineUpdate(IiiIiIiiII[IiiIiIiiII2]);
            ++IiiIiIiiII2;
            --IiiIiIiiII3;
        }
        while (IiiIiIiiII3 > IiiIiIiiII4.xBuf.length) {
            IiiIiIiiII4.processWord(IiiIiIiiII, IiiIiIiiII2);
            IiiIiIiiII2 += IiiIiIiiII4.xBuf.length;
            IiiIiIiiII3 -= IiiIiIiiII4.xBuf.length;
            IiiIiIiiII4.byteCount += (long)IiiIiIiiII4.xBuf.length;
        }
        while (IiiIiIiiII3 > 0) {
            IiiIiIiiII4.engineUpdate(IiiIiIiiII[IiiIiIiiII2]);
            ++IiiIiIiiII2;
            --IiiIiIiiII3;
        }
    }

    @Override
    protected void engineUpdate(byte IiiIiIiiII) {
        SM3Digest IiiIiIiiII2;
        IiiIiIiiII2.xBuf[IiiIiIiiII2.xBufOff++] = IiiIiIiiII;
        if (IiiIiIiiII2.xBufOff == IiiIiIiiII2.xBuf.length) {
            IiiIiIiiII2.processWord(IiiIiIiiII2.xBuf, 0);
            IiiIiIiiII2.xBufOff = 0;
        }
        ++IiiIiIiiII2.byteCount;
    }

    public int doFinal(byte[] IiiIiIiiII, int IiiIiIiiII2) {
        SM3Digest IiiIiIiiII3;
        IiiIiIiiII3.finish();
        for (int IiiIiIiiII4 = 0; IiiIiIiiII4 < IiiIiIiiII3.H.length; ++IiiIiIiiII4) {
            SM3Digest.intToBigEndian(IiiIiIiiII3.H[IiiIiIiiII4], IiiIiIiiII, IiiIiIiiII2 + IiiIiIiiII4 * 4);
        }
        IiiIiIiiII3.engineReset();
        return 32;
    }

    public void finish() {
        SM3Digest IiiIiIiiII;
        long IiiIiIiiII2 = IiiIiIiiII.byteCount << 3;
        IiiIiIiiII.engineUpdate((byte)-128);
        while (IiiIiIiiII.xBufOff != 0) {
            IiiIiIiiII.engineUpdate((byte)0);
        }
        IiiIiIiiII.processLength(IiiIiIiiII2);
        IiiIiIiiII.processBlock();
    }

    protected void processWord(byte[] IiiIiIiiII, int IiiIiIiiII2) {
        SM3Digest IiiIiIiiII3;
        IiiIiIiiII3.X[IiiIiIiiII3.xOff] = SM3Digest.bigEndianToInt(IiiIiIiiII, IiiIiIiiII2);
        if (++IiiIiIiiII3.xOff == 16) {
            IiiIiIiiII3.processBlock();
        }
    }

    protected void processLength(long IiiIiIiiII) {
        SM3Digest IiiIiIiiII2;
        if (IiiIiIiiII2.xOff > 14) {
            IiiIiIiiII2.processBlock();
        }
        IiiIiIiiII2.X[14] = (int)(IiiIiIiiII >>> 32);
        IiiIiIiiII2.X[15] = (int)(IiiIiIiiII & 0xFFFFFFFFFFFFFFFFL);
    }

    protected void processBlock() {
        int IiiIiIiiII;
        SM3Digest IiiIiIiiII2;
        int IiiIiIiiII3;
        int[] IiiIiIiiII4 = new int[68];
        int[] IiiIiIiiII5 = new int[64];
        for (IiiIiIiiII3 = 0; IiiIiIiiII3 < 16; ++IiiIiIiiII3) {
            IiiIiIiiII4[IiiIiIiiII3] = IiiIiIiiII2.X[IiiIiIiiII3];
        }
        for (IiiIiIiiII3 = 16; IiiIiIiiII3 < 68; ++IiiIiIiiII3) {
            IiiIiIiiII4[IiiIiIiiII3] = IiiIiIiiII2.P1(IiiIiIiiII4[IiiIiIiiII3 - 16] ^ IiiIiIiiII4[IiiIiIiiII3 - 9] ^ IiiIiIiiII2.ROTATE(IiiIiIiiII4[IiiIiIiiII3 - 3], 15)) ^ IiiIiIiiII2.ROTATE(IiiIiIiiII4[IiiIiIiiII3 - 13], 7) ^ IiiIiIiiII4[IiiIiIiiII3 - 6];
        }
        for (IiiIiIiiII3 = 0; IiiIiIiiII3 < 64; ++IiiIiIiiII3) {
            IiiIiIiiII5[IiiIiIiiII3] = IiiIiIiiII4[IiiIiIiiII3] ^ IiiIiIiiII4[IiiIiIiiII3 + 4];
        }
        int[] IiiIiIiiII6 = (int[])IiiIiIiiII2.H.clone();
        for (IiiIiIiiII = 0; IiiIiIiiII < 64; ++IiiIiIiiII) {
            int IiiIiIiiII7 = IiiIiIiiII < 16 ? 2043430169 : 2055708042;
            int IiiIiIiiII8 = IiiIiIiiII2.ROTATE(IiiIiIiiII6[0], 12) + IiiIiIiiII6[4] + IiiIiIiiII2.ROTATE(IiiIiIiiII7, IiiIiIiiII);
            IiiIiIiiII8 = IiiIiIiiII2.ROTATE(IiiIiIiiII8, 7);
            int IiiIiIiiII9 = IiiIiIiiII8 ^ IiiIiIiiII2.ROTATE(IiiIiIiiII6[0], 12);
            int IiiIiIiiII10 = IiiIiIiiII2.FF(IiiIiIiiII6[0], IiiIiIiiII6[1], IiiIiIiiII6[2], IiiIiIiiII) + IiiIiIiiII6[3] + IiiIiIiiII9 + IiiIiIiiII5[IiiIiIiiII];
            int IiiIiIiiII11 = IiiIiIiiII2.GG(IiiIiIiiII6[4], IiiIiIiiII6[5], IiiIiIiiII6[6], IiiIiIiiII) + IiiIiIiiII6[7] + IiiIiIiiII8 + IiiIiIiiII4[IiiIiIiiII];
            IiiIiIiiII6[3] = IiiIiIiiII6[2];
            IiiIiIiiII6[2] = IiiIiIiiII2.ROTATE(IiiIiIiiII6[1], 9);
            IiiIiIiiII6[1] = IiiIiIiiII6[0];
            IiiIiIiiII6[0] = IiiIiIiiII10;
            IiiIiIiiII6[7] = IiiIiIiiII6[6];
            IiiIiIiiII6[6] = IiiIiIiiII2.ROTATE(IiiIiIiiII6[5], 19);
            IiiIiIiiII6[5] = IiiIiIiiII6[4];
            IiiIiIiiII6[4] = IiiIiIiiII2.P0(IiiIiIiiII11);
        }
        for (IiiIiIiiII = 0; IiiIiIiiII < IiiIiIiiII2.H.length; ++IiiIiIiiII) {
            int n = IiiIiIiiII;
            IiiIiIiiII2.H[n] = IiiIiIiiII2.H[n] ^ IiiIiIiiII6[IiiIiIiiII];
        }
        IiiIiIiiII2.xOff = 0;
        for (IiiIiIiiII = 0; IiiIiIiiII < IiiIiIiiII2.X.length; ++IiiIiIiiII) {
            IiiIiIiiII2.X[IiiIiIiiII] = 0;
        }
    }

    private int ROTATE(int IiiIiIiiII, int IiiIiIiiII2) {
        return IiiIiIiiII << IiiIiIiiII2 | IiiIiIiiII >>> 32 - IiiIiIiiII2;
    }

    /*
     * WARNING - void declaration
     */
    private int P0(int n) {
        SM3Digest IiiIiIiiII;
        void IiiIiIiiII2;
        return IiiIiIiiII2 ^ IiiIiIiiII.ROTATE((int)IiiIiIiiII2, 9) ^ IiiIiIiiII.ROTATE((int)IiiIiIiiII2, 17);
    }

    private int P1(int IiiIiIiiII) {
        SM3Digest IiiIiIiiII2;
        return IiiIiIiiII ^ IiiIiIiiII2.ROTATE(IiiIiIiiII, 15) ^ IiiIiIiiII2.ROTATE(IiiIiIiiII, 23);
    }

    private int FF(int IiiIiIiiII, int IiiIiIiiII2, int IiiIiIiiII3, int IiiIiIiiII4) {
        if (IiiIiIiiII4 < 16) {
            return IiiIiIiiII ^ IiiIiIiiII2 ^ IiiIiIiiII3;
        }
        return IiiIiIiiII & IiiIiIiiII2 | IiiIiIiiII & IiiIiIiiII3 | IiiIiIiiII2 & IiiIiIiiII3;
    }

    private int GG(int IiiIiIiiII, int IiiIiIiiII2, int IiiIiIiiII3, int IiiIiIiiII4) {
        if (IiiIiIiiII4 < 16) {
            return IiiIiIiiII ^ IiiIiIiiII2 ^ IiiIiIiiII3;
        }
        return IiiIiIiiII & IiiIiIiiII2 | ~IiiIiIiiII & IiiIiIiiII3;
    }

    public static int bigEndianToInt(byte[] IiiIiIiiII, int IiiIiIiiII2) {
        int IiiIiIiiII3 = IiiIiIiiII[IiiIiIiiII2] << 24;
        IiiIiIiiII3 |= (IiiIiIiiII[++IiiIiIiiII2] & 0xFF) << 16;
        IiiIiIiiII3 |= (IiiIiIiiII[++IiiIiIiiII2] & 0xFF) << 8;
        return IiiIiIiiII3 |= IiiIiIiiII[++IiiIiIiiII2] & 0xFF;
    }

    public static void intToBigEndian(int IiiIiIiiII, byte[] IiiIiIiiII2, int IiiIiIiiII3) {
        IiiIiIiiII2[IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 24);
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 16);
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 8);
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)IiiIiIiiII;
    }

    /*
     * WARNING - void declaration
     */
    public static int littleEndianToInt(byte[] byArray, int n) {
        void IiiIiIiiII;
        byte[] IiiIiIiiII2;
        int IiiIiIiiII3 = IiiIiIiiII2[IiiIiIiiII];
        IiiIiIiiII3 |= (IiiIiIiiII2[++IiiIiIiiII] & 0xFF) << 8;
        IiiIiIiiII3 |= (IiiIiIiiII2[++IiiIiIiiII] & 0xFF) << 16;
        return IiiIiIiiII3 |= (IiiIiIiiII2[++IiiIiIiiII] & 0xFF) << 24;
    }

    public static void intToLittleEndian(int IiiIiIiiII, byte[] IiiIiIiiII2, int IiiIiIiiII3) {
        IiiIiIiiII2[IiiIiIiiII3] = (byte)IiiIiIiiII;
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 8);
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 16);
        IiiIiIiiII2[++IiiIiIiiII3] = (byte)(IiiIiIiiII >>> 24);
    }
}

