/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.Environments;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.P10Request;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;

public final class P12FileKit {
    static volatile Session session;

    private P12FileKit() {
    }

    public static final String SM2GenerateKeyPair(int bitLength, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2GenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] SM2Bytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileKit.session();
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("SM2"), 256, session);
            }
            catch (PKIException e) {
                throw new PKIException("SM2 KeyPair generate failure:", e);
            }
            try {
                cert = P12FileKit.SignedMyselfCert(session, keypair, "SM2");
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair signed myself failure", e);
            }
            try {
                SM2Bytes = P12FileKit.SM2CombineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair failure", e);
            }
            String base64SM2Bytes = Base64.toBase64String(SM2Bytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2GenerateKeyPair<<<<<<Finished: base64SM2Bytes=" + base64SM2Bytes);
            }
            return base64SM2Bytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String SM2GenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            try {
                byte[] base64p10;
                PublicKey publicKey;
                PKCS12_SM2 P10;
                if (base64EncryptedKeyData == null) {
                    throw new PKIException("SM2 P10 base64EncryptedKeyData should not be null");
                }
                if (password == null) {
                    throw new PKIException("SM2 P10 password should not be null");
                }
                Session session = P12FileKit.session();
                try {
                    P10 = new PKCS12_SM2();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password);
                }
                catch (Exception e) {
                    throw new PKIException("SM2 P10 loading failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("SM2 P10 Fatched PrivateKey failure", e);
                }
                try {
                    publicKey = P10.getPublicCert()[0].getPublicKey();
                }
                catch (Exception e) {
                    throw new PKIException("SM2 P10 Fatched PublicKey failure", e);
                }
                X500Name subject = new X500Name("CN=certRequisition,O=CFCA SM2 AGENT,C=CN");
                P10Request p10R = new P10Request(session);
                try {
                    base64p10 = p10R.generatePKCS10Request(new Mechanism("sm3WithSM2Encryption"), subject, null, publicKey, privateKey, session);
                }
                catch (PKIException e) {
                    throw new PKIException("SM2 P10 Generated PKCS10 failure ", e);
                }
                String base64SM2P10Text = Strings.fromByteArray(base64p10);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2GenerateP10<<<<<<Finished: base64SM2P10Text=" + base64SM2P10Text);
                }
                String string = base64SM2P10Text;
                Object var13_18 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                LoggerManager.exceptionLogger.error("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
                return string;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2GenerateP10<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2GenerateP10<<<<<<Failure", e);
                throw new PKIException("SM2GenerateP10 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            LoggerManager.exceptionLogger.error("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String SM2CombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        StringBuffer buffer3;
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("SM2CombineP12>>>>>>Running");
            buffer2.append("\n base64EncryptedKeyData: ");
            buffer2.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer2.append("\n base64CertData: ");
            buffer2.append(SADKDebugger.dump(base64CertData));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] data;
                X509Cert cert;
                PKCS12_SM2 P10;
                try {
                    P10 = new PKCS12_SM2();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password);
                }
                catch (Exception e) {
                    throw new PKIException("SM2 Combine loading base64EncryptedKeyData failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("SM2 Combine Fatched PrivateKey failure", e);
                }
                try {
                    cert = new X509Cert(Strings.toByteArray(base64CertData));
                }
                catch (PKIException e) {
                    throw new PKIException("SM2 Combine Fatched base64CertData failure", e);
                }
                try {
                    data = P12FileKit.SM2CombineP12Data(cert, privateKey, password);
                }
                catch (Exception e) {
                    throw new PKIException("SM2 Combine failure", e);
                }
                String base64SM2P12Text = Base64.toBase64String(data);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2CombineP12<<<<<<Finished: base64SM2P12Text=" + base64SM2P12Text);
                }
                string = base64SM2P12Text;
                Object var11_17 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                buffer3 = new StringBuffer();
                buffer3.append("SM2CombineP12>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12<<<<<<Failure", e);
                throw new PKIException("SM2CombineP12 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("SM2CombineP12>>>>>>Running");
            buffer3.append("\n base64EncryptedKeyData: ");
            buffer3.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer3.append("\n base64CertData: ");
            buffer3.append(SADKDebugger.dump(base64CertData));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n base64EncryptedKeyData: ");
        buffer3.append(SADKDebugger.dump(base64EncryptedKeyData));
        buffer3.append("\n base64CertData: ");
        buffer3.append(SADKDebugger.dump(base64CertData));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String SM2CombineP12File(X509Cert x509Cert, PrivateKey priKey, String passWord, String sm2FileName) throws PKIException {
        StringBuffer buffer3;
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("SM2CombineP12File>>>>>>Running");
            buffer2.append("\n x509Cert: ");
            buffer2.append(SADKDebugger.dump(x509Cert));
            buffer2.append("\n fileName: ");
            buffer2.append(SADKDebugger.dump(sm2FileName));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (sm2FileName == null) {
                    throw new PKIException("SM2File fileName should not be null");
                }
                byte[] encoding = P12FileKit.SM2CombineP12Data(x509Cert, priKey, passWord);
                try {
                    FileHelper.write(sm2FileName, encoding);
                }
                catch (IOException e) {
                    throw new PKIException("SM2File write failure with IOException", e);
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2CombineP12File<<<<<<Finished: sm2FileName=" + sm2FileName);
                }
                string = sm2FileName;
                Object var8_11 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                buffer3 = new StringBuffer();
                buffer3.append("SM2CombineP12File>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12File<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12File<<<<<<Failure", e);
                throw new PKIException("SM2CombineP12File Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("SM2CombineP12File>>>>>>Running");
            buffer3.append("\n x509Cert: ");
            buffer3.append(SADKDebugger.dump(x509Cert));
            buffer3.append("\n fileName: ");
            buffer3.append(SADKDebugger.dump(sm2FileName));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n x509Cert: ");
        buffer3.append(SADKDebugger.dump(x509Cert));
        buffer3.append("\n fileName: ");
        buffer3.append(SADKDebugger.dump(sm2FileName));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] SM2CombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        StringBuffer buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("SM2CombineP12Data>>>>>>Running");
            buffer2.append("\n x509Cert: ");
            buffer2.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] binaryP12Data = PKCS12_SM2.CombineSM2Data(x509Cert, priKey, password);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2CombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
                }
                byArray = binaryP12Data;
                Object var7_9 = null;
                if (!isFailed) return byArray;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
                buffer3 = new StringBuffer();
                buffer3.append("SM2CombineP12Data>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12Data<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("SM2CombineP12Data<<<<<<Failure", e);
                throw new PKIException("SM2CombineP12Data Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("SM2CombineP12Data>>>>>>Running");
            buffer3.append("\n x509Cert: ");
            buffer3.append(SADKDebugger.dump(x509Cert));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n x509Cert: ");
        buffer3.append(SADKDebugger.dump(x509Cert));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    public static final String RSAGenerateKeyPair(int bitLength, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAGenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] pfxBytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileKit.session();
            if (bitLength != 1024 && bitLength != 2048 && bitLength != 4096) {
                throw new PKIException("PFX KeyPair Invalid bitLength=" + bitLength);
            }
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("RSA"), bitLength, session);
            }
            catch (PKIException e) {
                throw new PKIException("PFX KeyPair generate failure:", e);
            }
            try {
                cert = P12FileKit.SignedMyselfCert(session, keypair, "RSA");
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair signed myself failure", e);
            }
            try {
                pfxBytes = P12FileKit.RSACombineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair failure", e);
            }
            String base64P12Text = Base64.toBase64String(pfxBytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAGenerateKeyPair<<<<<<Finished: base64P12Text=" + base64P12Text);
            }
            return base64P12Text;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String RSAGenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            try {
                byte[] base64p10;
                PublicKey publicKey;
                PKCS12 P10;
                if (base64EncryptedKeyData == null) {
                    throw new PKIException("PFX P10 base64EncryptedKeyData should not be null");
                }
                if (password == null) {
                    throw new PKIException("PFX P10 password should not be null");
                }
                Session session = P12FileKit.session();
                try {
                    P10 = new PKCS12();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password.toCharArray());
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 loading failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 Fatched PrivateKey failure", e);
                }
                try {
                    publicKey = P10.getCerts()[0].getPublicKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 Fatched PublicKey failure", e);
                }
                X500Name subject = new X500Name("CN=certRequisition,O=CFCA RSA AGENT,C=CN");
                P10Request p10R = new P10Request(session);
                try {
                    base64p10 = p10R.generatePKCS10Request(new Mechanism("sha256WithRSAEncryption"), subject, null, publicKey, privateKey, session);
                }
                catch (PKIException e) {
                    throw new PKIException("PFX P10 Generated PKCS10 failure ", e);
                }
                String base64RSAP10Text = Strings.fromByteArray(base64p10);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSAGenerateP10<<<<<<Finished: base64RSAP10Text=" + base64RSAP10Text);
                }
                String string = base64RSAP10Text;
                Object var13_18 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                LoggerManager.exceptionLogger.error("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
                return string;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSAGenerateP10<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSAGenerateP10<<<<<<Failure", e);
                throw new PKIException("RSAGenerateP10 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            LoggerManager.exceptionLogger.error("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String RSACombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        StringBuffer buffer3;
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("RSACombineP12>>>>>>Running");
            buffer2.append("\n base64EncryptedKeyData: ");
            buffer2.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer2.append("\n base64CertData: ");
            buffer2.append(SADKDebugger.dump(base64CertData));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] data;
                X509Cert cert;
                PKCS12 P10;
                try {
                    P10 = new PKCS12();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password.toCharArray());
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine loading base64EncryptedKeyData failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine Fatched PrivateKey failure", e);
                }
                try {
                    cert = new X509Cert(Strings.toByteArray(base64CertData));
                }
                catch (PKIException e) {
                    throw new PKIException("PFX Combine Decoded base64CertData failure", e);
                }
                try {
                    data = P12FileKit.RSACombineP12Data(cert, privateKey, password);
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine failure", e);
                }
                String base64RSAP12Text = Base64.toBase64String(data);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2CombineP12<<<<<<Finished: base64RSAP12Text=" + base64RSAP12Text);
                }
                string = base64RSAP12Text;
                Object var11_17 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                buffer3 = new StringBuffer();
                buffer3.append("RSACombineP12>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12<<<<<<Failure", e);
                throw new PKIException("RSACombineP12 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("RSACombineP12>>>>>>Running");
            buffer3.append("\n base64EncryptedKeyData: ");
            buffer3.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer3.append("\n base64CertData: ");
            buffer3.append(SADKDebugger.dump(base64CertData));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n base64EncryptedKeyData: ");
        buffer3.append(SADKDebugger.dump(base64EncryptedKeyData));
        buffer3.append("\n base64CertData: ");
        buffer3.append(SADKDebugger.dump(base64CertData));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String RSACombineP12File(X509Cert x509Cert, PrivateKey priKey, String password, String p12FileName) throws PKIException {
        StringBuffer buffer3;
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("RSACombineP12File>>>>>>Running");
            buffer2.append("\n x509Cert: ");
            buffer2.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (p12FileName == null) {
                    throw new PKIException("PFXFile fileName should not be null");
                }
                byte[] encoding = P12FileKit.RSACombineP12Data(x509Cert, priKey, password);
                try {
                    FileHelper.write(p12FileName, encoding);
                }
                catch (Exception e) {
                    throw new PKIException("PFXFile write failure", e);
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSACombineP12File<<<<<<Finished: p12FileName=" + p12FileName);
                }
                string = p12FileName;
                Object var8_11 = null;
                if (!isFailed) return string;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
                buffer3 = new StringBuffer();
                buffer3.append("RSACombineP12File>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12File<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12File<<<<<<Failure", e);
                throw new PKIException("RSACombineP12File Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("RSACombineP12File>>>>>>Running");
            buffer3.append("\n x509Cert: ");
            buffer3.append(SADKDebugger.dump(x509Cert));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n x509Cert: ");
        buffer3.append(SADKDebugger.dump(x509Cert));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] RSACombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        StringBuffer buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("RSACombineP12Data>>>>>>Running");
            buffer2.append("\n x509Cert: ");
            buffer2.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] binaryP12Data = PKCS12.generatePfxData(x509Cert, priKey, password);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSACombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
                }
                byArray = binaryP12Data;
                Object var7_9 = null;
                if (!isFailed) return byArray;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
                buffer3 = new StringBuffer();
                buffer3.append("RSACombineP12Data>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12Data<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12Data<<<<<<Failure", e);
                throw new PKIException("RSACombineP12Data Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("RSACombineP12Data>>>>>>Running");
            buffer3.append("\n x509Cert: ");
            buffer3.append(SADKDebugger.dump(x509Cert));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n x509Cert: ");
        buffer3.append(SADKDebugger.dump(x509Cert));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Session session() throws PKIException {
        if (session != null) return session;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (session != null) return session;
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                throw new PKIException("Open session failure: " + e.getMessage());
            }
            return session;
        }
    }

    private static final X509Cert SignedMyselfCert(Session session, KeyPair keypair, String keyType) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SignedMyselfCert::>>>>>>Running");
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n keyType: ");
            buffer.append(SADKDebugger.dump(keyType));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            X509CertGenerator gen = new X509CertGenerator();
            String algorithm = "RSA".equals(keyType) ? "sha256WithRSAEncryption" : "sm3WithSM2Encryption";
            String TESTDN = "CN=" + keyType + " P10 AGENT,OU=CFCA SADK P10 RSA ,O=CFCA TEST,C=CN";
            gen.setIssuer(TESTDN);
            gen.setSubject(TESTDN);
            gen.setSerialNumber(BigInteger.valueOf(1L));
            gen.setNotAfter(new Date());
            gen.setNotBefore(new Date());
            gen.setPublicKey(keypair.getPublic());
            gen.setSignatureAlg(algorithm);
            byte[] encoding = gen.generateX509Cert(keypair.getPrivate(), session);
            X509Cert x509Cert = new X509Cert(encoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SignedMyselfCert<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("SignedMyselfCert::<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SignedMyselfCert::<<<<<<Failure", e);
            throw new PKIException("SignedMyselfCert Failure", e);
        }
    }

    static {
        Environments.environments();
        session = null;
    }
}

