/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.envelope.EnvelopeDecryptHelper;
import cfca.sadk.envelope.EnvelopeEncryptHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.system.Environments;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.security.PrivateKey;

public class EnvelopeUtil {
    public static final int recipient_policy_requiredSubjectKeyId = 0;
    public static final int recipient_policy_useSubjectKeyIdExt = 1;
    public static final int recipient_policy_useIssuerAndSerialNumber = 2;

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        StringBuffer buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("envelopeMessage>>>>>>Running");
            buffer2.append("\n sourceData: ");
            buffer2.append(SADKDebugger.dump(sourceData));
            buffer2.append("\n symmetricAlgorithm: ");
            buffer2.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer2.append("\n receiverCerts: ");
            buffer2.append(SADKDebugger.dump(receiverCerts));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            buffer2.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (sourceData == null) throw new PKIException("required sourceData!");
                if (sourceData.length == 0) {
                    throw new PKIException("required sourceData!");
                }
                if (receiverCerts == null) throw new PKIException("required receiverCerts!");
                if (receiverCerts.length < 1) throw new PKIException("required receiverCerts!");
                if (receiverCerts[0] == null) {
                    throw new PKIException("required receiverCerts!");
                }
                if (receiverCerts.length > 1) {
                    throw new PKIException("receiverCerts more than one cert!");
                }
                EnvelopeEncryptHelper envelopeUtil = new EnvelopeEncryptHelper(receiverCerts[0].isSM2Cert());
                byte[] base64EnvelopeMessageBytes = envelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("envelopeMessage<<<<<<Finished: base64EnvelopeMessageBytes=" + SADKDebugger.dumpBase64(base64EnvelopeMessageBytes));
                }
                byArray = base64EnvelopeMessageBytes;
                Object var10_12 = null;
                if (!isFailed) return byArray;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
                buffer3 = new StringBuffer();
                buffer3.append("envelopeMessage>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("envelopeMessage<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("envelopeMessage<<<<<<Failure", e);
                throw new PKIException("EnvelopeMessage Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("envelopeMessage>>>>>>Running");
            buffer3.append("\n sourceData: ");
            buffer3.append(SADKDebugger.dump(sourceData));
            buffer3.append("\n symmetricAlgorithm: ");
            buffer3.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer3.append("\n receiverCerts: ");
            buffer3.append(SADKDebugger.dump(receiverCerts));
            buffer3.append("\n session: ");
            buffer3.append(SADKDebugger.dump(session));
            buffer3.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n sourceData: ");
        buffer3.append(SADKDebugger.dump(sourceData));
        buffer3.append("\n symmetricAlgorithm: ");
        buffer3.append(SADKDebugger.dump(symmetricAlgorithm));
        buffer3.append("\n receiverCerts: ");
        buffer3.append(SADKDebugger.dump(receiverCerts));
        buffer3.append("\n session: ");
        buffer3.append(SADKDebugger.dump(session));
        buffer3.append("\n recipientPolicyType: " + recipientPolicyType);
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        EnvelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        EnvelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("envelopeFile>>>>>>Running");
            buffer2.append("\n sourceFilePath: ");
            buffer2.append(SADKDebugger.dump(inSourceFilePath));
            buffer2.append("\n outEnvelopedFilePath: ");
            buffer2.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer2.append("\n symmetricAlgorithm: ");
            buffer2.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer2.append("\n receiverCerts: ");
            buffer2.append(SADKDebugger.dump(receiverCerts));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            buffer2.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        try {
            block9: {
                try {
                    File srcFile = new File(inSourceFilePath);
                    if (srcFile.length() <= 0L) {
                        throw new PKIException("required sourceFilePath!");
                    }
                    if (receiverCerts == null) throw new PKIException("required receiverCerts!");
                    if (receiverCerts.length < 1) throw new PKIException("required receiverCerts!");
                    if (receiverCerts[0] == null) {
                        throw new PKIException("required receiverCerts!");
                    }
                    if (receiverCerts.length > 1) {
                        throw new PKIException("receiverCerts more than one cert!");
                    }
                    EnvelopeEncryptHelper envelopeUtil = new EnvelopeEncryptHelper(receiverCerts[0].isSM2Cert());
                    envelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block9;
                    LoggerManager.debugLogger.debug("envelopeFile<<<<<<Finished: outEnvelopedFilePath=" + outEnvelopedFilePath);
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("envelopeFile<<<<<<Failure", e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("envelopeFile<<<<<<Failure", e);
                    throw new PKIException("EnvelopeFile Failure", e);
                }
            }
            Object var10_11 = null;
            if (!isFailed) return;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) return;
            StringBuffer buffer322 = new StringBuffer();
            buffer322.append("envelopeFile>>>>>>Running");
            buffer322.append("\n sourceFilePath: ");
            buffer322.append(SADKDebugger.dump(inSourceFilePath));
            buffer322.append("\n outEnvelopedFilePath: ");
            buffer322.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer322.append("\n symmetricAlgorithm: ");
            buffer322.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer322.append("\n receiverCerts: ");
            buffer322.append(SADKDebugger.dump(receiverCerts));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            buffer322.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer322.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer322 = new StringBuffer();
            buffer322.append("envelopeFile>>>>>>Running");
            buffer322.append("\n sourceFilePath: ");
            buffer322.append(SADKDebugger.dump(inSourceFilePath));
            buffer322.append("\n outEnvelopedFilePath: ");
            buffer322.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer322.append("\n symmetricAlgorithm: ");
            buffer322.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer322.append("\n receiverCerts: ");
            buffer322.append(SADKDebugger.dump(receiverCerts));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            buffer322.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer322.toString());
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void openEnvelopedFile(String inEnvelopedFilePath, String outSourceFilePath, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("openEnvelopedFile>>>>>>Running");
            buffer2.append("\n inEnvelopedFilePath: ");
            buffer2.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer2.append("\n outSourceFilePath: ");
            buffer2.append(SADKDebugger.dump(outSourceFilePath));
            buffer2.append("\n recipientPrivateKey: ");
            buffer2.append(SADKDebugger.dump(recipientPrivateKey));
            buffer2.append("\n recipientCert: ");
            buffer2.append(SADKDebugger.dump(recipientCert));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        try {
            block6: {
                try {
                    EnvelopeDecryptHelper.openEnvelopedFile(inEnvelopedFilePath, outSourceFilePath, recipientPrivateKey, recipientCert, session);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block6;
                    LoggerManager.debugLogger.debug("openEnvelopedFile<<<<<<Finished: outSourceFilePath=" + outSourceFilePath);
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("openEnvelopedFile<<<<<<Failure", e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("openEnvelopedFile<<<<<<Failure", e);
                    throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
                }
            }
            Object var8_9 = null;
            if (!isFailed) return;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) return;
            StringBuffer buffer322 = new StringBuffer();
            buffer322.append("openEnvelopedFile>>>>>>Running");
            buffer322.append("\n inEnvelopedFilePath: ");
            buffer322.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer322.append("\n outSourceFilePath: ");
            buffer322.append(SADKDebugger.dump(outSourceFilePath));
            buffer322.append("\n recipientPrivateKey: ");
            buffer322.append(SADKDebugger.dump(recipientPrivateKey));
            buffer322.append("\n recipientCert: ");
            buffer322.append(SADKDebugger.dump(recipientCert));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer322 = new StringBuffer();
            buffer322.append("openEnvelopedFile>>>>>>Running");
            buffer322.append("\n inEnvelopedFilePath: ");
            buffer322.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer322.append("\n outSourceFilePath: ");
            buffer322.append(SADKDebugger.dump(outSourceFilePath));
            buffer322.append("\n recipientPrivateKey: ");
            buffer322.append(SADKDebugger.dump(recipientPrivateKey));
            buffer322.append("\n recipientCert: ");
            buffer322.append(SADKDebugger.dump(recipientCert));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString());
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] openEvelopedMessage(byte[] base64EnvelopeMessage, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        StringBuffer buffer3;
        byte[] byArray;
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("openEvelopedMessage>>>>>>Running");
            buffer2.append("\n base64EnvelopeMessage: ");
            buffer2.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
            buffer2.append("\n recipientPrivateKey: ");
            buffer2.append(SADKDebugger.dump(recipientPrivateKey));
            buffer2.append("\n recipientCert: ");
            buffer2.append(SADKDebugger.dump(recipientCert));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        try {
            try {
                byte[] sourceData = EnvelopeDecryptHelper.openEnvelopedMessage(base64EnvelopeMessage, recipientPrivateKey, recipientCert, session);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("openEvelopedMessage<<<<<<Finished: sourceData=" + SADKDebugger.dump(sourceData));
                }
                byArray = sourceData;
                Object var8_9 = null;
                if (!isFailed) return byArray;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
                buffer3 = new StringBuffer();
                buffer3.append("openEvelopedMessage>>>>>>Running");
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("openEvelopedMessage<<<<<<Failure", e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("openEvelopedMessage<<<<<<Failure", e);
                throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append("openEvelopedMessage>>>>>>Running");
            buffer3.append("\n base64EnvelopeMessage: ");
            buffer3.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
            buffer3.append("\n recipientPrivateKey: ");
            buffer3.append(SADKDebugger.dump(recipientPrivateKey));
            buffer3.append("\n recipientCert: ");
            buffer3.append(SADKDebugger.dump(recipientCert));
            buffer3.append("\n session: ");
            buffer3.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n base64EnvelopeMessage: ");
        buffer3.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
        buffer3.append("\n recipientPrivateKey: ");
        buffer3.append(SADKDebugger.dump(recipientPrivateKey));
        buffer3.append("\n recipientCert: ");
        buffer3.append(SADKDebugger.dump(recipientCert));
        buffer3.append("\n session: ");
        buffer3.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    public static boolean isRecipient(X509Cert recipientCert, byte[] base64EnvelopeData) throws PKIException {
        ASN1Set receivers;
        byte[] cmsEnvelopedData;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("isRecipient>>>>>>Running");
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n base64EnvelopeData: ");
            buffer.append(SADKDebugger.dumpBase64(base64EnvelopeData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (recipientCert == null) {
            throw new PKIException("isRecipient: required recipientCert");
        }
        if (base64EnvelopeData == null) {
            throw new PKIException("isRecipient: required base64EnvelopeData");
        }
        try {
            cmsEnvelopedData = Base64.decode(base64EnvelopeData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", e);
            throw new PKIException("isRecipient: base64EnvelopeData invalid");
        }
        try {
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(cmsEnvelopedData);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            receivers = enData.getRecipientInfos();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", e);
            throw new PKIException("isRecipient: cmsEnvelopedData invalid");
        }
        try {
            if (receivers == null) {
                return false;
            }
            int len = receivers.size();
            for (int i = 0; i < len; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !recipientCert.isRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()))) continue;
                return true;
            }
            return false;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", e);
            throw new PKIException("isRecipient Failure", e);
        }
    }

    static {
        Environments.environments();
    }
}

