/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    private static final int BUFFSIZE = 65536;

    private FileHelper() {
    }

    public static final void deleteFile(String fileName) {
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void write(String filePath, byte[] data) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        if (data == null) {
            throw new IllegalArgumentException("Illegal Argument: data");
        }
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            fos.write(data, 0, data.length);
            fos.flush();
            Object var5_5 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        fos.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] read(String filePath) throws IOException {
        byte[] byArray;
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        FileInputStream crls = null;
        try {
            crls = FileHelper.openInputStream(new File(filePath));
            byArray = FileHelper.read(crls);
            Object var4_4 = null;
            if (crls == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (crls == null) throw throwable;
            try {
                crls.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return byArray;
        }
        crls.close();
        return byArray;
    }

    public static void writeBytesToFile(byte[] sourceData, OutputStream os) throws IOException {
        if (os != null && sourceData != null) {
            os.write(sourceData);
        }
    }

    public static void writeBytesToFile(byte[] data, int offSet, int len, OutputStream os) throws IOException {
        if (os != null && data != null) {
            os.write(data, offSet, len);
        }
    }

    public static byte[] getBytesFromFile(InputStream inputStream) throws IOException {
        int BIGGEST_FILE_SIZE;
        if (inputStream == null) {
            throw new IllegalArgumentException("Illegal Argument: inputStream");
        }
        int len = inputStream.available();
        if (len > (BIGGEST_FILE_SIZE = CompatibleConfig.FILEANDBUFFER_BIGGEST_FILE_MAXSIZE)) {
            throw new IOException("file is too big!");
        }
        return FileHelper.read(inputStream);
    }

    public static final byte[] read(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Illegal Argument: in");
        }
        int sLength = in.available();
        if (sLength < 0) {
            throw new IllegalArgumentException("Illegal Stream: available<0");
        }
        byte[] out = new byte[sLength];
        if (sLength > 0) {
            int rLength;
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = in.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
        }
        return out;
    }

    public static final void closedStream(InputStream inputStream, String message) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error(message, e);
            }
        }
    }

    public static final void closedStream(OutputStream outputStream, String message) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error(message, e);
            }
        }
    }

    public static final void closedStreamE(InputStream inputStream, String message) throws PKIException {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error(message, e);
                throw new PKIException(message, e);
            }
        }
    }

    public static final void closedStreamE(OutputStream outputStream, String message) throws PKIException {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error(message, e);
                throw new PKIException(message, e);
            }
        }
    }

    private static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static boolean isFileExist(String filePath) throws Exception {
        boolean fileExist = false;
        if (filePath != null && filePath.trim().length() != 0) {
            File file = new File(filePath);
            fileExist = file.exists() && file.isFile();
        }
        return fileExist;
    }

    public static File checkFileExist(String filePath) throws Exception {
        if (filePath == null || filePath.trim().length() == 0) {
            throw new Exception("checkFileExist failure: configFilePath is null");
        }
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception("checkFileExist failure: not found " + file.getAbsolutePath());
        }
        return file;
    }
}

