/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.sm2;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PublicKey;

public class SM2HashUtil {
    /*
     * Loose catch block
     */
    public static byte[] hashFile(boolean ifZValue, byte[] userId, String sourceFilePath, long startPos, long dataLength, PublicKey pubKey, String generate_sourceFilePath, Session session) throws PKIException {
        Exception e72;
        byte[] byArray;
        FileOutputStream fileWriter;
        RandomAccessFile fileReader;
        block37: {
            if (sourceFilePath == null) {
                throw new PKIException("SM2HashUtil@HashUtil failed: required sourceFilePath not null");
            }
            fileReader = null;
            fileWriter = null;
            File sourceFile = new File(sourceFilePath);
            if (!sourceFile.exists()) {
                throw new PKIException("SM2HashUtil@HashUtil failed: sourceFilePath not exists-->" + sourceFile.getAbsolutePath());
            }
            if (!sourceFile.isFile()) {
                throw new PKIException("SM2HashUtil@HashUtil failed: sourceFilePath not file-->" + sourceFile.getAbsolutePath());
            }
            try {
                fileReader = new RandomAccessFile(sourceFile, "r");
            }
            catch (FileNotFoundException e2) {
                throw new PKIException("SM2HashUtil@HashUtil fileReader failed: " + sourceFile.getAbsolutePath(), e2);
            }
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                try {
                    File generateFile = new File(generate_sourceFilePath);
                    fileWriter = new FileOutputStream(generateFile);
                }
                catch (FileNotFoundException e3) {
                    throw new PKIException("SM2HashUtil@HashUtil fileWriter failed: " + generate_sourceFilePath, e3);
                }
            }
            try {
                fileReader.seek(startPos);
            }
            catch (IOException e4) {
                throw new PKIException("SM2HashUtil@HashUtil fileReader seek failed: " + sourceFile.getAbsolutePath(), e4);
            }
            boolean jniFlag = session != null && session.useJniNativeOperation();
            Digest hash = null;
            hash = jniFlag ? new JNIDigest(922) : new SM3Digest();
            if (ifZValue) {
                if (pubKey == null) {
                    throw new PKIException("SM2HashUtil@hashFile failed: required pubKey not null");
                }
                if (!(pubKey instanceof GMTKey)) {
                    throw new PKIException("SM2HashUtil@hashFile failed: required SM2Key");
                }
                byte[] z = ((GMTKey)((Object)pubKey)).getDefaultZ();
                hash.update(z, 0, z.length);
            }
            try {
                long readTotalLength;
                int bufferSize = 65536;
                byte[] buffer = new byte[65536];
                if (dataLength > 65536L) {
                    int readLength;
                    for (readTotalLength = 0L; (readLength = fileReader.read(buffer)) > 0 && readTotalLength < dataLength; readTotalLength += (long)readLength) {
                        if (readTotalLength + (long)readLength <= dataLength) {
                            hash.update(buffer, 0, readLength);
                            if (fileWriter == null) continue;
                            fileWriter.write(buffer, 0, readLength);
                            continue;
                        }
                        int leftLength = (int)(dataLength - readTotalLength);
                        hash.update(buffer, 0, leftLength);
                        if (fileWriter != null) {
                            fileWriter.write(buffer, 0, leftLength);
                        }
                        readTotalLength += (long)leftLength;
                        break;
                    }
                } else {
                    buffer = new byte[(int)dataLength];
                    int readLength = fileReader.read(buffer);
                    hash.update(buffer, 0, readLength);
                    if (fileWriter != null) {
                        fileWriter.write(buffer, 0, readLength);
                    }
                    readTotalLength += (long)readLength;
                }
                if (readTotalLength != dataLength) {
                    throw new PKIException(String.format("SM2HashUtil@hashFile failed: readTotalLength(%s)!=dataLength(%s)", readTotalLength, dataLength));
                }
            }
            catch (IOException e5) {
                throw new PKIException("SM2HashUtil@HashUtil fileReader/fileWriter failed", e5);
            }
            catch (Exception e6) {
                throw new PKIException("SM2HashUtil@HashUtil fileReader/fileWriter failed", e6);
            }
            byte[] hashData = new byte[32];
            hash.doFinal(hashData, 0);
            byArray = hashData;
            Object var22_28 = null;
            if (fileReader == null) break block37;
            try {
                fileReader.close();
            }
            catch (Exception e72) {
                LoggerManager.exceptionLogger.error("SM2HashUtil@HashUtil failed when closed fileReader", e72);
            }
        }
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception e72) {
                LoggerManager.exceptionLogger.error("SM2HashUtil@HashUtil failed when closed fileWriter", e72);
            }
        }
        return byArray;
        {
            catch (Exception e8) {
                try {
                    throw new PKIException("SM2HashUtil@HashUtil hash failed", e8);
                }
                catch (Throwable throwable) {
                    block39: {
                        Exception e72;
                        Object var22_29 = null;
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Exception e72) {
                                LoggerManager.exceptionLogger.error("SM2HashUtil@HashUtil failed when closed fileReader", e72);
                            }
                        }
                        if (fileWriter == null) break block39;
                        try {
                            fileWriter.close();
                        }
                        catch (Exception e72) {
                            LoggerManager.exceptionLogger.error("SM2HashUtil@HashUtil failed when closed fileWriter", e72);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

