/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.envelope.SessionEncryptMode;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.KeyUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class HardLib
implements Session {
    final int BUFFSIZE = 16384;
    final int ENCRYPT_BUFFSIZE = 10240;
    final String signByHash_ALG;
    private String providerName;
    private Provider provider;
    final boolean sm2SigningASN1Format;
    final int sm2EncryptFormatType;
    final String transformation_cbc_pkcs7_des3 = "DESede/CBC/PKCS7Padding";
    final String transformation_cbc_pkcs7_sm4 = "SM4/CBC/PKCS7Padding";

    public HardLib(String providerPath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HardLib constructor startup with providerPath=" + providerPath);
        }
        if (providerPath == null || providerPath.trim().length() == 0) {
            providerPath = "com.sansec.jce.provider.SwxaProvider";
        }
        LoggerManager.systemLogger.info("HardLib constructor providerPath=" + providerPath);
        try {
            this.provider = (Provider)Class.forName(providerPath).newInstance();
            this.providerName = this.provider.getName();
        }
        catch (Exception e) {
            LoggerManager.systemLogger.info("HardLib constructor warnning in newInstance", e);
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + this.providerName, e);
        }
        Mechanism mechanism = null;
        KeyPair keypair = null;
        try {
            mechanism = new Mechanism("SM2");
            keypair = this.generateKeyPair(mechanism, 256);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HardLib constructor warnning in GenerateKeyPair", e);
        }
        String signByHash = this.findSM2SignByHashAlgorithm("SM2");
        if (signByHash == null) {
            signByHash = this.findSM2SignByHashAlgorithm("SimuSM2");
        }
        if (signByHash == null) {
            LoggerManager.exceptionLogger.error("HardLib constructor error in GetSignature without SM2/SimuSM2 for SM2SignByHash ");
            signByHash = "SM2";
        }
        this.signByHash_ALG = signByHash;
        this.sm2SigningASN1Format = this.signingFormat(keypair);
        this.sm2EncryptFormatType = this.encryptFormat(keypair);
        StringBuilder buffer = new StringBuilder();
        buffer.append("HardLib constructor finished!");
        buffer.append("\n signByHash_ALG=").append(this.signByHash_ALG);
        buffer.append("\n sm2SigningASN1Format=").append(this.sm2SigningASN1Format);
        buffer.append("\n sm2EncryptFormatType=").append(this.sm2EncryptFormatType);
        LoggerManager.systemLogger.info(buffer.toString());
    }

    final String findSM2SignByHashAlgorithm(String algorithm) {
        try {
            Signature.getInstance(algorithm, this.provider);
            return algorithm;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("GenerateKey>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            String type = mechanism.getMechanismType();
            SecureRandom random = new SecureRandom();
            SecretKeySpec key = null;
            if ("SM4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("DESede".equals(type)) {
                byte[] keyData = new byte[24];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("RC4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else {
                throw new PKIException("GenerateKey failure with invalid keyType=" + mechanism.getMechanismType());
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with throwable", e);
        }
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("generateKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyData: ");
            buffer.append(SADKDebugger.dump(keyData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            Key key = KeyUtil.generateKey(mechanism, keyData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with throwable", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign message >>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
            String mType = mechanism.getMechanismType();
            byte[] signData = null;
            Signature signature = Signature.getInstance(mType, this.provider);
            signature.initSign(privateKey);
            signature.update(sourceData);
            signData = signature.sign();
            signData = this.signedOutFormat(mechanism, signData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("sign message <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", e);
            throw new PKIException("sign message failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", e);
            throw new PKIException("sign message failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        InputStream sourceData = null;
        try {
            try {
                PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
                String mType = mechanism.getMechanismType();
                byte[] signData = null;
                Signature signature = Signature.getInstance(mType, this.provider);
                signature.initSign(privateKey);
                byte[] buffer = new byte[16384];
                int i = 0;
                sourceData = new BufferedInputStream(sourceStream);
                while ((i = sourceData.read(buffer)) > 0) {
                    signature.update(buffer, 0, i);
                }
                signData = signature.sign();
                signData = this.signedOutFormat(mechanism, signData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("sign stream <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
                }
                byArray = signData;
                Object var13_14 = null;
                if (sourceData == null) return byArray;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", e);
                throw new PKIException("sign stream failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", e);
                throw new PKIException("sign stream failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (sourceData == null) throw throwable;
            try {
                sourceData.close();
                throw throwable;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sign stream failure", e);
                throw new PKIException("sign stream failure", e);
            }
        }
        try {}
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign stream failure", e);
            throw new PKIException("sign stream failure", e);
        }
        sourceData.close();
        return byArray;
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
            signature.initVerify(publicKey);
            byte[] signedData = this.signedInFormat(mechanism, signData);
            signature.update(sourceData);
            boolean verifyResult = signature.verify(signedData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verify message <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", e);
            throw new PKIException("verify message failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", e);
            throw new PKIException("verify message failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        InputStream sourceData = null;
        try {
            try {
                PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
                Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
                signature.initVerify(publicKey);
                byte[] signedData = this.signedInFormat(mechanism, signData);
                byte[] buffer = new byte[16384];
                int i = 0;
                sourceData = new BufferedInputStream(sourceStream);
                while ((i = sourceData.read(buffer)) > 0) {
                    signature.update(buffer, 0, i);
                }
                boolean verifyResult = signature.verify(signedData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verify stream <<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var14_15 = null;
                if (sourceData == null) return bl;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", e);
                throw new PKIException("verify stream failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", e);
                throw new PKIException("verify stream failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (sourceData == null) throw throwable;
            try {
                sourceData.close();
                throw throwable;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("verify stream failure", e);
                throw new PKIException("verify stream failure", e);
            }
        }
        try {}
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify stream failure", e);
            throw new PKIException("verify stream failure", e);
        }
        sourceData.close();
        return bl;
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData;
            String mType = mechanism.getMechanismType();
            if (Mechanisms.isSM2Type(mechanism)) {
                PublicKey hardKey = this.SM2HardPublicKey(mechanism, (PublicKey)key);
                encryptData = this.SM2Encrypt(mType, sourceData, hardKey);
            } else {
                encryptData = mechanism.getMechanismType().startsWith("RSA") ? this.RSAEncrypt(mType, (PublicKey)key, sourceData) : BCSoftLib.INSTANCE().encrypt(mechanism, key, sourceData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encrypt message <<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("encrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n sourceData=").append(SADKDebugger.dump(sourceData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("encrypt message failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("encrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n sourceData=").append(SADKDebugger.dump(sourceData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("encrypt message failure:", e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        byte[] decryptData = null;
        try {
            String mType = mechanism.getMechanismType();
            decryptData = Mechanisms.isSM2Type(mechanism) ? this.SM2Decrypt(mechanism, encryptData, key) : (mechanism.getMechanismType().startsWith("RSA") ? this.RSADecrypt(mType, (PrivateKey)key, encryptData) : BCSoftLib.INSTANCE().decrypt(mechanism, key, encryptData));
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decrypt message <<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("decrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n encryptData=").append(SADKDebugger.dump(encryptData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("decrypt message failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("decrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n encryptData=").append(SADKDebugger.dump(encryptData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("decrypt message failure:", e);
        }
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("GenerateKeyPair >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            int bitLength;
            String mType = mechanism.getMechanismType();
            boolean isExport = true;
            int keyNum = 0;
            int keyUsage = 2;
            Object object = mechanism.getParam();
            if (object != null) {
                GenKeyAttribute attr = (GenKeyAttribute)object;
                isExport = attr.isExport;
                if (!isExport) {
                    keyNum = attr.keyNum;
                }
                keyUsage = attr.keyUsage;
            }
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, this.provider);
            if (isExport) {
                bitLength = keyLength;
            } else {
                int kLength = keyNum << 16;
                if (1 == keyUsage) {
                    kLength |= Integer.MIN_VALUE;
                }
                bitLength = kLength;
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair ::::::kLength=" + bitLength + ",keyNum=" + keyNum + ",keyUsage=" + keyUsage);
            }
            keyPairGen.initialize(bitLength);
            KeyPair keypair = keyPairGen.generateKeyPair();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair <<<<<<Finished: decryptData=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKeyPair failure", e);
            throw new PKIException("GenerateKeyPair failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKeyPair failure", e);
            throw new PKIException("GenerateKeyPair failure", e);
        }
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] hashValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
            int cipherMode = 1;
            byte[] signData = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(this.signByHash_ALG, this.provider);
                signature.initSign(privateKey);
                signature.update(hashValue);
                signData = signature.sign();
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("signByHash ::::::signedOutFormat>>signData=" + SADKDebugger.dump(signData));
                }
                signData = this.signedOutFormat(mechanism, signData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("signByHash ::::::signedOutFormat<<signData=" + SADKDebugger.dump(signData));
                }
            } else {
                byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(mechanism.getMechanismType(), hashValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("signByHash ::::::hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
                }
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
                cipher.init(cipherMode, priKey);
                signData = cipher.doFinal(hashWithAlgorithm);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("signByHash <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("signByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n priKey=").append(SADKDebugger.dump(priKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("signByHash failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("signByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n priKey=").append(SADKDebugger.dump(priKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("signByHash failure:", e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("verifyByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            boolean verifyResult;
            PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
            int cipherMode = 2;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(this.signByHash_ALG, this.provider);
                signature.initVerify(publicKey);
                signature.update(hashValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verifyByHash ::::::signedInFormat>>signData=" + SADKDebugger.dump(signData));
                }
                byte[] signedData = this.signedInFormat(mechanism, signData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verifyByHash ::::::signedInFormat>>signData=" + SADKDebugger.dump(signData));
                }
                verifyResult = signature.verify(signedData);
            } else {
                byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(mechanism, hashValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verifyByHash ::::::hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
                }
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
                cipher.init(cipherMode, pubKey);
                byte[] decryptHash = cipher.doFinal(signData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verifyByHash ::::::decryptHash=" + SADKDebugger.dump(decryptHash));
                }
                verifyResult = RSAPackageUtil.isRSAHashEqual(decryptHash, hashWithAlgorithm);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verifyByHash <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("verifyByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n pubKey=").append(SADKDebugger.dump(pubKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            builder.append("\n signData=").append(SADKDebugger.dump(signData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("verifyByHash failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("verifyByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n pubKey=").append(SADKDebugger.dump(pubKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            builder.append("\n signData=").append(SADKDebugger.dump(signData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("verifyByHash failure:", e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encrypt stream>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n in: ");
            buffer.append(SADKDebugger.dump(in));
            buffer.append("\n out: ");
            buffer.append(SADKDebugger.dump(out));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (this.isSM2Type(mechanism) || mechanism.getMechanismType().startsWith("RSA")) {
                this.encryptOrDecrypt(mechanism, key, in, out, true);
            } else {
                BCSoftLib.INSTANCE().encrypt(mechanism, key, in, out);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encrypt stream<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("encrypt stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("encrypt stream failure", e);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decrypt stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n in: ");
            buffer.append(SADKDebugger.dump(in));
            buffer.append("\n out: ");
            buffer.append(SADKDebugger.dump(out));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (this.isSM2Type(mechanism) || mechanism.getMechanismType().startsWith("RSA")) {
                this.encryptOrDecrypt(mechanism, key, in, out, false);
            } else {
                BCSoftLib.INSTANCE().decrypt(mechanism, key, in, out);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decrypt stream<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("decrypt stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("decrypt stream failure", e);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getProviderName() {
        return this.providerName;
    }

    public final PublicKey SM2HardPublicKey(Mechanism mechanism, PublicKey pubKey) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2HardPublicKey::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        PublicKey returnKey = null;
        try {
            if (pubKey != null && this.isSM2Type(mechanism) && pubKey instanceof ECPublicKey) {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance("SM2", this.provider);
                X509EncodedKeySpec x509spec = new X509EncodedKeySpec(pubKey.getEncoded());
                returnKey = kf.generatePublic(x509spec);
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Finished");
            } else {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::X509EncodedKeySpec: Not ECPublicKey");
                returnKey = pubKey;
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HardPublicKey failure", e);
            throw new PKIException("SM2HardPublicKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HardPublicKey failure", e);
            throw new PKIException("SM2HardPublicKey failure", e);
        }
        return returnKey;
    }

    public final PrivateKey SM2HardPrivateKey(Mechanism mechanism, PrivateKey privKey) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2HardPrivateKey::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privKey));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        PrivateKey returnKey = null;
        try {
            if (privKey != null && this.isSM2Type(mechanism) && privKey instanceof ECPrivateKey) {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance("SM2", this.provider);
                PKCS8EncodedKeySpec x509spec = new PKCS8EncodedKeySpec(privKey.getEncoded());
                returnKey = kf.generatePrivate(x509spec);
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Finished");
            } else {
                LoggerManager.debugLogger.debug("SM2HardPublicKey::::::::PKCS8EncodedKeySpec: Not ECPrivateKey");
                returnKey = privKey;
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HardPrivateKey failure", e);
            throw new PKIException("SM2HardPrivateKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HardPrivateKey failure", e);
            throw new PKIException("SM2HardPrivateKey failure", e);
        }
        return returnKey;
    }

    private final byte[] RSAEncrypt(String mType, PublicKey key, byte[] sourceData) throws Exception {
        Cipher cipher = Cipher.getInstance(mType, this.provider);
        cipher.init(1, key);
        return cipher.doFinal(sourceData);
    }

    private final byte[] RSADecrypt(String mType, PrivateKey key, byte[] encryptData) throws Exception {
        Cipher cipher = Cipher.getInstance(mType, this.provider);
        cipher.init(2, key);
        return cipher.doFinal(encryptData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSM2Type(Mechanism mechanism) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("isSM2Type::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean convertFlag = true;
        try {
            convertFlag = mechanism == null || mechanism.getMechanismType() == null ? true : mechanism.getMechanismType().toUpperCase().indexOf("SM2") != -1;
            Object var4_4 = null;
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("isSM2Type::<<<<<<Finished: convertFlag=" + convertFlag);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("isSM2Type::<<<<<<Finished: convertFlag=" + convertFlag);
            }
            throw throwable;
        }
        return convertFlag;
    }

    private final boolean signingFormat(KeyPair keypair) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signingFormat::>>>>>>running");
            buffer.append("\n keypair: ");
            buffer.append(SADKDebugger.dump(keypair));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean asnFormat = false;
        if (keypair != null) {
            try {
                Signature signature = Signature.getInstance("SM2", this.provider);
                signature.initSign(keypair.getPrivate());
                signature.update(new byte[32]);
                byte[] signData = signature.sign();
                boolean bl = asnFormat = signData != null && signData.length > 64;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("signingFormat::::::::Finished: asnFormat=" + asnFormat + ",signData=" + SADKDebugger.dump(signData));
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("signingFormat::<<<<<<Failure: asnFormat limited for False", e);
                asnFormat = false;
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("signingFormat::<<<<<<Failure: asnFormat limited for False", e);
                asnFormat = false;
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("signingFormat::<<<<<<Finished: asnFormat=" + asnFormat);
        }
        return asnFormat;
    }

    private final int encryptFormat(KeyPair keypair) {
        int sm2FormatType = 1;
        if (CompatibleConfig.SM2CheckHardLibOriginEncryptOutFormat) {
            if (keypair != null) {
                byte[] sourceData = new byte[32];
                for (int i = 0; i < sourceData.length; ++i) {
                    sourceData[i] = 8;
                }
                try {
                    Cipher cipher = Cipher.getInstance("SM2", this.provider);
                    cipher.init(1, keypair.getPublic());
                    byte[] encryptData = cipher.doFinal(sourceData);
                    if (ASN1SM2Cipher.isASN1EncryptType(encryptData) && this.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 1)) {
                        sm2FormatType = 1;
                        LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C3_C2_WITH_ASN1");
                    } else if (encryptData.length - sourceData.length == 96) {
                        if (this.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 16)) {
                            sm2FormatType = 16;
                            LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C2_C3_WITHOUT_0x04");
                        } else if (this.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 4)) {
                            sm2FormatType = 4;
                            LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C3_C2_WITHOUT_0x04");
                        } else {
                            sm2FormatType = 16;
                            LoggerManager.systemLogger.warn("encryptFormat::::::::Others Finished: C1_C2_C3_WITHOUT_0x04: " + Hex.toHexString(encryptData));
                        }
                    } else {
                        sm2FormatType = 1;
                        LoggerManager.systemLogger.warn("encryptFormat::::::::Others Finished: C1_C3_C2_WITH_ASN1: " + Hex.toHexString(encryptData));
                    }
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("encryptFormat::<<<<<<Failure: asnFormat limited for False", e);
                    sm2FormatType = 1;
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.error("encryptFormat::<<<<<<Failure: asnFormat limited for False", e);
                    sm2FormatType = 1;
                }
            }
            if (sm2FormatType != CompatibleConfig.SM2HardLibOriginEncryptOutFormat) {
                LoggerManager.systemLogger.warn("encryptFormat:: the config type is " + CompatibleConfig.SM2HardLibOriginEncryptOutFormat + ", but the real Type is " + sm2FormatType);
            }
            LoggerManager.systemLogger.warn("encryptFormat::<<<<<<Finished: sm2FormatType=" + sm2FormatType);
        } else {
            sm2FormatType = CompatibleConfig.SM2HardLibOriginEncryptOutFormat;
            LoggerManager.systemLogger.warn("encryptFormat::<<<<<<Finished: CompatibleConfig.SM2HardLibOriginEncryptOutFormat=" + sm2FormatType);
        }
        return sm2FormatType;
    }

    private final byte[] signedOutFormat(Mechanism mechanism, byte[] signData) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signedOutFormat::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (signData != null && this.isSM2Type(mechanism) && signData.length != 64) {
            signData = new ASN1SM2Signature(signData).getRSRaw64Bytes();
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("signedOutFormat::<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    private byte[] signedInFormat(Mechanism mechanism, byte[] signData) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signedInFormat::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (signData != null && this.isSM2Type(mechanism)) {
            try {
                if (this.sm2SigningASN1Format) {
                    if (signData.length == 64) {
                        signData = new ASN1SM2Signature(signData).getEncoded();
                    }
                } else if (signData.length != 64) {
                    signData = new ASN1SM2Signature(signData).getRSRaw64Bytes();
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("signedInFormat::<<<<<<Failure: skip setting", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("signedInFormat::<<<<<<Failure: skip setting", e);
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("signedInFormat::<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    private final byte[] sm2EncryptOutFormat(byte[] encryptedData, int sm2HardEncryptedType) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sm2EncryptOutFormat::>>>>>>running");
            buffer.append("\n encryptedData: ");
            buffer.append(SADKDebugger.dump(encryptedData));
            buffer.append("\n sourceLength: " + sm2HardEncryptedType);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        int sm2EncryptedOutType = CompatibleConfig.SM2OutputFormatEncryptedBytes;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("sm2EncryptOutFormat::::::::Finished:  ChangedFrom>> sm2EncryptedType=" + sm2HardEncryptedType + " to sm2EncryptedType=" + sm2EncryptedOutType);
        }
        if (sm2HardEncryptedType != sm2EncryptedOutType) {
            try {
                ASN1SM2Cipher out = new ASN1SM2Cipher(encryptedData, sm2HardEncryptedType);
                encryptedData = out.getEncryptedBytes(sm2EncryptedOutType);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sm2EncryptOutFormat::<<<<<<Failure: skip setting encryptedData=" + SADKDebugger.dump(encryptedData), e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("sm2EncryptOutFormat::<<<<<<Failure: skip setting encryptedData=" + SADKDebugger.dump(encryptedData), e);
            }
        }
        return encryptedData;
    }

    private final byte[] sm2DecryptInFormat(byte[] encryptData, int sm2EncryptedType) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("sm2DecryptInFormat::::::::Finished:  ChangedFrom>> sm2EncryptedType=" + sm2EncryptedType + " to sm2EncryptedType=" + this.sm2EncryptFormatType);
        }
        if (sm2EncryptedType != this.sm2EncryptFormatType) {
            try {
                ASN1SM2Cipher asn1EncryptedData = new ASN1SM2Cipher(encryptData, sm2EncryptedType);
                encryptData = asn1EncryptedData.getEncryptedBytes(this.sm2EncryptFormatType);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sm2DecryptInFormat::<<<<<<Failure: skip setting encryptData=" + SADKDebugger.dump(encryptData), e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("sm2DecryptInFormat::<<<<<<Failure: skip setting encryptData=" + SADKDebugger.dump(encryptData), e);
            }
        }
        return encryptData;
    }

    private final byte[] SM2Encrypt(String mType, byte[] sourceData, PublicKey key) throws PKIException, Exception {
        Cipher cipher = Cipher.getInstance(mType, this.provider);
        cipher.init(1, key);
        byte[] encryptData = cipher.doFinal(sourceData);
        encryptData = this.sm2EncryptOutFormat(encryptData, this.sm2EncryptFormatType);
        return encryptData;
    }

    private final byte[] SM2Decrypt(Mechanism mechanism, byte[] encryptData, Key key) throws PKIException, Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2Decrypt::>>>>>>running");
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (encryptData == null || encryptData.length < 96) {
            throw new PKIException("SM2Decrypt Failure with encryptData shortage");
        }
        PrivateKey hardKey = this.SM2HardPrivateKey(mechanism, (PrivateKey)key);
        Cipher cipher = Cipher.getInstance(mechanism.getMechanismType(), this.provider);
        cipher.init(2, hardKey);
        byte[] decryptBytes = null;
        if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
            LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Running");
            byte[] cardEncryptData = this.sm2DecryptInFormat(encryptData, 1);
            decryptBytes = cipher.doFinal(cardEncryptData);
            LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Finished");
        } else {
            try {
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Running");
                byte[] cardEncryptData = this.sm2DecryptInFormat(encryptData, 4);
                decryptBytes = cipher.doFinal(cardEncryptData);
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Finished");
            }
            catch (Exception e) {
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Running");
                cipher.init(2, hardKey);
                byte[] cardEncryptData = this.sm2DecryptInFormat(encryptData, 16);
                decryptBytes = cipher.doFinal(cardEncryptData);
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Finished");
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2Decrypt::<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
        }
        return decryptBytes;
    }

    final boolean trySM2Decrypt(Cipher cipher, byte[] encryptData, byte[] sourceData, KeyPair keypair, int trySM2Format) {
        boolean passed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("encryptFormat::::::::Tried trySM2DecryptFormatType=" + trySM2Format);
        }
        try {
            ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptData, trySM2Format);
            cipher.init(2, keypair.getPrivate());
            byte[] decryptData = cipher.doFinal(asn1.getEncryptedBytes(trySM2Format));
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptFormat::::::::Tried  sourceData=" + Hex.toHexString(sourceData));
                LoggerManager.debugLogger.debug("encryptFormat::::::::Tried decryptData=" + Hex.toHexString(decryptData));
            }
            passed = Arrays.equals(sourceData, decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("trySM2Decrypt::<<<<<<Failure  trySM2DecryptFormatType=" + trySM2Format, e);
            passed = false;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("trySM2Decrypt::<<<<<<Failure  trySM2DecryptFormatType=" + trySM2Format, e);
            passed = false;
        }
        return passed;
    }

    private final void encryptOrDecrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out, boolean isEncrypt) throws PKIException {
        int rLength;
        byte[] buffer;
        try {
            buffer = new byte[10240];
            rLength = in.read(buffer);
        }
        catch (Exception e) {
            throw new PKIException("encrypt stream failure: file read error", e);
        }
        if (rLength > 4096) {
            throw new PKIException("encrypt stream failure: message more than 4096");
        }
        byte[] data = new byte[rLength];
        byte[] resultData = null;
        System.arraycopy(buffer, 0, data, 0, data.length);
        resultData = isEncrypt ? this.encrypt(mechanism, key, data) : this.decrypt(mechanism, key, data);
        try {
            out.write(resultData, 0, resultData.length);
        }
        catch (Exception e) {
            throw new PKIException("encrypt stream failure: file write error", e);
        }
    }

    public PublicKey exportEncPublicKey() throws PKIException {
        throw new PKIException("exportEncPublicKey failure: not support HardLib!");
    }

    public boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws PKIException {
        throw new PKIException("importSM2KeyPair failure: not support HardLib!");
    }

    public final String getDeviceName() {
        return "JHARD_LIB";
    }

    public final int getDeviceType() {
        return 2;
    }

    public boolean checkIdleTest() throws PKIException {
        return true;
    }

    public final boolean useJniNativeOperation() throws PKIException {
        return CompatibleConfig.SM2EnvelopeEncryptMode == SessionEncryptMode.JHARDSESSION.sessionType;
    }
}

