/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.dummy;

import cfca.sadk.algorithm.util.PKCS8ToPKCS1Util;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Formatter;

final class DummyRSAPrivateKey
implements RSAPrivateKey {
    private static final long serialVersionUID = 8678395554153283835L;
    private final RSAPrivateKey privateKeyRef;
    private final byte[] pkcs8EncodedBytes;
    final byte[] jniEncodedBytes;
    final int moduleBytesLength;

    public DummyRSAPrivateKey(RSAPrivateKey privateKeyRef) throws CardException {
        if (privateKeyRef == null) {
            throw new CardParameterException("missing privateKeyRef");
        }
        RSAPrivateKey privateKey = privateKeyRef;
        this.privateKeyRef = privateKeyRef;
        this.jniEncodedBytes = this.buildEncodedBytes(privateKey);
        this.moduleBytesLength = (7 + privateKey.getModulus().bitLength()) / 8;
        try {
            this.pkcs8EncodedBytes = privateKeyRef.getEncoded();
        }
        catch (Exception e) {
            throw new CardParameterException("invalid privateKeyRef with pkcs8EncodedBytes", e);
        }
    }

    public String getAlgorithm() {
        return this.privateKeyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.privateKeyRef.getFormat();
    }

    public byte[] getEncoded() {
        return this.pkcs8EncodedBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jniEncodedBytes);
        result = 31 * result + this.moduleBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DummyRSAPrivateKey other = (DummyRSAPrivateKey)obj;
        if (!Arrays.equals(this.jniEncodedBytes, other.jniEncodedBytes)) {
            return false;
        }
        return this.moduleBytesLength == other.moduleBytesLength;
    }

    public String toString() {
        Formatter builder = new Formatter();
        builder.format("DummyRSAPrivateKey ", new Object[0]);
        try {
            if (this.privateKeyRef instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey k = (RSAPrivateCrtKey)this.privateKeyRef;
                builder.format("\n%8s%20s=0x%s", "", "Modulus", k.getModulus().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PublicExponent", k.getPublicExponent().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrivateExponent", k.getPrivateExponent().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeP", k.getPrimeP().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeQ", k.getPrimeQ().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeExponentP", k.getPrimeExponentP().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeExponentQ", k.getPrimeExponentQ().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "CrtCoefficient", k.getCrtCoefficient().toString(16));
            } else {
                builder.format("\n%8s%20s=0x%s", "", "Modulus", this.privateKeyRef.getModulus().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrivateExponent", this.privateKeyRef.getPrivateExponent().toString(16));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("DummyRSAPrivateKey dump detail invalid", e);
            builder.format("\n%8s%20s=0x%s", "", "k", "failure");
        }
        builder.format("\n%4s%20s=0x%s", "", "jniEncodedBytes", Hex.toHexString(this.jniEncodedBytes));
        builder.format("\n%4s%20s=%s", "", "moduleBytesLength", this.moduleBytesLength);
        String output = builder.toString();
        builder.close();
        return output;
    }

    private final byte[] buildEncodedBytes(RSAPrivateKey privateKey) throws CardException {
        byte[] jniEncodedBytes = null;
        try {
            jniEncodedBytes = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(privateKey);
        }
        catch (Exception e) {
            throw new CardParameterException("buildEncodedBytes failure", e);
        }
        return jniEncodedBytes;
    }

    public BigInteger getPrivateExponent() {
        return this.privateKeyRef.getPrivateExponent();
    }

    public BigInteger getModulus() {
        return this.privateKeyRef.getModulus();
    }

    public RSAPrivateKey getPrivateKeyRef() {
        return this.privateKeyRef;
    }
}

