/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200.CardKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.lib.crypto.card.dummy.DummySM2Card;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNIP11;
import java.io.File;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C200CardP11 {
    static final int CKM_SM2_WITH_Z = 1;
    static final int CKM_SM2_SIGN_VERIFY = 65538;
    static final int CKM_SM2_EXTERNAL_VERIFY = 65548;
    static final int CKM_SM2_EXTERNAL_ENCRYPT = 65549;
    static final long INTERNAL_ENC_KEYHANDLE = -1040183278L;
    static final int CKM_SM2_isDecrypt = 1;
    private JNIP11 sm2JNIP11;
    private int[] tokens;
    private long sessionHandle;
    private long sessionHandleTimeout;
    private String CKIDList;
    final ReentrantLock cardLock = new ReentrantLock();
    private LinkedBlockingQueue<Long> sessionHandles;
    private ConcurrentMap<HashKey, KeyPair> cardKeys;
    private final Object lock;
    private static C200CardP11 instance = null;
    private final int minECCIndex;
    private final int maxECCIndex;
    final boolean supportIdleTest;

    public static synchronized C200CardP11 getInstance(SM2CardInfo info) throws CardException {
        if (instance == null) {
            instance = new C200CardP11(info);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C200CardP11(SM2CardInfo info) throws CardException {
        Object object = this.lock = new Object();
        synchronized (object) {
            LoggerManager.systemLogger.info("C200CardP11>>>>>>Running: info=" + info);
            JNIP11 sm2JNIP11 = new JNIP11();
            try {
                File p11File = new File(info.p11LibPath);
                if (!p11File.exists()) {
                    throw new CardException("C200CardP11<<<<<<loadLib Failure: " + info.p11LibPath + " is not exists!");
                }
                LoggerManager.systemLogger.info("C200CardP11 p11File=" + p11File.getAbsolutePath());
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("C200CardP11<<<<<<loadLib Failure", e);
                throw new CardException("C200CardP11 loadLib failure", e);
            }
            try {
                LoggerManager.systemLogger.info("C200CardP11::::::loadLib running: " + info.p11LibPath);
                sm2JNIP11.loadLib(info.p11LibPath);
                LoggerManager.systemLogger.info("C200CardP11::::::loadLib successfully");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("C200CardP11<<<<<<loadLib Failure: " + info.p11LibPath, e);
                throw new CardException("C200CardP11 loadLib failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("C200CardP11<<<<<<loadLib Failure: " + info.p11LibPath, e);
                throw new CardException("C200CardP11 loadLib failure", e);
            }
            try {
                LoggerManager.systemLogger.info("C200CardP11::::::init running");
                sm2JNIP11.init();
                LoggerManager.systemLogger.info("C200CardP11::::::init successfully");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("C200CardP11<<<<<<init Failure", e);
                throw new CardException("C200CardP11 init failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("C200CardP11<<<<<<init Failure", e);
                throw new CardException("C200CardP11 init failure", e);
            }
            this.tokens = this.cardInitGetTokens(sm2JNIP11);
            int token = info.cardToken;
            this.sessionHandles = this.cardInitOpenSession(sm2JNIP11, token, info.cardSessionNumb);
            Long sessionHandle = this.sessionHandles.poll();
            if (sessionHandle == null) {
                throw new CardException("C200CardP11 init failure with invalid sessionHandle");
            }
            LoggerManager.systemLogger.info("C200CardP11<<<<<<sessionHandle: " + sessionHandle + ", C200CARDLOGIN=" + CompatibleConfig.C200CARDLOGIN);
            if (CompatibleConfig.C200CARDLOGIN) {
                try {
                    LoggerManager.systemLogger.info("C200CardP11::::::cardInitLogin running");
                    this.cardInitLogin(sm2JNIP11, sessionHandle, info.p11Password);
                    LoggerManager.systemLogger.info("C200CardP11::::::cardInitLogin successfully");
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("C200CardP11<<<<<<cardInitLogin failed", e);
                }
            }
            this.sessionHandle = sessionHandle;
            this.sessionHandleTimeout = info.cardSessionTimeout < 0 ? 120L : (long)info.cardSessionTimeout;
            this.minECCIndex = info.getMinECCIndex();
            this.maxECCIndex = info.getMaxECCIndex();
            this.CKIDList = this.cardInitGetCKIDList(sm2JNIP11, sessionHandle);
            this.cardKeys = this.cardInitAllKeyPairs(sm2JNIP11, sessionHandle);
            this.sm2JNIP11 = sm2JNIP11;
            this.supportIdleTest = info.supportIdleTest;
            LoggerManager.systemLogger.info("C200CardP11<<<<<<Successfully");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cardUninitFinalize();
    }

    final void cardUninitFinalize() {
        LoggerManager.systemLogger.info("cardUninitFinalize>>>>>>Running");
        if (this.sm2JNIP11 != null) {
            try {
                LoggerManager.systemLogger.info("C200CardP11::::::uninit running");
                this.sm2JNIP11.uninit();
                LoggerManager.systemLogger.info("C200CardP11::::::uninit successfully");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("cardUninitFinalize<<<<<<uninit Failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("cardUninitFinalize<<<<<<uninit Failure", e);
            }
            try {
                LoggerManager.systemLogger.info("C200CardP11::::::unloadLib running");
                this.sm2JNIP11.unloadLib();
                LoggerManager.systemLogger.info("C200CardP11::::::unloadLib successfully");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("cardUninitFinalize<<<<<<unloadLib Failure: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("cardUninitFinalize<<<<<<unloadLib Failure: " + e.getMessage(), e);
            }
        }
        LoggerManager.systemLogger.info("cardUninitFinalize<<<<<<Successfully");
    }

    private final int[] cardInitGetTokens(JNIP11 sm2JNIP11) throws CardException {
        int retrunValue;
        LoggerManager.systemLogger.info("cardInitGetTokens::>>>>>>Running");
        int[] buffer = new int[16];
        try {
            LoggerManager.systemLogger.info("C200CardP11::::::getTokenList running");
            retrunValue = sm2JNIP11.getTokenList(buffer);
            LoggerManager.systemLogger.info("C200CardP11::::::getTokenList retrunValue=" + retrunValue);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("cardInitGetTokens::<<<<<<Failure", e);
            throw new CardException("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("cardInitGetTokens::<<<<<<Failure", e);
            throw new CardException("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), e);
        }
        if (retrunValue <= 0) {
            throw new CardException("cardInitGetTokens::<<<<<<Failure with retrunValue=" + retrunValue);
        }
        int[] tokens = new int[retrunValue];
        System.arraycopy(buffer, 0, tokens, 0, tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            String tokenInfo = null;
            try {
                LoggerManager.systemLogger.info("C200CardP11::::::getTokenInfo running: token=" + tokens[i]);
                tokenInfo = sm2JNIP11.getTokenInfo(tokens[i]);
                LoggerManager.systemLogger.info("C200CardP11::::::getTokenInfo tokenInfo=" + tokenInfo);
                continue;
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("cardInitGetTokens::<<<<<<getTokenInfo(" + tokens[i] + ") Failure", e);
                throw new CardException("cardInitGetTokens::<<<<<<getTokenInfo(" + tokens[i] + ") Failure", e);
            }
        }
        LoggerManager.systemLogger.info("cardInitGetTokens::<<<<<<Successfully");
        return tokens;
    }

    private final LinkedBlockingQueue<Long> cardInitOpenSession(JNIP11 sm2JNIP11, int token, int numSessionHandles) throws CardException {
        LoggerManager.systemLogger.info("cardInitOpenSession::>>>>>>Running");
        LinkedBlockingQueue<Long> sessionHandles = new LinkedBlockingQueue<Long>();
        try {
            int i = 0;
            while (i < numSessionHandles) {
                long session = sm2JNIP11.openSession(token);
                LoggerManager.systemLogger.info("C200CardP11::::::openSession  sessionHandle#" + ++i + "=" + session);
                sessionHandles.add(session);
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("cardInitOpenSession::<<<<<<openSession Failure", e);
            throw new CardException("cardInitOpenSession openSession failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("cardInitOpenSession::<<<<<<openSession Failure", e);
            throw new CardException("cardInitOpenSession openSession failure", e);
        }
        LoggerManager.systemLogger.info("cardInitOpenSession::<<<<<<Successfully!");
        return sessionHandles;
    }

    private final void cardInitLogin(JNIP11 sm2JNIP11, long sessionHandle, String password) throws CardException {
        LoggerManager.systemLogger.info("cardInitLogin::>>>>>>Running, sessionHandle=" + sessionHandle);
        try {
            byte[] pinBytes = password.getBytes("UTF8");
            long returnValue = sm2JNIP11.login(sessionHandle, (int)sm2JNIP11.CKU_USER, pinBytes, pinBytes.length);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("cardInitLogin::<<<<<<returnValue=" + returnValue);
            }
            if (returnValue != 0L) {
                throw new CardException("cardInitLogin::<<<<<<Failure: returnValue=" + returnValue);
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("cardInitLogin::<<<<<<Failure", e);
            throw new CardException("cardInitLogin failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("cardInitLogin::<<<<<<Failure", e);
            throw new CardException("cardInitLogin failure: " + e.getMessage(), e);
        }
        LoggerManager.systemLogger.info("cardInitLogin:::<<<<<<Successfully, sessionHandle=" + sessionHandle);
    }

    private final String cardInitGetCKIDList(JNIP11 sm2JNIP11, long sessionHandle) throws CardException {
        LoggerManager.systemLogger.info("cardInitGetCKIDList::>>>>>>Running");
        String CKIDText = null;
        try {
            CKIDText = sm2JNIP11.getCKIDList(sessionHandle);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("cardInitGetCKIDList::<<<<<< Failure", e);
            throw new CardException("cardInitGetCKIDList failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("cardInitGetCKIDList::<<<<<< Failure", e);
            throw new CardException("cardInitGetCKIDList failure: " + e.getMessage(), e);
        }
        LoggerManager.systemLogger.info("cardInitGetCKIDList::::::Successfully: CKIDText=" + CKIDText);
        return CKIDText;
    }

    protected final ConcurrentMap<HashKey, KeyPair> cardInitAllKeyPairs(JNIP11 sm2JNIP11, long sessionHandle) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("cardInitCacheKeyPairs::>>>>>>Running");
        }
        String CKIDText = this.cardInitGetCKIDList(sm2JNIP11, sessionHandle);
        ConcurrentHashMap<HashKey, KeyPair> cardKeys = new ConcurrentHashMap<HashKey, KeyPair>();
        if (CKIDText != null) {
            StringTokenizer tokenizer = new StringTokenizer(CKIDText, "|");
            KeyPair keypair = null;
            HashKey hashKey = null;
            String CKIDLast = null;
            while (tokenizer.hasMoreTokens()) {
                String CKID = tokenizer.nextToken().trim();
                if (CKID.length() == 0) continue;
                if (CKIDLast != null && CKID.equals(CKIDLast)) {
                    try {
                        if (LoggerManager.debugLogger.isDebugEnabled()) {
                            LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::>>>>>>Running: addEncryptKey-->CKID(keyIndex)=" + CKID);
                        }
                        if ((keypair = this.cardInitKeyPair(sm2JNIP11, sessionHandle, CKID, 1)) == null) continue;
                        hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                        cardKeys.put(hashKey, keypair);
                        if (!LoggerManager.debugLogger.isDebugEnabled()) continue;
                        LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<Finished: addEncryptKey--> " + hashKey);
                        LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPublic());
                        LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPrivate());
                    }
                    catch (Exception e) {
                        LoggerManager.exceptionLogger.error("cardInitAllKeyPairs::::<<<<<<Failure: addEncryptKey-->CKID(keyIndex)=" + CKID, e);
                    }
                    continue;
                }
                try {
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::>>>>>>Running: addSignatureKey--> CKID(keyIndex)=" + CKID);
                    }
                    if ((keypair = this.cardInitKeyPair(sm2JNIP11, sessionHandle, CKID, 2)) != null) {
                        hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                        cardKeys.put(hashKey, keypair);
                        if (LoggerManager.debugLogger.isDebugEnabled()) {
                            LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<Finished: addSignatureKey--> " + hashKey);
                            LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPublic());
                            LoggerManager.debugLogger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPrivate());
                        }
                    }
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("cardInitAllKeyPairs::::<<<<<<Failure: addSignatureKey-->CKID(keyIndex)=" + CKID, e);
                }
                CKIDLast = CKID;
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("cardInitCacheKeyPairs::<<<<<<Successfully: cardKeys=" + cardKeys.size());
        }
        return cardKeys;
    }

    protected final KeyPair cardInitKeyPair(JNIP11 sm2JNIP11, long sessionHandle, String CKIDText, int keyUsage) throws CardException {
        PrivateKey privateKey;
        int returnValue;
        long privateKeyHandle;
        long publicKeyHandle;
        byte[] CKID;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("cardInitKeyPair::>>>>>>Running: CKID(keyIndex)=" + CKIDText + ",keyUsage=" + keyUsage);
        }
        byte[] pubKeyX = new byte[32];
        byte[] pubKeyY = new byte[32];
        try {
            CKID = CKIDText.getBytes("UTF8");
        }
        catch (Exception e) {
            throw new CardException("cardInitKeyPair::<<<<<<failure with invalid CKID: " + e.getMessage(), e);
        }
        try {
            try {
                this.cardLock.lock();
                publicKeyHandle = sm2JNIP11.getKeyHandle(sessionHandle, CKID, keyUsage, true, true);
                privateKeyHandle = sm2JNIP11.getKeyHandle(sessionHandle, CKID, keyUsage, false, true);
                returnValue = sm2JNIP11.exportSM2PublicKey(sessionHandle, publicKeyHandle, pubKeyX, pubKeyY);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append("cardInitKeyPair failure");
                builder.append(", sessionHandle=").append(sessionHandle);
                builder.append(", CKID(keyIndex)=").append(CKIDText);
                builder.append(", keyUsage=").append(keyUsage);
                LoggerManager.exceptionLogger.error(builder.toString(), e);
                throw new CardException("cardInitKeyPair::<<<<<<failure", e);
            }
            catch (Throwable e) {
                StringBuilder builder = new StringBuilder();
                builder.append("cardInitKeyPair failure");
                builder.append(", sessionHandle=").append(sessionHandle);
                builder.append(", CKID(keyIndex)=").append(CKIDText);
                builder.append(", keyUsage=").append(keyUsage);
                LoggerManager.exceptionLogger.error(builder.toString(), e);
                throw new CardException("cardInitKeyPair::<<<<<<failure", e);
            }
            Object var17_12 = null;
            this.cardLock.unlock();
        }
        catch (Throwable throwable) {
            Object var17_13 = null;
            this.cardLock.unlock();
            throw throwable;
        }
        if (returnValue != 0) {
            throw new CardException("cardInitKeyPair::<<<<<<failure when export PublicKey withreturnValue=" + returnValue);
        }
        byte[] defaultZ = SM2Params.calcZ(pubKeyX, pubKeyY);
        KeyPair keypair = null;
        if (this.isECCKey(CKIDText)) {
            ECCCardPublicKey publicKey = new ECCCardPublicKey(defaultZ, publicKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            privateKey = new ECCCardPrivateKey(defaultZ, privateKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            keypair = new KeyPair(publicKey, privateKey);
        } else {
            SM2CardPublicKey publicKey = new SM2CardPublicKey(defaultZ, publicKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            privateKey = new SM2CardPrivateKey(defaultZ, privateKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            keypair = new KeyPair(publicKey, privateKey);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("cardInitKeyPair::<<<<<<Successfully");
        }
        return keypair;
    }

    protected final Long takeSessionHandle() throws InterruptedException, CardException {
        Long sessionHandle = this.sessionHandles.poll(this.sessionHandleTimeout, TimeUnit.SECONDS);
        if (sessionHandle == null) {
            throw new CardException("TakeSessionHandle timeout in " + this.sessionHandleTimeout + " seconds");
        }
        return sessionHandle;
    }

    public long loginSM2Card(String password) throws CardException {
        long returnValue;
        try {
            int cku_user = (int)this.sm2JNIP11.CKU_USER;
            byte[] pinBytes = password.getBytes("UTF8");
            returnValue = this.sm2JNIP11.login(this.sessionHandle, (int)this.sm2JNIP11.CKU_USER, pinBytes, pinBytes.length);
            LoggerManager.systemLogger.info("SM2CardLogin::<<<<<<cku_user=" + cku_user + " +returnValue=" + returnValue);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2CardLogin::<<<<<<Failure ", e);
            throw new CardException("SM2CardLogin failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2CardLogin::<<<<<<Failure ", e);
            throw new CardException("SM2CardLogin failure", e);
        }
        return returnValue;
    }

    final KeyPair generateKeyPair(GenKeyAttribute attr) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GenerateKeyPair>>>>>>running: " + attr);
        }
        KeyPair keypair = null;
        if (attr.isExport) {
            keypair = DummySM2Card.dummy.generateKeyPair(true, 0, 0);
        } else {
            String CKID;
            int keyIndex = attr.keyNum;
            int keyUsage = attr.keyUsage;
            try {
                CKID = Integer.toString(keyIndex);
            }
            catch (Exception e) {
                throw new CardException("GenerateKeyPair failure with invalid keyIndex=" + keyIndex, e);
            }
            keypair = this.cardInitKeyPair(this.sm2JNIP11, this.sessionHandle, CKID, keyUsage);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<Successfully");
                LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<" + keypair.getPublic());
                LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<" + keypair.getPrivate());
            }
            HashKey hashKey = null;
            hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
            if (this.cardKeys.containsKey(hashKey)) {
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<HashKey: contains-->" + hashKey);
                }
            } else {
                this.cardKeys.put(hashKey, keypair);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<HashKey: add--> " + hashKey);
                }
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GenerateKeyPair<<<<<<Finished: cardKeys=" + this.cardKeys.size());
        }
        return keypair;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] cardSign(CardKey cardKey, byte[] hashValue) throws CardException {
        byte[] cardSignData;
        block11: {
            cardSignData = new byte[64];
            long keyHandle = cardKey.getKeyHandle();
            Long sessionHandle = null;
            try {
                try {
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardSign<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    int returnValue = this.sm2JNIP11.signInit(sessionHandle.longValue(), keyHandle, 65538, 1);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardSign::::::signInit: retrunValue=" + returnValue);
                    }
                    if (returnValue != 0) {
                        throw new CardException("C200CardSign<<<<<<Failure with signInit returnValue=" + returnValue);
                    }
                    returnValue = this.sm2JNIP11.signHash(sessionHandle.longValue(), hashValue, cardSignData);
                    if (returnValue != cardSignData.length) {
                        throw new CardException("C200CardSign<<<<<<Failure with signHash returnValue=" + returnValue);
                    }
                    Object var10_9 = null;
                    if (sessionHandle == null) break block11;
                }
                catch (CardException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardSign failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", hashValue=").append(Hex.toHexString(hashValue));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw e;
                }
                catch (Throwable e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardSign failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", hashValue=").append(Hex.toHexString(hashValue));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw new CardException("C200CardSign<<<<<<Failure ", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("C200CardSign::<<<<<<Finished: cardSignData=" + SADKDebugger.dump(cardSignData));
        }
        return cardSignData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean cardVerify(CardKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        boolean verifyResult;
        block23: {
            byte[] cardSignValue = null;
            try {
                if (signValue.length == 64) {
                    cardSignValue = signValue;
                } else {
                    if (!ASN1SM2Signature.isASN1SignType(signValue)) {
                        throw new CardException("C200CardVerify<<<<<<Failure with invalid signValue(Required 64 or asn1)!!!");
                    }
                    cardSignValue = new ASN1SM2Signature(signValue).getRSRaw64Bytes();
                }
            }
            catch (CardException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException("C200CardVerify<<<<<<Failure with invalid signValue: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new CardException("C200CardVerify<<<<<<Failure  with invalid signValue: " + e.getMessage(), e);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("C200CardVerify::::::cardSignValue=" + SADKDebugger.dump(cardSignValue));
            }
            long keyHandle = cardKey.getKeyHandle();
            verifyResult = false;
            Long sessionHandle = null;
            try {
                try {
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardVerify<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    int returnValue = this.sm2JNIP11.verifyInit(sessionHandle.longValue(), keyHandle, 65538, 1);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardVerify::::::verifyInit: retrunValue=" + returnValue);
                    }
                    if (returnValue != 0) {
                        throw new CardException("C200CardVerify<<<<<<Failure with verifyInit returnValue=" + returnValue);
                    }
                    returnValue = this.sm2JNIP11.verify(sessionHandle.longValue(), hashValue, cardSignValue);
                    if (returnValue == 0) {
                        verifyResult = true;
                    } else {
                        if (LoggerManager.debugLogger.isDebugEnabled()) {
                            LoggerManager.debugLogger.debug("C200CardVerify<<<<<<Failure with verifyHash returnValue: " + returnValue);
                        }
                        verifyResult = false;
                    }
                }
                catch (CardException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardVerify failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", hashValue=").append(Hex.toHexString(hashValue));
                    builder.append(", signValue=").append(Hex.toHexString(signValue));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw e;
                }
                catch (Throwable e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardVerify failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", hashValue=").append(Hex.toHexString(hashValue));
                    builder.append(", signValue=").append(Hex.toHexString(signValue));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw new CardException("C200CardVerify<<<<<<Failure", e);
                }
                Object var12_14 = null;
                if (sessionHandle == null) break block23;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("C200CardVerify<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] cardEncrypt(CardKey cardKey, byte[] sourceData) throws CardException {
        byte[] cardEncryptData;
        int encLength;
        byte[] encryptData;
        block14: {
            if (sourceData == null || sourceData.length == 0) {
                throw new CardException("C200CardEncrypt Failure with invalid sourceData(Required > 0)!");
            }
            encryptData = new byte[sourceData.length + 96];
            long keyHandle = cardKey.getKeyHandle();
            encLength = 0;
            Long sessionHandle = null;
            try {
                try {
                    int returnValue;
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardEncrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    if ((returnValue = this.sm2JNIP11.encryptInit(sessionHandle.longValue(), keyHandle, 0)) != 0) {
                        throw new CardException("C200CardEncrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
                    }
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("C200CardEncrypt::::::encryptInit: retrunValue=" + returnValue);
                    }
                    if (encryptData.length != (encLength = this.sm2JNIP11.encryptMsg(sessionHandle.longValue(), sourceData, encryptData))) {
                        throw new CardException("C200CardEncrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + encryptData.length);
                    }
                    Object var11_11 = null;
                    if (sessionHandle == null) break block14;
                }
                catch (CardException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardEncrypt failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", sourceData=").append(Hex.toHexString(sourceData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw e;
                }
                catch (Throwable e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardEncrypt failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", sourceData=").append(Hex.toHexString(sourceData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw new CardException("C200CardEncrypt<<<<<<Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (encLength < encryptData.length) {
            cardEncryptData = new byte[encLength];
            System.arraycopy(encryptData, 0, cardEncryptData, 0, cardEncryptData.length);
        } else {
            cardEncryptData = encryptData;
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("C200CardEncrypt<<<<<<Finished: cardEncryptData=" + SADKDebugger.dump(cardEncryptData));
        }
        return cardEncryptData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] cardDecrypt(CardKey cardKey, byte[] encryptData) throws CardException {
        byte[] cardDecryptData;
        int decLength;
        byte[] decryptData;
        block14: {
            if (encryptData == null || encryptData.length <= 96) {
                throw new CardException("CardDecrypt<<<<<<Failure with invalid encryptData(Required > 96)!");
            }
            decryptData = new byte[encryptData.length - 96];
            long keyHandle = cardKey.getKeyHandle();
            decLength = 0;
            Long sessionHandle = null;
            try {
                try {
                    int returnValue;
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("CardDecrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    if ((returnValue = this.sm2JNIP11.decryptInit(sessionHandle.longValue(), keyHandle)) != 0) {
                        throw new CardException("CardDecrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
                    }
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("CardDecrypt::::::decryptInit: retrunValue=" + returnValue);
                    }
                    if (decryptData.length != (decLength = this.sm2JNIP11.decryptMsg(sessionHandle.longValue(), encryptData, decryptData))) {
                        throw new CardException("CardDecrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + decryptData.length);
                    }
                    Object var11_11 = null;
                    if (sessionHandle == null) break block14;
                }
                catch (CardException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardDecrypt failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", encryptData=").append(Hex.toHexString(encryptData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw e;
                }
                catch (Throwable e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("cardDecrypt failure");
                    builder.append(", sessionHandle=").append(sessionHandle);
                    builder.append(", cardKey=").append(cardKey);
                    builder.append(", encryptData=").append(Hex.toHexString(encryptData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                    throw new CardException("CardDecrypt<<<<<<Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (decLength < decryptData.length) {
            cardDecryptData = new byte[decLength];
            System.arraycopy(decryptData, 0, cardDecryptData, 0, cardDecryptData.length);
        } else {
            cardDecryptData = decryptData;
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("CardDecrypt::<<<<<<Finished: cardDecryptData=" + SADKDebugger.dump(cardDecryptData));
        }
        return cardDecryptData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean SM2CardExternalVerify(SM2CardPublicKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        boolean verifyResult;
        block28: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                String hint = this.buildLoggingSM2CardExternalVerify("SM2CardExternalVerify>>>>>>Running", cardKey, hashValue, signValue);
                LoggerManager.debugLogger.debug(hint);
            }
            if (cardKey == null) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid SM2CardPublicKey");
            }
            if (hashValue == null || hashValue.length != 32) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid hashValue(Required 32)!");
            }
            if (signValue == null) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue!");
            }
            byte[] cardSignValue = null;
            try {
                if (signValue.length == 64) {
                    cardSignValue = signValue;
                } else {
                    if (!ASN1SM2Signature.isASN1SignType(signValue)) {
                        throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue(Required 64 or asn1)!!!");
                    }
                    cardSignValue = new ASN1SM2Signature(signValue).getRSRaw64Bytes();
                }
            }
            catch (CardException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure  with invalid signValue: " + e.getMessage(), e);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2CardExternalVerify::::::cardSignValue=" + SADKDebugger.dump(cardSignValue));
            }
            byte[] sourceExternaData = cardKey.buildExternalData(hashValue);
            long keyHandle = cardKey.getKeyHandle();
            verifyResult = false;
            Long sessionHandle = null;
            try {
                try {
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("SM2CardExternalVerify<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    int returnValue = this.sm2JNIP11.verifyInit(sessionHandle.longValue(), keyHandle, 65548, 1);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("SM2CardExternalVerify::::::verifyInit: retrunValue=" + returnValue);
                    }
                    if (returnValue != 0) {
                        throw new CardException("SM2CardExternalVerify<<<<<<Failure with verifyInit returnValue=" + returnValue);
                    }
                    returnValue = this.sm2JNIP11.verify(sessionHandle.longValue(), sourceExternaData, cardSignValue);
                    if (returnValue == 0) {
                        verifyResult = true;
                    } else {
                        if (LoggerManager.debugLogger.isDebugEnabled()) {
                            LoggerManager.debugLogger.debug("SM2CardExternalVerify<<<<<<Failure with verifyHash returnValue: " + returnValue);
                        }
                        verifyResult = false;
                    }
                }
                catch (CardException e) {
                    String hint = this.buildLoggingSM2CardExternalVerify("SM2CardExternalVerify<<<<<<Failure", cardKey, hashValue, signValue);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw e;
                }
                catch (Exception e) {
                    String hint = this.buildLoggingSM2CardExternalVerify("SM2CardExternalVerify<<<<<<Failure", cardKey, hashValue, signValue);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw new CardException("SM2CardExternalVerify<<<<<<Failure", e);
                }
                catch (Throwable e) {
                    String hint = this.buildLoggingSM2CardExternalVerify("SM2CardExternalVerify<<<<<<Failure", cardKey, hashValue, signValue);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw new CardException("SM2CardExternalVerify<<<<<<Failure", e);
                }
                Object var13_16 = null;
                if (sessionHandle == null) break block28;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2CardExternalVerify<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    private final String buildLoggingSM2CardExternalVerify(String title, SM2CardPublicKey cardKey, byte[] hashValue, byte[] signValue) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(title);
        buffer.append("\n cardKey: ");
        buffer.append(SADKDebugger.dump(cardKey));
        buffer.append("\n hashValue: ");
        buffer.append(SADKDebugger.dump(hashValue));
        buffer.append("\n signValue: ");
        buffer.append(SADKDebugger.dump(signValue));
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] SM2CardExternalEncrypt(SM2CardPublicKey cardKey, byte[] sourceData) throws CardException {
        byte[] cardEncryptData;
        int encLength;
        byte[] encryptData;
        block17: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                String hint = this.buildLoggingSM2CardExternalEncrypt("SM2CardExternalEncrypt>>>>>>Running", cardKey, sourceData);
                LoggerManager.debugLogger.debug(hint);
            }
            if (cardKey == null) {
                throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with invalid SM2CardPublicKey");
            }
            if (sourceData == null || sourceData.length == 0) {
                throw new CardException("SM2CardExternalEncrypt Failure with invalid sourceData(Required > 0)!");
            }
            encryptData = new byte[sourceData.length + 96];
            byte[] sourceExternaData = cardKey.buildExternalData(sourceData);
            long keyHandle = cardKey.getKeyHandle();
            encLength = 0;
            Long sessionHandle = null;
            try {
                try {
                    int returnValue;
                    sessionHandle = this.takeSessionHandle();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("SM2CardExternalEncrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
                    }
                    if ((returnValue = this.sm2JNIP11.encryptInit(sessionHandle.longValue(), keyHandle, 65549)) != 0) {
                        throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
                    }
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("SM2CardExternalEncrypt::::::encryptInit: retrunValue=" + returnValue);
                    }
                    if (encryptData.length != (encLength = this.sm2JNIP11.encryptMsg(sessionHandle.longValue(), sourceExternaData, encryptData))) {
                        throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + encryptData.length);
                    }
                    Object var12_13 = null;
                    if (sessionHandle == null) break block17;
                }
                catch (CardException e) {
                    String hint = this.buildLoggingSM2CardExternalEncrypt("SM2CardExternalEncrypt<<<<<<Failure ", cardKey, sourceData);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw e;
                }
                catch (Exception e) {
                    String hint = this.buildLoggingSM2CardExternalEncrypt("SM2CardExternalEncrypt<<<<<<Failure ", cardKey, sourceData);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw new CardException("SM2CardExternalEncrypt<<<<<<Failure ", e);
                }
                catch (Throwable e) {
                    String hint = this.buildLoggingSM2CardExternalEncrypt("SM2CardExternalEncrypt<<<<<<Failure ", cardKey, sourceData);
                    LoggerManager.exceptionLogger.error(hint, e);
                    throw new CardException("SM2CardExternalEncrypt<<<<<<Failure ", e);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        if (encLength < encryptData.length) {
            cardEncryptData = new byte[encLength];
            System.arraycopy(encryptData, 0, cardEncryptData, 0, cardEncryptData.length);
        } else {
            cardEncryptData = encryptData;
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2CardExternalEncrypt<<<<<<Finished: cardEncryptData=" + SADKDebugger.dump(cardEncryptData));
        }
        return cardEncryptData;
    }

    private final String buildLoggingSM2CardExternalEncrypt(String title, SM2CardPublicKey cardKey, byte[] sourceData) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(title);
        buffer.append("\n cardKey: ");
        buffer.append(SADKDebugger.dump(cardKey));
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        return buffer.toString();
    }

    final KeyPair getKeyPair(BCECPublicKey pubKey) {
        return (KeyPair)this.cardKeys.get(new HashKey(pubKey));
    }

    final KeyPair getKeyPair(SM2PublicKey pubKey) {
        return (KeyPair)this.cardKeys.get(new HashKey(pubKey));
    }

    final PublicKey expoertEncPublicKey() throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("expoertEncPublicKey>>>>>>Running");
        }
        byte[] keyData = new byte[64];
        SM2PublicKey pubKey = null;
        try {
            int returnValue = this.sm2JNIP11.exportProtectKey(this.sessionHandle, -1040183278L, keyData);
            if (returnValue != 0) {
                throw new CardException("expoertEncPublicKey<<<<<<Failure with returnValue=" + returnValue);
            }
            byte[] tempPublicKeyX = new byte[32];
            byte[] tempPublicKeyY = new byte[32];
            System.arraycopy(keyData, 0, tempPublicKeyX, 0, 32);
            System.arraycopy(keyData, 32, tempPublicKeyY, 0, 32);
            pubKey = new SM2PublicKey(tempPublicKeyX, tempPublicKeyY);
        }
        catch (Exception e) {
            throw new CardException("expoertEncPublicKey<<<<<<Failure: " + e.getMessage(), e);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("expoertEncPublicKey<<<<<<Finished: SM2PublicKey=" + SADKDebugger.dump(pubKey));
        }
        return pubKey;
    }

    final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("importSM2KeyPair>>>>>>Running");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: ");
            buffer.append(SADKDebugger.dump(String.valueOf(CKID)));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        String CKIDString = String.valueOf(CKID);
        try {
            if (this.isECCKey(CKIDString)) {
                throw new CardException("importSM2KeyPair<<<<<<Failure ECC key is not support");
            }
            int returnValue = this.sm2JNIP11.ImportSM2KeyPair(this.sessionHandle, 1, CKIDString, encryptKeyData);
            LoggerManager.systemLogger.info("importSM2KeyPair::::<<<<<<Finished: returnValue--> " + returnValue);
            KeyPair keypair = this.cardInitKeyPair(this.sm2JNIP11, this.sessionHandle, CKIDString, 1);
            if (keypair != null) {
                HashKey hashKey = null;
                hashKey = this.isECCKey(CKIDString) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                this.cardKeys.put(hashKey, keypair);
                LoggerManager.systemLogger.info("importSM2KeyPair::::<<<<<<Finished: updateEncryptKey--> " + hashKey);
            }
            return true;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append("importSM2KeyPair failure");
            builder.append(", sessionHandle=").append(this.sessionHandle);
            builder.append(", CKID(keyIndex)=").append(CKID);
            builder.append(", encryptKeyData=").append(Hex.toHexString(encryptKeyData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new CardException("importSM2KeyPair<<<<<<Failure", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder();
            builder.append("importSM2KeyPair failure");
            builder.append(", sessionHandle=").append(this.sessionHandle);
            builder.append(", CKID(keyIndex)=").append(CKID);
            builder.append(", encryptKeyData=").append(Hex.toHexString(encryptKeyData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new CardException("importSM2KeyPair<<<<<<Failure", e);
        }
    }

    private boolean isECCKey(String CKID) {
        boolean isecc = false;
        int intCKID = Integer.parseInt(CKID);
        if (intCKID >= this.minECCIndex && intCKID <= this.maxECCIndex) {
            isecc = true;
        }
        return isecc;
    }

    protected boolean isECCKey(int intCKID) {
        boolean isecc = false;
        if (intCKID >= this.minECCIndex && intCKID <= this.maxECCIndex) {
            isecc = true;
        }
        return isecc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cardIdleTest() throws CardException {
        Long sessionHandle;
        boolean cardIdleTest;
        block7: {
            LoggerManager.systemLogger.info("cardIdleTest::>>>>>>Running");
            cardIdleTest = false;
            sessionHandle = null;
            try {
                try {
                    sessionHandle = this.takeSessionHandle();
                    LoggerManager.systemLogger.info("cardIdleTest<<<<<<sessionHandle: {}", (Object)sessionHandle);
                    long returnValue = this.supportIdleTest ? (long)this.sm2JNIP11.idleTest(sessionHandle.longValue()) : 0L;
                    LoggerManager.systemLogger.info("cardIdleTest<<<<<<returnValue={}", (Object)returnValue);
                    boolean bl = cardIdleTest = returnValue == 0L;
                    if (!cardIdleTest) {
                        LoggerManager.exceptionLogger.error("cardIdleTest::<<<<<<returnValue={}", (Object)returnValue);
                        throw new CardException("cardIdleTest::<<<<<<Failure: returnValue=" + returnValue);
                    }
                    Object var6_6 = null;
                    if (sessionHandle == null) break block7;
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("cardIdleTest::<<<<<<Failure", e);
                    throw new CardException("cardIdleTest failure: " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.error("checkIdleTest::<<<<<<Failure", e);
                    throw new CardException("cardIdleTest failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        LoggerManager.systemLogger.info("cardIdleTest:::<<<<<<Successfully, sessionHandle={}", (Object)sessionHandle);
        return cardIdleTest;
    }

    public final class HashKey {
        final byte[] defaultZ;

        public HashKey(SM2PublicKey sm2Key) {
            this.defaultZ = sm2Key.getDefaultZ();
        }

        public HashKey(SM2CardPublicKey sm2Key) {
            this.defaultZ = sm2Key.getDefaultZ();
        }

        public HashKey(ECCCardPublicKey eccKey) {
            this.defaultZ = eccKey.getDefaultZ();
        }

        public HashKey(BCECPublicKey eccKey) {
            this.defaultZ = SM2Params.calcZ(eccKey.getQ().getX().getEncoded(), eccKey.getQ().getY().getEncoded());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.defaultZ);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKey other = (HashKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.defaultZ, other.defaultZ);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HashKey [defaultZ=");
            builder.append(Hex.toHexString(this.defaultZ));
            builder.append("]");
            return builder.toString();
        }

        private C200CardP11 getOuterType() {
            return C200CardP11.this;
        }
    }
}

