/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.bcsoft;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2Crypto;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM2Result;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.lib.crypto.BaseLib;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.sadk.org.bouncycastle.crypto.engines.RSAEngine;
import cfca.sadk.org.bouncycastle.crypto.generators.SM2KeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.signers.ECDSASigner;
import cfca.sadk.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.ECCSuportedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.signature.rsa.RSAKeyParamsDecoder;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;

public final class BCSoftLib
extends BaseLib {
    private static final Provider SADK_PROVIDER = SADKProvider.INSTANCE();
    private static volatile Session singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Session INSTANCE() {
        if (singleton != null) return singleton;
        Class<BCSoftLib> clazz = BCSoftLib.class;
        synchronized (BCSoftLib.class) {
            if (singleton != null) return singleton;
            singleton = new BCSoftLib();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected final KeyPair SM2GenerateKeyPair() throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2GenerateKeyPair::>>>>>>Running");
        }
        try {
            KeyPair keypair = SM2KeyPairGenerator.SM2GenerateKeyPair();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2GenerateKeyPair::<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            GMTPrivateKey tmp_privateKey = (GMTPrivateKey)keypair.getPrivate();
            GMTPublicKey tmp_publicKey = (GMTPublicKey)keypair.getPublic();
            SM2PrivateKey privKey = new SM2PrivateKey(tmp_privateKey.getD(), tmp_publicKey.getPubX_Int(), tmp_publicKey.getPubY_Int());
            return new KeyPair(privKey.getSM2PublicKey(), privKey);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2GenerateKeyPair::<<<<<<Failure", e);
            throw new PKIException("GenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final KeyPair ECCGenerateKeyPair(Mechanism mechanism) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("ECGenerateKeyPair::>>>>>>Running: mechanism=" + SADKDebugger.dump(mechanism));
        }
        try {
            ECNamedCurveGenParameterSpec params = null;
            String curveName = mechanism.getCurveName();
            boolean isSupport = true;
            if (curveName == null) {
                curveName = "prime256v1";
            } else {
                isSupport = ECCSuportedCurves.isSupportedCurve(curveName);
            }
            if (isSupport) {
                ASN1ObjectIdentifier oid = ECUtil.getNamedCurveOid(curveName);
                if (oid == null) {
                    throw new PKIException("generateKeyPair " + curveName + " is not supported!");
                }
                params = new ECNamedCurveGenParameterSpec(curveName);
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("EC", SADK_PROVIDER);
                }
                catch (Exception e) {
                    throw new PKIException("ECGenerateKeyPair failure with exception: " + e.getMessage(), e);
                }
                try {
                    keyPairGen.initialize(params, new SecureRandom());
                    KeyPair keyPair = keyPairGen.generateKeyPair();
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("ECGenerateKeyPair::<<<<<<Finished: keypair=" + SADKDebugger.dump(keyPair));
                    }
                    return keyPair;
                }
                catch (Exception e) {
                    throw new PKIException("ECGenerateKeyPair failure with exception: " + e.getMessage(), e);
                }
            }
            throw new PKIException("ECGenerateKeyPair failure with exception: " + curveName + " is not support!");
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("ECGenerateKeyPair::<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECGenerateKeyPair::<<<<<<Failure", e);
            throw new PKIException("ECGenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final KeyPair RSAGenerateKeyPair(int bitLength) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAGenerateKeyPair::>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            if (bitLength < 0 || bitLength > 4096 || bitLength % 512 != 0) {
                throw new PKIException("RSAGenerateKeyPair failure with invalid bitLength=" + bitLength);
            }
            KeyPairGenerator keyPairGen = null;
            try {
                keyPairGen = KeyPairGenerator.getInstance("RSA", SADK_PROVIDER);
            }
            catch (Exception e) {
                throw new PKIException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
            try {
                keyPairGen.initialize(bitLength);
                KeyPair keypair = keyPairGen.generateKeyPair();
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSAGenerateKeyPair::<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
                }
                return keypair;
            }
            catch (Exception e) {
                throw new PKIException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair::<<<<<<Failure", e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair::<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2EncryptMessage(SM2PublicKey sm2PublicKey, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2EncryptMessage::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PublicKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            SM2Crypto crypto = new SM2Crypto();
            crypto.initEncrypt(sm2PublicKey.getQ());
            byte[] encryptData = crypto.encrypt(message);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM2EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM2EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2DecryptMessage(SM2PrivateKey sm2PrivateKey, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2DecryptMessage::>>>>>>Running");
            buffer.append("\n sm2PrivateKey: ");
            buffer.append(SADKDebugger.dump(sm2PrivateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            SM2Crypto crypto = new SM2Crypto();
            crypto.initDecrypt(sm2PrivateKey.getDByInt());
            byte[] decryptData = crypto.decrypt(encryptData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2DecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM2DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM2DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2SignHash(SM2PrivateKey sm2PrivateKey, byte[] hashValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2SignHash::>>>>>>Running");
            buffer.append("\n sm2PrivateKey: ");
            buffer.append(SADKDebugger.dump(sm2PrivateKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] signValue = SM2PackageUtil.encryptByBC(hashValue, sm2PrivateKey);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2SignHash::<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            }
            return signValue;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2SignHash::<<<<<<Failure", e);
            throw new PKIException("SM2SignHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2SignHash::<<<<<<Failure", e);
            throw new PKIException("SM2SignHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final boolean SM2VerifyHash(SM2PublicKey sm2PublicKey, byte[] hashValue, byte[] signValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2VerifyHash::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PublicKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            boolean verifyResult = SM2PackageUtil.verifyByBC(hashValue, signValue, sm2PublicKey);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2VerifyHash::<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2VerifyHash::<<<<<<Failure", e);
            throw new PKIException("SM2VerifyHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2VerifyHash::<<<<<<Failure", e);
            throw new PKIException("SM2VerifyHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2HashMessage(SM2PublicKey sm2PubKey, byte[] message, boolean withZ) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2HashMessage::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PubKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            buffer.append("\n withZ: " + withZ);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] hashValue = new byte[32];
            SM3Digest sm3Hash = new SM3Digest();
            if (withZ) {
                sm3Hash.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            sm3Hash.update(message, 0, message.length);
            sm3Hash.doFinal(hashValue, 0);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2HashMessage::<<<<<<Finished: hashValue=" + SADKDebugger.dump(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HashMessage::<<<<<<Failure", e);
            throw new PKIException("SM2HashMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HashMessage::<<<<<<Failure", e);
            throw new PKIException("SM2HashMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2HashFile(SM2PublicKey sm2PubKey, InputStream stream, boolean withZ) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2HashFile::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PubKey));
            buffer.append("\n stream: ");
            buffer.append(SADKDebugger.dump(stream));
            buffer.append("\n withZ: " + withZ);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] hashValue = new byte[32];
            byte[] buffer = new byte[65536];
            SM3Digest engine = new SM3Digest();
            if (withZ) {
                engine.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            int rLength = 0;
            while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
                engine.update(buffer, 0, rLength);
            }
            engine.doFinal(hashValue, 0);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2HashFile::<<<<<<Finished: hashValue=" + SADKDebugger.dump(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HashFile::<<<<<<Failure", e);
            throw new PKIException("SM2HashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HashFile::<<<<<<Failure", e);
            throw new PKIException("SM2HashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAEncryptMessage(PublicKey publicKey, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAEncryptMessage::>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            RSAKeyParameters param = RSAKeyParamsDecoder.generatePublicKeyParameter(publicKey);
            AsymmetricBlockCipher eng = new RSAEngine();
            eng = new PKCS1Encoding(eng);
            eng.init(true, param);
            byte[] encryptData = eng.processBlock(message, 0, message.length);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("RSAEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("RSAEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSADecryptMessage(PrivateKey privateKey, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSADecryptMessage::>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            RSAKeyParameters param = RSAKeyParamsDecoder.generatePrivateKeyParameter(privateKey);
            AsymmetricBlockCipher eng = new RSAEngine();
            eng = new PKCS1Encoding(eng);
            eng.init(false, param);
            byte[] decryptData = eng.processBlock(encryptData, 0, encryptData.length);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSADecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSADecryptMessage::<<<<<<Failure", e);
            throw new PKIException("RSADecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSADecryptMessage::<<<<<<Failure", e);
            throw new PKIException("RSADecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSASignHash(PrivateKey privateKey, byte[] hashWithAlgorithm) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSASignHash::>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n hashWithAlgorithm: ");
            buffer.append(SADKDebugger.dump(hashWithAlgorithm));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] signValue = RSAPackageUtil.encrypt(hashWithAlgorithm, privateKey);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSASignHash::<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            }
            return signValue;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSASignHash::<<<<<<Failure", e);
            throw new PKIException("RSASignHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSASignHash::<<<<<<Failure", e);
            throw new PKIException("RSASignHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final boolean RSAVerifyHash(PublicKey publicKey, byte[] hashWithAlgorithm, byte[] signValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAVerifyHash::>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n hashWithAlgorithm: ");
            buffer.append(SADKDebugger.dump(hashWithAlgorithm));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptedBytes = RSAPackageUtil.decrypt(signValue, publicKey);
            boolean verifyResult = RSAPackageUtil.isRSAHashEqual(decryptedBytes, hashWithAlgorithm);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAVerifyHash::<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAVerifyHash::<<<<<<Failure", e);
            throw new PKIException("RSAVerifyHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAVerifyHash::<<<<<<Failure", e);
            throw new PKIException("RSAVerifyHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAHashMessage(Mechanism mechanism, byte[] message) throws PKIException {
        return this.RSAHashMessage(mechanism, message, true);
    }

    protected byte[] RSAHashMessage(Mechanism mechanism, byte[] message, boolean isDerEncoding) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAHashMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] hashWithAlgorithm = HashUtil.RSAHashMessageByBC(message, mechanism, isDerEncoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAHashMessage::<<<<<<Finished: hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
            }
            return hashWithAlgorithm;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAHashMessage::<<<<<<Failure", e);
            throw new PKIException("RSAHashMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAHashMessage::<<<<<<Failure", e);
            throw new PKIException("RSAHashMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAHashFile(Mechanism mechanism, InputStream stream) throws PKIException {
        return this.RSAHashFile(mechanism, stream, true);
    }

    protected byte[] RSAHashFile(Mechanism mechanism, InputStream stream, boolean isDerEncoding) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAHashFile::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n stream: ");
            buffer.append(SADKDebugger.dump(stream));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] hashWithAlgorithm = HashUtil.RSAHashFileByBC(stream, mechanism, isDerEncoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAHashFile::<<<<<<Finished: hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
            }
            return hashWithAlgorithm;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAHashFile::<<<<<<Failure", e);
            throw new PKIException("RSAHashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAHashFile::<<<<<<Failure", e);
            throw new PKIException("RSAHashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM4EncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM4EncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(false, mechanism, key.getEncoded(), message);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM4EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM4EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM4EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM4EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM4EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM4DecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(false, mechanism, key.getEncoded(), encryptData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM4DecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM4DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM4DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM4DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("SM4DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RC4EncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RC4EncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(false, mechanism, key.getEncoded(), message);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RC4EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RC4EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("RC4EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RC4EncryptMessage::<<<<<<Failure", e);
            throw new PKIException("RC4EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RC4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RC4DecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(false, mechanism, key.getEncoded(), encryptData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RC4DecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RC4DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("RC4DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RC4DecryptMessage::<<<<<<Failure", e);
            throw new PKIException("RC4DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] DESedeEncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("DESedeEncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(false, mechanism, key.getEncoded(), message);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("DESedeEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("DESedeEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("DESedeEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("DESedeEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("DESedeEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] DESedeDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("DESedeDecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(false, mechanism, key.getEncoded(), encryptData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("DESedeDecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("DESedeDecryptMessage::<<<<<<Failure", e);
            throw new PKIException("DESedeDecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("DESedeDecryptMessage::<<<<<<Failure", e);
            throw new PKIException("DESedeDecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] AESEncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("AESEncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(false, mechanism, key.getEncoded(), message);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("AESEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("AESEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("AESEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("AESEncryptMessage::<<<<<<Failure", e);
            throw new PKIException("AESEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] AESDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("AESDecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(false, mechanism, key.getEncoded(), encryptData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("AESDecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("AESDecryptMessage::<<<<<<Failure", e);
            throw new PKIException("AESDecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("AESDecryptMessage::<<<<<<Failure", e);
            throw new PKIException("AESDecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final void SM2HashFile(SM2PublicKey sm2PubKey, boolean supportedWithoutZ, InputStream stream, byte[] hashWithZ, byte[] hashWithoutZ) throws PKIException {
        Object buffer;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append("SM2HashFile::>>>>>>Running");
            ((StringBuilder)buffer).append("\n sm2PubKey: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(sm2PubKey));
            ((StringBuilder)buffer).append("\n supportedWithoutZ: " + supportedWithoutZ);
            ((StringBuilder)buffer).append("\n stream: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(stream));
            LoggerManager.debugLogger.debug(((StringBuilder)buffer).toString());
        }
        try {
            buffer = new byte[65536];
            SM3Digest engineWithZ = new SM3Digest();
            engineWithZ.update(sm2PubKey.getDefaultZ(), 0, 32);
            SM3Digest engineWithoutZ = null;
            if (supportedWithoutZ) {
                engineWithoutZ = new SM3Digest();
            }
            int rLength = 0;
            while ((rLength = stream.read((byte[])buffer, 0, ((Object)buffer).length)) != -1) {
                engineWithZ.update((byte[])buffer, 0, rLength);
                if (!supportedWithoutZ) continue;
                engineWithoutZ.update((byte[])buffer, 0, rLength);
            }
            engineWithZ.doFinal(hashWithZ, 0);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2HashFile::<<<<<<Finished: hashWithZ=" + SADKDebugger.dump(hashWithZ));
            }
            if (supportedWithoutZ) {
                engineWithoutZ.doFinal(hashWithoutZ, 0);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2HashFile::<<<<<<Finished: hashWithoutZ=" + SADKDebugger.dump(hashWithoutZ));
                }
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2HashFile::<<<<<<Failure", e);
            throw new PKIException("SM2HashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2HashFile::<<<<<<Failure", e);
            throw new PKIException("SM2HashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final byte[] ECDSASignHash(PrivateKey privateKey, byte[] hashWithoutAlgorithm, Mechanism mechanism) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("ECDSASignHash::>>>>>>Running");
            buffer2.append("\n privateKey: ");
            buffer2.append(SADKDebugger.dump(privateKey));
            buffer2.append("\n hashWithoutAlgorithm: ");
            buffer2.append(SADKDebugger.dump(hashWithoutAlgorithm));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                Digest engine = Mechanisms.getDigest(mechanism.getMechanismType());
                ECDSASigner ecSigner = new ECDSASigner(new HMacDSAKCalculator(engine));
                ECPrivateKey ecPriKey = (ECPrivateKey)privateKey;
                ecSigner.init(true, ECUtil.generatePrivateKeyParameter(ecPriKey));
                BigInteger[] signature = ecSigner.generateSignature(hashWithoutAlgorithm);
                byte[] sign = new byte[64];
                System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(signature[0]), 0, sign, 0, 32);
                System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(signature[1]), 0, sign, 32, 32);
                byte[] signValue = sign;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("ECDSASignHash::<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
                }
                byArray = signValue;
                Object var13_15 = null;
                if (!isFailed) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("ECDSASignHash::>>>>>>Running");
            }
            catch (Exception e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSASignHash::<<<<<<Failure", e);
                throw new PKIException("ECDSASignHash failure with exception: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSASignHash::<<<<<<Failure", e);
                throw new PKIException("ECDSASignHash failure with throwable: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!isFailed) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("ECDSASignHash::>>>>>>Running");
            buffer3.append("\n privateKey: ");
            buffer3.append(SADKDebugger.dump(privateKey));
            buffer3.append("\n hashWithoutAlgorithm: ");
            buffer3.append(SADKDebugger.dump(hashWithoutAlgorithm));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n privateKey: ");
        buffer3.append(SADKDebugger.dump(privateKey));
        buffer3.append("\n hashWithoutAlgorithm: ");
        buffer3.append(SADKDebugger.dump(hashWithoutAlgorithm));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean ECDSAVerifyHash(PublicKey publicKey, byte[] hashWithoutAlgorithm, byte[] signValue, Mechanism mechanism) throws PKIException {
        StringBuilder buffer3;
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("ECDSAVerifyHash::>>>>>>Running");
            buffer2.append("\n publicKey: ");
            buffer2.append(SADKDebugger.dump(publicKey));
            buffer2.append("\n hashWithAlgorithm: ");
            buffer2.append(SADKDebugger.dump(hashWithoutAlgorithm));
            buffer2.append("\n signValue: ");
            buffer2.append(SADKDebugger.dump(signValue));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                Digest engine = Mechanisms.getDigest(mechanism.getMechanismType());
                ECDSASigner ecSigner = new ECDSASigner(new HMacDSAKCalculator(engine));
                ECPublicKey ecPubKey = (ECPublicKey)publicKey;
                ecSigner.init(false, ECUtil.generatePublicKeyParameter(ecPubKey));
                SM2Result sm2Ret = null;
                if (signValue != null && signValue.length == 64) {
                    sm2Ret = new SM2Result();
                    sm2Ret.r = new BigInteger(1, Arrays.copyOfRange(signValue, 0, 32));
                    sm2Ret.s = new BigInteger(1, Arrays.copyOfRange(signValue, 32, 64));
                } else {
                    if (!ASN1SM2Signature.isASN1SignType(signValue)) throw new Exception("the signature data is null or not 64 bytes!");
                    ASN1SM2Signature signature = new ASN1SM2Signature(signValue);
                    sm2Ret = new SM2Result();
                    sm2Ret.r = signature.getR().getPositiveValue();
                    sm2Ret.s = signature.getS().getPositiveValue();
                }
                boolean verifyResult = ecSigner.verifySignature(hashWithoutAlgorithm, sm2Ret.r, sm2Ret.s);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("ECDSAVerifyHash::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var13_16 = null;
                if (!isFailed) return bl;
                buffer3 = new StringBuilder();
                buffer3.append("ECDSAVerifyHash::>>>>>>Running");
            }
            catch (Exception e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSAVerifyHash::<<<<<<Failure", e);
                throw new PKIException("ECDSAVerifyHash failure with exception: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSAVerifyHash::<<<<<<Failure", e);
                throw new PKIException("ECDSAVerifyHash failure with throwable: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (!isFailed) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("ECDSAVerifyHash::>>>>>>Running");
            buffer3.append("\n publicKey: ");
            buffer3.append(SADKDebugger.dump(publicKey));
            buffer3.append("\n hashWithAlgorithm: ");
            buffer3.append(SADKDebugger.dump(hashWithoutAlgorithm));
            buffer3.append("\n signValue: ");
            buffer3.append(SADKDebugger.dump(signValue));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n publicKey: ");
        buffer3.append(SADKDebugger.dump(publicKey));
        buffer3.append("\n hashWithAlgorithm: ");
        buffer3.append(SADKDebugger.dump(hashWithoutAlgorithm));
        buffer3.append("\n signValue: ");
        buffer3.append(SADKDebugger.dump(signValue));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final byte[] ECCEncryptMessage(PublicKey publicKey, byte[] message) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("ECDSAEncryptMessage::>>>>>>Running");
            buffer2.append("\n publicKey: ");
            buffer2.append(SADKDebugger.dump(publicKey));
            buffer2.append("\n message: ");
            buffer2.append(SADKDebugger.dump(message));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                IESCipher.ECIES engine = new IESCipher.ECIES();
                engine.engineInit(1, publicKey, new SecureRandom());
                byte[] encryptData = engine.engineDoFinal(message, 0, message.length);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("ECDSAEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
                }
                byArray = encryptData;
                Object var8_10 = null;
                if (!isFailed) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("ECDSAEncryptMessage::>>>>>>Running");
            }
            catch (Exception e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSAEncryptMessage::<<<<<<Failure", e);
                throw new PKIException("ECDSAEncryptMessage failure with exception: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSAEncryptMessage::<<<<<<Failure", e);
                throw new PKIException("ECDSAEncryptMessage failure with throwable: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!isFailed) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("ECDSAEncryptMessage::>>>>>>Running");
            buffer3.append("\n publicKey: ");
            buffer3.append(SADKDebugger.dump(publicKey));
            buffer3.append("\n message: ");
            buffer3.append(SADKDebugger.dump(message));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n publicKey: ");
        buffer3.append(SADKDebugger.dump(publicKey));
        buffer3.append("\n message: ");
        buffer3.append(SADKDebugger.dump(message));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final byte[] ECCDecryptMessage(PrivateKey privateKey, byte[] encryptData) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("ECDSADecryptMessage::>>>>>>Running");
            buffer2.append("\n privateKey: ");
            buffer2.append(SADKDebugger.dump(privateKey));
            buffer2.append("\n encryptData: ");
            buffer2.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        boolean isFailed = false;
        try {
            try {
                IESCipher.ECIES engine = new IESCipher.ECIES();
                engine.engineInit(2, privateKey, new SecureRandom());
                byte[] decryptData = engine.engineDoFinal(encryptData, 0, encryptData.length);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("ECDSADecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
                }
                byArray = decryptData;
                Object var8_10 = null;
                if (!isFailed) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("ECDSADecryptMessage::>>>>>>Running");
            }
            catch (Exception e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSADecryptMessage::<<<<<<Failure", e);
                throw new PKIException("ECDSADecryptMessage failure with exception: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("ECDSADecryptMessage::<<<<<<Failure", e);
                throw new PKIException("ECDSADecryptMessage failure with throwable: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!isFailed) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("ECDSADecryptMessage::>>>>>>Running");
            buffer3.append("\n privateKey: ");
            buffer3.append(SADKDebugger.dump(privateKey));
            buffer3.append("\n encryptData: ");
            buffer3.append(SADKDebugger.dump(encryptData));
            LoggerManager.exceptionLogger.error(buffer3.toString());
            throw throwable;
        }
        buffer3.append("\n privateKey: ");
        buffer3.append(SADKDebugger.dump(privateKey));
        buffer3.append("\n encryptData: ");
        buffer3.append(SADKDebugger.dump(encryptData));
        LoggerManager.exceptionLogger.error(buffer3.toString());
        return byArray;
    }

    public final PublicKey exportEncPublicKey() throws PKIException {
        throw new PKIException("exportEncPublicKey failure: BCSoftLib not supported!");
    }

    public final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws PKIException {
        throw new PKIException("importSM2KeyPair failure: BCSoftLib not supported!");
    }

    public final String getDeviceName() {
        return "JSOFT_LIB";
    }

    public final int getDeviceType() {
        return 0;
    }

    public final boolean useJniNativeOperation() throws PKIException {
        return false;
    }
}

