/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto;

import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.PropertiesReader;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;

public final class ExtendLibFactory {
    private ExtendLibFactory() {
    }

    public static final Session buildExtendLib(String cardIniPath) throws Exception {
        String sessionExtendClassPath;
        Session session = null;
        if (cardIniPath != null && cardIniPath.trim().length() != 0 && (sessionExtendClassPath = ExtendLibFactory.getSessionExtendClassPath(cardIniPath)) != null && sessionExtendClassPath.trim().length() != 0) {
            session = ExtendLibFactory.buildExtendLib(sessionExtendClassPath, cardIniPath);
        }
        return session;
    }

    private static String getSessionExtendClassPath(String configFilePath) throws Exception {
        String sessionExtendClassPath = null;
        if (FileHelper.isFileExist(configFilePath)) {
            Properties properties = PropertiesReader.loadPropertiesFile(new File(configFilePath));
            sessionExtendClassPath = properties.getProperty("ExtendLib.sessionExtendClassPath");
        }
        return sessionExtendClassPath;
    }

    private static Session buildExtendLib(String sessionExtendClassPath, String cryptoInfoFilePath) throws Exception {
        Session session = null;
        try {
            LoggerManager.systemLogger.info("buildExtendLib beginning ImplClass=" + sessionExtendClassPath);
            Class<?> clazz = Class.forName(sessionExtendClassPath);
            Method singletonMethod = clazz.getMethod("getSingleton", String.class);
            session = (Session)singletonMethod.invoke(null, cryptoInfoFilePath);
            LoggerManager.systemLogger.info("buildExtendLib finished ImplClass=" + sessionExtendClassPath);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("buildExtendLib failure with " + sessionExtendClassPath, e);
            throw new Exception("buildExtendLib failure with " + sessionExtendClassPath, e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("buildExtendLib failure with " + sessionExtendClassPath, e);
            throw new Exception("buildExtendLib failure with " + sessionExtendClassPath, e);
        }
        return session;
    }
}

