/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Formatter;

final class RSACardDummyPublicKey
implements RSAPublicKey {
    private static final long serialVersionUID = 1180631091343185626L;
    private final RSAPublicKey publicKeyRef;
    private final byte[] x509EncodedBytes;
    final byte[] jniEncodedBytes;
    final int moduleBytesLength;
    final String jniEncodedBytesMD5;
    final String modulus;

    public RSACardDummyPublicKey(RSAPublicKey publicKeyRef) throws CryptoException {
        if (publicKeyRef == null) {
            throw new CryptoParameterException("missing publicKeyRef");
        }
        this.publicKeyRef = publicKeyRef;
        this.jniEncodedBytes = this.buildEncodedBytes(publicKeyRef);
        this.moduleBytesLength = (7 + publicKeyRef.getModulus().bitLength()) / 8;
        this.jniEncodedBytesMD5 = NumberHelper.md5(this.jniEncodedBytes);
        this.modulus = publicKeyRef.getModulus().toString(16);
        try {
            this.x509EncodedBytes = publicKeyRef.getEncoded();
        }
        catch (Exception e) {
            throw new CryptoParameterException("invalid publicKeyRef with x509EncodedBytes", e);
        }
    }

    public String getAlgorithm() {
        return this.publicKeyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.publicKeyRef.getFormat();
    }

    public byte[] getEncoded() {
        return this.x509EncodedBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jniEncodedBytes);
        result = 31 * result + this.moduleBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSACardDummyPublicKey other = (RSACardDummyPublicKey)obj;
        if (!Arrays.equals(this.jniEncodedBytes, other.jniEncodedBytes)) {
            return false;
        }
        return this.moduleBytesLength == other.moduleBytesLength;
    }

    public String toString() {
        Formatter builder = new Formatter();
        builder.format("DummyRSAPublicKey ", new Object[0]);
        try {
            builder.format("\n%8s%20s=0x%s", "", "Modulus", this.publicKeyRef.getModulus().toString(16));
            builder.format("\n%8s%20s=0x%s", "", "PublicExponent", this.publicKeyRef.getPublicExponent().toString(16));
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("DummyRSAPublicKey dump detail invalid", e);
            builder.format("\n%8s%20s=0x%s", "", "k", "failure");
        }
        builder.format("\n%4s%20s=0x%s", "", "jniEncodedBytes", DataHelper.toHexString(this.jniEncodedBytes));
        builder.format("\n%4s%20s=%s", "", "moduleBytesLength", this.moduleBytesLength);
        String output = builder.toString();
        builder.close();
        return output;
    }

    private final byte[] buildEncodedBytes(RSAPublicKey publicKey) throws CryptoException {
        byte[] jniEncodedBytes = null;
        try {
            byte[] data = publicKey.getEncoded();
            ASN1Sequence s = ASN1Sequence.getInstance(data);
            byte[] bitStr = s.getObjectAt(1).toASN1Primitive().getEncoded();
            int len = bitStr[1] & 0x7F;
            int ret_len = bitStr.length - len - 3;
            jniEncodedBytes = new byte[ret_len];
            System.arraycopy(bitStr, len + 3, jniEncodedBytes, 0, ret_len);
        }
        catch (Exception e) {
            throw new CryptoParameterException("buildEncodedBytes failure", e);
        }
        return jniEncodedBytes;
    }

    public BigInteger getModulus() {
        return this.publicKeyRef.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.publicKeyRef.getPublicExponent();
    }

    public String dumpPublicKey() {
        return String.format("(bitLength=%d, md5=%s, modulus=%s)", this.moduleBytesLength << 3, this.jniEncodedBytesMD5, this.modulus);
    }
}

