/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.IExtendRSA;
import cfca.sadk.extend.session.bridge.ICryptoBridgePartRSA;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardConstant;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardHashHelper;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardInvalidKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardLoggings;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardP1Decoder;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class RSACard
implements IExtendRSA,
RSACardConstant {
    private static final Session SOFTLIB_SESSION = BCSoftLib.INSTANCE();
    private final ICryptoBridgePartRSA cryptoAPI;

    public RSACard(ICryptoBridgePartRSA cryptoAPI) throws CryptoException {
        if (cryptoAPI == null) {
            throw new CryptoException("CryptoEngine construct failed: cryptoAPI is NULL");
        }
        this.cryptoAPI = cryptoAPI;
    }

    public final KeyPair generateKeyPair(boolean isExport, int bitLength, int keyIndex, int keyUsage) throws CryptoException {
        KeyPair keyPair;
        try {
            if (isExport) {
                keyPair = this.generateExternalKeyPair(bitLength);
                this.checkKeyPair(keyPair, keyUsage);
            } else {
                keyPair = this.generateInternalKeyPair(keyIndex, keyUsage);
                this.checkKeyPair(keyPair, keyUsage);
            }
        }
        catch (CryptoException e) {
            RSACardLoggings.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw e;
        }
        catch (Exception e) {
            RSACardLoggings.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw new CryptoException("RSACard generateKeyPair failure", e);
        }
        catch (Throwable e) {
            RSACardLoggings.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw new CryptoException("RSACard generateKeyPair failure", e);
        }
        return keyPair;
    }

    public final byte[] signByHash(PrivateKey privateKey, byte[] hashWithAlgorithm) throws CryptoException {
        RSAPrivateKey rsaKey = RSACardKeyHelper.buildPrivateKey(privateKey);
        RSACardKey privKey = rsaKey instanceof RSACardKey ? (RSACardKey)((Object)rsaKey) : RSACardInvalidKey.INSTANCE;
        try {
            byte[] signData;
            if (privKey instanceof RSACardInvalidKey) {
                signData = RSAPackageUtil.encrypt(hashWithAlgorithm, privateKey);
            } else {
                byte[] dataInput = RSACardP1Decoder.addPKCS1Padding(hashWithAlgorithm, privKey.modulusByteLength(), true);
                signData = this.cardPrivateKeyOperationRSA(privKey, dataInput);
            }
            return signData;
        }
        catch (CryptoException e) {
            RSACardLoggings.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw e;
        }
        catch (Exception e) {
            RSACardLoggings.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw new CryptoException("RSACard signByHash failure", e);
        }
        catch (Throwable e) {
            RSACardLoggings.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw new CryptoException("RSACard signByHash failure", e);
        }
    }

    public final boolean verifyByHash(PublicKey publicKey, byte[] hashWithAlgorithm, byte[] signedData) throws CryptoException {
        boolean verifyResult;
        RSAPublicKey rsaKey = RSACardKeyHelper.buildPublicKey(publicKey);
        RSACardKey pubKey = rsaKey instanceof RSACardKey ? (RSACardKey)((Object)rsaKey) : RSACardInvalidKey.INSTANCE;
        int modulusLength = pubKey.modulusByteLength();
        try {
            byte[] dataOutput = this.cardPublicKeyOperationRSA(pubKey, signedData);
            byte[] decryptDigestInfo = RSACardP1Decoder.delPKCS1Padding(dataOutput, modulusLength, true);
            verifyResult = Arrays.equals(decryptDigestInfo, hashWithAlgorithm);
            if (!verifyResult && LoggerManager.exceptionLogger.isWarnEnabled()) {
                StringBuilder builder = new StringBuilder(1024);
                builder.append("RSACard verifyByHash failure: ");
                builder.append("\n hashWithAlgorithm: 0x").append(DataHelper.dump4KPartData(hashWithAlgorithm));
                builder.append("\n signedData: 0x").append(DataHelper.dump4KPartData(signedData));
                builder.append("\n publicKey: ").append(publicKey);
                String warnning = builder.toString();
                LoggerManager.exceptionLogger.warn(warnning);
            }
        }
        catch (CryptoException e) {
            RSACardLoggings.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw e;
        }
        catch (Exception e) {
            RSACardLoggings.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw new CryptoException("RSACard verifyByHash failure", e);
        }
        catch (Throwable e) {
            RSACardLoggings.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw new CryptoException("RSACard verifyByHash failure", e);
        }
        return verifyResult;
    }

    public final byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CryptoException {
        RSAPublicKey rsaKey = RSACardKeyHelper.buildPublicKey(publicKey);
        RSACardKey pubKey = rsaKey instanceof RSACardKey ? (RSACardKey)((Object)rsaKey) : RSACardInvalidKey.INSTANCE;
        try {
            byte[] dataInput = RSACardP1Decoder.addPKCS1Padding(sourceData, pubKey.modulusByteLength(), false);
            return this.cardPublicKeyOperationRSA(pubKey, dataInput);
        }
        catch (CryptoException e) {
            RSACardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw e;
        }
        catch (Exception e) {
            RSACardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw new CryptoException("RSACard  [PublicKeyOperation]encrypt failure", e);
        }
        catch (Throwable e) {
            RSACardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw new CryptoException("RSACard  [PublicKeyOperation]encrypt failure", e);
        }
    }

    public final byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CryptoException {
        RSAPrivateKey rsaKey = RSACardKeyHelper.buildPrivateKey(privateKey);
        RSACardKey privKey = rsaKey instanceof RSACardKey ? (RSACardKey)((Object)rsaKey) : RSACardInvalidKey.INSTANCE;
        try {
            byte[] decryptData;
            if (privKey instanceof RSACardInvalidKey) {
                decryptData = SOFTLIB_SESSION.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), privateKey, encryptData);
            } else {
                byte[] dataOutput = this.cardPrivateKeyOperationRSA(privKey, encryptData);
                decryptData = RSACardP1Decoder.delPKCS1Padding(dataOutput, privKey.modulusByteLength(), false);
            }
            return decryptData;
        }
        catch (CryptoException e) {
            RSACardLoggings.warninDecryptFailed(privKey, encryptData, e);
            throw e;
        }
        catch (Exception e) {
            RSACardLoggings.warninDecryptFailed(privKey, encryptData, e);
            throw new CryptoException("RSACard  [PrivateKeyOperation]decrypt failure", e);
        }
        catch (Throwable e) {
            RSACardLoggings.warninDecryptFailed(privKey, encryptData, e);
            throw new CryptoException("RSACard  [PrivateKeyOperation]decrypt failure", e);
        }
    }

    private final boolean checkKeyPair(KeyPair keyPair, int keyUsage) throws CryptoException {
        boolean checkPassed = false;
        if (keyUsage == 2) {
            String sha256Header = "3031300d060960864801650304020105000420";
            String sha256Value = "45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb";
            byte[] hashValue = DataHelper.decodeHexString("45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
            byte[] hashWithAlgorithm = DataHelper.decodeHexString("3031300d06096086480165030402010500042045f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
            byte[] signData = this.signByHash(keyPair.getPrivate(), hashWithAlgorithm);
            try {
                this.verifyByHashWithCard(keyPair, hashWithAlgorithm, signData);
                this.verifyByHashWithSoft(keyPair, hashValue, signData);
                checkPassed = true;
            }
            catch (Exception e) {
                if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                    StringBuilder builder = new StringBuilder(2048);
                    builder.append("\nRSACard generateKeyPair: check keypair failure: ");
                    RSACardLoggings.buildKeyPairCheckFailed(builder, keyPair);
                    builder.append("\nhashValue: ").append(DataHelper.dump4KPartData(hashValue));
                    builder.append("\nhashWithAlgorithm: ").append(DataHelper.dump4KPartData(hashWithAlgorithm));
                    builder.append("\nsignData: ").append(DataHelper.dump4KPartData(signData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                }
                throw new CryptoException("RSACard generateKeyPair: check keypair failure", e);
            }
        }
        if (keyUsage == 1) {
            byte[] sourceData = DataHelper.decodeHexString("45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
            byte[] encryptData = null;
            byte[] decryptData = null;
            String encryptType = null;
            try {
                encryptType = "encryptByHard";
                encryptData = this.encrypt(keyPair.getPublic(), sourceData);
                decryptData = this.decrypt(keyPair.getPrivate(), encryptData);
                checkPassed = Arrays.equals(sourceData, decryptData);
                if (!checkPassed) {
                    throw new CryptoException("RSACard generateKeyPair: check keypair failure[encryptByHard]");
                }
                encryptType = "encryptBySoft";
                encryptData = SOFTLIB_SESSION.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), keyPair.getPublic(), sourceData);
                decryptData = this.decrypt(keyPair.getPrivate(), encryptData);
                checkPassed = Arrays.equals(sourceData, decryptData);
                if (!checkPassed) {
                    throw new CryptoException("RSACard generateKeyPair: check keypair failure[encryptBySoft]");
                }
            }
            catch (PKIException e) {
                String warning = "RSACard generateKeyPair: check keypair failure[" + encryptType + "]";
                if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                    StringBuilder builder = new StringBuilder(2048);
                    builder.append("\n").append(warning);
                    RSACardLoggings.buildKeyPairCheckFailed(builder, keyPair);
                    builder.append("\nsourceData: ").append(DataHelper.dump4KPartData(sourceData));
                    builder.append("\nencryptData: ").append(DataHelper.dump4KPartData(encryptData));
                    LoggerManager.exceptionLogger.error(builder.toString(), e);
                }
                throw new CryptoException(warning, e);
            }
        }
        return checkPassed;
    }

    private final boolean verifyByHashWithCard(KeyPair keyPair, byte[] hashWithAlgorithm, byte[] signData) throws CryptoException {
        boolean verifyResult = this.verifyByHash(keyPair.getPublic(), hashWithAlgorithm, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithCard return False");
        }
        return verifyResult;
    }

    private final boolean verifyByHashWithSoft(KeyPair keyPair, byte[] hashValue, byte[] signData) throws CryptoException, PKIException {
        boolean verifyResult = SOFTLIB_SESSION.verifyByHash(new Mechanism("sha256WithRSAEncryption"), keyPair.getPublic(), hashValue, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithSoft return False");
        }
        return verifyResult;
    }

    private final KeyPair generateExternalKeyPair(int modulusBitsLength) throws CryptoException {
        if (modulusBitsLength != 1024 && modulusBitsLength != 2048 && modulusBitsLength != 4096) {
            throw new CryptoException("RSACard cryptoAPI.generateKeyPairRSA rejected with invalid bitLength=" + modulusBitsLength);
        }
        byte[] pubKeyData = new byte[1028];
        byte[] priKeyData = new byte[2820];
        try {
            int returnValue = this.cryptoAPI.generateKeyPairRSA(modulusBitsLength, pubKeyData, priKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.generateKeyPairRSA returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACard cryptoAPI.generateKeyPairRSA failure", e);
            throw new CryptoException("RSACard cryptoAPI.generateKeyPairRSA failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSACard cryptoAPI.generateKeyPairRSA failure", e);
            throw new CryptoException("RSACard cryptoAPI.generateKeyPairRSA failure", e);
        }
        RSACardPublicKey publicKey = RSACardPublicKey.buildExternalSoftKey(pubKeyData);
        RSACardExternalPrivateKey privateKey = new RSACardExternalPrivateKey(priKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private final KeyPair generateInternalKeyPair(int keyIndex, int keyUsage) throws CryptoException {
        this.ensureKeyIndexValid(keyIndex);
        if (keyUsage != 2) {
            throw new CryptoException("RSACard generateInternalKeyPair rejected with keyUsage=" + keyUsage);
        }
        byte[] pubKeyData = new byte[1028];
        try {
            int returnValue = this.cryptoAPI.exportPublicKeyRSA(keyIndex, keyUsage, pubKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.exportPublicKeyRSA returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACard cryptoAPI.generateKeyPairRSAEx failure", e);
            throw new CryptoException("RSACard cryptoAPI.exportPublicKeyRSA failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSACard cryptoAPI.generateKeyPairRSAEx failure", e);
            throw new CryptoException("RSACard cryptoAPI.exportPublicKeyRSA failure", e);
        }
        RSACardPublicKey publicKey = RSACardPublicKey.buildInternalHardKey(keyIndex, keyUsage, pubKeyData);
        RSACardInternalPrivateKey privateKey = new RSACardInternalPrivateKey(keyIndex, keyUsage, pubKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private final byte[] cardPrivateKeyOperationRSA(RSACardKey rsaKey, byte[] dataInput) throws CryptoException {
        if (rsaKey == null) {
            throw new CryptoParameterException("RSACard cardPrivateKeyOperationRSA rejected: rsaKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("RSACard cardPrivateKeyOperationRSA rejected: encryptData = null ");
        }
        int moduleLength = rsaKey.modulusByteLength();
        if (dataInput.length != moduleLength) {
            throw new CryptoParameterException("RSACard cardPrivateKeyOperationRSA rejected:  dataInputLength= " + dataInput.length + ",moduleLength=" + moduleLength);
        }
        int[] dataOutputSize = new int[]{0};
        byte[] dataOutput = new byte[dataInput.length];
        try {
            if (rsaKey.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(rsaKey.getKeyIndex());
                int returnValue = this.cryptoAPI.internalPrivateKeyOperationRSA(keyIndex, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalPrivateKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            } else {
                byte[] priKeyData = rsaKey.keyData();
                int returnValue = this.cryptoAPI.externalPrivateKeyOperationRSA(priKeyData, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalPrivateKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = RSACardLoggings.buildPrivateKeyOperationRSAFailedMessage(rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("RSACard cardPrivateKeyOperationRSA failure", e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = RSACardLoggings.buildPrivateKeyOperationRSAFailedMessage(rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("RSACard cardPrivateKeyOperationRSA failure", e);
            throw new CryptoException(message, e);
        }
        if (dataOutputSize[0] != dataOutput.length) {
            throw new CryptoException("RSACard cardPrivateKeyOperationRSA failure with dataOutputSize!=modulusBitsLength");
        }
        return dataOutput;
    }

    private final byte[] cardPublicKeyOperationRSA(RSACardKey rsaKey, byte[] dataInput) throws CryptoException {
        if (rsaKey == null) {
            throw new CryptoParameterException("RSACard cardPublicKeyOperationRSA rejected: rsaKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("RSACard cardPublicKeyOperationRSA rejected: encryptData = null");
        }
        int moduleLength = rsaKey.modulusByteLength();
        if (dataInput.length != moduleLength) {
            throw new CryptoParameterException("RSACard cardPublicKeyOperationRSA rejected:  dataInputLength= " + dataInput.length + ",moduleLength=" + moduleLength);
        }
        byte[] dataOutput = new byte[dataInput.length];
        int[] dataOutputSize = new int[]{0};
        try {
            if (rsaKey.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(rsaKey.getKeyIndex());
                int returnValue = this.cryptoAPI.internalPublicKeyOperationRSA(keyIndex, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalPublicKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            } else {
                byte[] pubKeyData = rsaKey.keyData();
                int returnValue = this.cryptoAPI.externalPublicKeyOperationRSA(pubKeyData, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalPublicKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = RSACardLoggings.buildPublicKeyOperationRSAFailedMessage(rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("RSACard cardPublicKeyOperationRSA failure", e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = RSACardLoggings.buildPublicKeyOperationRSAFailedMessage(rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("RSACard cardPublicKeyOperationRSA failure", e);
            throw new CryptoException(message, e);
        }
        if (dataOutputSize[0] != dataOutput.length) {
            throw new CryptoException("RSACard cardPublicKeyOperationRSA failure with dataOutputSize!=modulusBitsLength");
        }
        return dataOutput;
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public boolean idleTest() throws CryptoException {
        try {
            return this.cryptoAPI.idleTest();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACard idleTest failure", e);
            throw new CryptoException("RSACard idleTest failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSACard idleTest failure", e);
            throw new CryptoException("RSACard idleTest failure", e);
        }
    }

    public byte[] hashDigestInfo(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        return RSACardHashHelper.hashDigestInfo(mechanism, sourceData);
    }

    public byte[] hashDigestInfo(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        return RSACardHashHelper.hashDigestInfo(mechanism, sourceStream);
    }

    public byte[] buildDigestInfo(Mechanism mechanism, byte[] hashValue) throws CryptoException {
        return RSACardHashHelper.buildDigestInfo(mechanism, hashValue);
    }
}

