/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardCurveHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.util.Args;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTBigIntegerUtil;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;

public final class ECCCardPublicKey
extends BCECPublicKey
implements ECCCardKey {
    private static final long serialVersionUID = 6831417098775453771L;
    private final int curveId;
    private final int bitLength;
    private final int keyIndex;
    private final int keyUsage;
    private byte[] bPubX;
    private byte[] bPubY;
    private byte[] bPubH;
    private String pubKeyInfo;

    public ECCCardPublicKey(BCECPublicKey key, int curveId) {
        super("EC", Args.notNull(key, "ECPublicKey"));
        this.curveId = curveId;
        this.bitLength = ECCCardCurveHelper.bitLength(this.getParameters());
        this.keyIndex = 0;
        this.keyUsage = 0;
        ECPoint normalizeQ = this.getQ().normalize();
        this.bPubX = this.buildPubX(normalizeQ, curveId);
        this.bPubY = this.buildPubY(normalizeQ, curveId);
        this.bPubH = NumberHelper.md5(this.bPubX, this.bPubY);
    }

    public ECCCardPublicKey(BCECPublicKey key) throws CryptoException {
        super("EC", Args.notNull(key, "ECPublicKey"));
        this.curveId = ECCCardCurveHelper.getCurveId(this.getParameters());
        this.bitLength = ECCCardCurveHelper.bitLength(this.getParameters());
        this.keyIndex = 0;
        this.keyUsage = 0;
        ECPoint normalizeQ = this.getQ().normalize();
        this.bPubX = this.buildPubX(normalizeQ, this.curveId);
        this.bPubY = this.buildPubY(normalizeQ, this.curveId);
        this.bPubH = NumberHelper.md5(this.bPubX, this.bPubY);
    }

    public ECCCardPublicKey(ECPublicKeyParameters ecPubKeyParams, int curveId) {
        super("EC", ecPubKeyParams, ECCCardCurveHelper.buildECParameterSpec(ecPubKeyParams));
        this.curveId = curveId;
        this.bitLength = ECCCardCurveHelper.bitLength(this.getParameters());
        this.keyIndex = 0;
        this.keyUsage = 0;
        ECPoint normalizeQ = this.getQ().normalize();
        this.bPubX = this.buildPubX(normalizeQ, curveId);
        this.bPubY = this.buildPubY(normalizeQ, curveId);
        this.bPubH = NumberHelper.md5(this.bPubX, this.bPubY);
    }

    private final byte[] buildPubX(ECPoint Q, int bitLength) {
        int byteLength = this.modulusByteLength();
        return GMTBigIntegerUtil.asUnsignedNByteArray(Q.getAffineXCoord().toBigInteger(), byteLength);
    }

    private final byte[] buildPubY(ECPoint Q, int bitLength) {
        int byteLength = this.modulusByteLength();
        return GMTBigIntegerUtil.asUnsignedNByteArray(Q.getAffineYCoord().toBigInteger(), byteLength);
    }

    public final String getAlgorithm() {
        return "ECC";
    }

    public final String getFormat() {
        return "X.509";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCCardPublicKey [bitLength=").append(this.bitLength);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",curveId=").append(this.curveId);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",pubH=").append(DataHelper.toHexString(this.getPubH()));
        builder.append("]");
        return builder.toString();
    }

    public final String dumpPublicKey() {
        if (this.pubKeyInfo == null) {
            this.pubKeyInfo = ECCCardKeyHelper.dumpPublicKey(this.bPubX, this.bPubY, this.bPubH);
        }
        return this.pubKeyInfo;
    }

    public final byte[] getEncoded() {
        return super.getEncoded();
    }

    public final boolean isInternalKey() {
        return this.keyIndex > 0;
    }

    public final int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return (this.bitLength + 7) / 8;
    }

    public byte[] getPubX() {
        return this.bPubX == null ? null : (byte[])this.bPubX.clone();
    }

    public byte[] getPubY() {
        return this.bPubY == null ? null : (byte[])this.bPubY.clone();
    }

    public byte[] getPubH() {
        return this.bPubH == null ? null : (byte[])this.bPubH.clone();
    }

    public byte[] keyData() throws CryptoException {
        throw new CryptoException("do not support");
    }
}

