/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;

final class ECCCardHashHelper {
    private ECCCardHashHelper() {
    }

    static final byte[] hash(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hash missing mechanism");
        }
        if (sourceData == null) {
            throw new CryptoException("hash missing sourceData");
        }
        try {
            return HashUtil.RSAHashMessageByJNI(sourceData, mechanism, false);
        }
        catch (Exception e) {
            throw new CryptoException("hash failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hash failure", e);
        }
    }

    static final byte[] hash(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hash missing mechanism");
        }
        if (sourceStream == null) {
            throw new CryptoException("hash missing sourceStream");
        }
        try {
            return HashUtil.RSAHashFileByJNI(sourceStream, mechanism, false);
        }
        catch (Exception e) {
            throw new CryptoException("hash failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hash failure", e);
        }
    }
}

