/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoInfo;
import cfca.sadk.extend.session.link.ICryptoLink;
import cfca.sadk.extend.session.link.jni.CryptoLinkImp;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNIInit;
import cryptokit.jni.JNISDF;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CryptoLinkManager {
    private final long warningTimeThreshold;
    private final long sessionHandleTimeout;
    private final ICryptoLink cryptoAPI;
    private final LinkedBlockingQueue<Long> sessionHandles;
    private final byte[] deviceInfo;
    private static volatile CryptoLinkManager SINGLETON = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoLinkManager getSingleton(CryptoInfo cryptoInfo) throws CryptoException {
        if (SINGLETON != null) return SINGLETON;
        Class<CryptoLinkManager> clazz = CryptoLinkManager.class;
        synchronized (CryptoLinkManager.class) {
            if (SINGLETON != null) return SINGLETON;
            CryptoLinkManager manager = new CryptoLinkManager(cryptoInfo);
            LoggerManager.systemLogger.info("CryptoManager build instance {}", (Object)manager);
            SINGLETON = manager;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SINGLETON;
        }
    }

    public CryptoLinkManager(CryptoInfo cryptoInfo) throws CryptoException {
        long strTime = System.currentTimeMillis();
        if (cryptoInfo == null) {
            throw new CryptoException("CryptoLinkManager construct failed: cryptoInfo is NULL");
        }
        String sdfLibPath = cryptoInfo.getSdfLibPath();
        long warningTimeThreshold = cryptoInfo.getWarningTimeThreshold();
        int sessionNumber = cryptoInfo.getSessionNumber();
        long sessionHandleTimeout = cryptoInfo.getSessionTimeout();
        boolean supportIdleTest = cryptoInfo.isSupportIdleTest();
        LoggerManager.systemLogger.info("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={},supportIdleTest={})", sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout, supportIdleTest);
        try {
            JNIInit.initOpenSSL();
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoSessionManager construct initOpenSSL failed", e);
            throw new CryptoException("CryptoSessionManager construct initOpenSSL failed", e);
        }
        try {
            CryptoLinkImp cryptoAPI = new CryptoLinkImp(new JNISDF(), warningTimeThreshold, supportIdleTest);
            this.warningTimeThreshold = warningTimeThreshold;
            this.sessionHandleTimeout = sessionHandleTimeout < 0L ? 5000L : sessionHandleTimeout;
            cryptoAPI.loadSDFLib(sdfLibPath);
            long deviceHandle = cryptoAPI.openDevice();
            long sessionHandle = cryptoAPI.openSession(deviceHandle);
            byte[] deviceInfo = new byte[21];
            int returnResult = cryptoAPI.getDeviceInfo(sessionHandle, deviceInfo);
            this.cryptoAPI = cryptoAPI;
            this.deviceInfo = deviceInfo;
            if (returnResult != 0) {
                LoggerManager.exceptionLogger.error("CryptoSessionManager getDeviceInfo failed: returnResult={}", (Object)NumberHelper.hex(returnResult));
                throw new CryptoException("CryptoSessionManager getDeviceInfo failed: returnResult=" + NumberHelper.hex(returnResult));
            }
            LinkedBlockingQueue<Long> sessionHandles = this.openCryptoSession(cryptoAPI, deviceHandle, sessionNumber);
            this.sessionHandles = sessionHandles;
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("CryptoSessionManager construct failed", e);
            throw e;
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={},deviceInfo={})", sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout, this.getDeviceInfo());
        } else {
            LoggerManager.systemLogger.info("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={},deviceInfo={})", sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout, this.getDeviceInfo());
        }
    }

    private final LinkedBlockingQueue<Long> openCryptoSession(ICryptoLink cryptoAPI, long deviceHandle, int sessionNumber) throws CryptoException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("OpenCryptoSession...");
        LinkedBlockingQueue<Long> sessionHandles = new LinkedBlockingQueue<Long>();
        try {
            int i = 0;
            while (i < sessionNumber) {
                long session = cryptoAPI.openSession(deviceHandle);
                LoggerManager.systemLogger.info("OpenCryptoSession sessionHandle#{}={}", (Object)(++i), (Object)session);
                sessionHandles.add(session);
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("OpenCryptoSession failed", e);
            throw new CryptoException("OpenCryptoSession failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("OpenCryptoSession failed", e);
            throw new CryptoException("OpenCryptoSession failed", e);
        }
        LoggerManager.systemLogger.info("OpenCryptoSession Successfully!");
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("OpenCryptoSession costTime={}, deviceInfo={}", (Object)costTime, (Object)this.getDeviceInfo());
        } else {
            LoggerManager.systemLogger.info("OpenCryptoSession costTime={}, deviceInfo={}", (Object)costTime, (Object)this.getDeviceInfo());
        }
        return sessionHandles;
    }

    protected final Long pollSessionHandle() throws CryptoException {
        Long sessionHandle;
        long strTime = System.currentTimeMillis();
        try {
            sessionHandle = this.sessionHandles.poll(this.sessionHandleTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LoggerManager.exceptionLogger.error("pollSessionHandle throw InterruptedException", e);
            throw new CryptoException("pollSessionHandle throw InterruptedException", e);
        }
        if (sessionHandle == null) {
            LoggerManager.exceptionLogger.error("pollSessionHandle timeout in {} milliseconds", (Object)this.sessionHandleTimeout);
            throw new CryptoException("pollSessionHandle timeout in " + this.sessionHandleTimeout + " milliseconds");
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("pollSessionHandle sessionHandle={},costTime={}, pollTimeout={}", NumberHelper.hex(sessionHandle), costTime, this.sessionHandleTimeout);
        } else {
            LoggerManager.systemLogger.info("pollSessionHandle sessionHandle={},costTime={}, pollTimeout={}", NumberHelper.hex(sessionHandle), costTime, this.sessionHandleTimeout);
        }
        return sessionHandle;
    }

    protected final void releaseSessionHandle(Long sessionHandle) throws CryptoException {
        if (sessionHandle != null) {
            LoggerManager.systemLogger.info("releaseSessionHandle sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
            this.sessionHandles.add(sessionHandle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean idleTest() throws CryptoException {
        boolean idleTestResult;
        block7: {
            LoggerManager.systemLogger.info("idleTest running: ");
            idleTestResult = false;
            Long sessionHandle = null;
            try {
                try {
                    sessionHandle = this.pollSessionHandle();
                    LoggerManager.systemLogger.info("idleTest sessionHandle: {}", (Object)NumberHelper.hex(sessionHandle));
                    int returnValue = this.cryptoAPI.idleTest(sessionHandle);
                    LoggerManager.systemLogger.info("idleTest sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
                    boolean bl = idleTestResult = returnValue == 0;
                    if (!idleTestResult) {
                        LoggerManager.exceptionLogger.error("idleTest sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
                        throw new CryptoException("idleTest failed: returnValue=" + NumberHelper.hex(returnValue));
                    }
                    Object var5_6 = null;
                    if (sessionHandle == null) break block7;
                }
                catch (CryptoException e) {
                    LoggerManager.exceptionLogger.error("idleTest failed");
                    throw e;
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.error("idleTest failed");
                    throw new CryptoException("idleTest failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (sessionHandle != null) {
                    this.sessionHandles.add(sessionHandle);
                }
                throw throwable;
            }
            this.sessionHandles.add(sessionHandle);
        }
        LoggerManager.systemLogger.info("idleTest passed");
        return idleTestResult;
    }

    String getDeviceInfo() {
        return this.deviceInfo == null ? "NONE" : Strings.fromByteArray(this.deviceInfo);
    }

    ICryptoLink getCryptoAPI() {
        return this.cryptoAPI;
    }
}

