/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoInfo;
import cfca.sadk.extend.session.bridge.ICryptoBridge;
import cfca.sadk.extend.session.bridge.impl.CryptoLinkManager;
import cfca.sadk.extend.session.link.ICryptoLink;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.system.logging.LoggerManager;

public final class CryptoBridgeImpl
implements ICryptoBridge {
    private final CryptoLinkManager cryptoManager;
    private final ICryptoLink cryptoLink;
    private final long warningTimeThreshold;

    public CryptoBridgeImpl(CryptoInfo cryptoInfo) throws CryptoException {
        if (cryptoInfo == null) {
            throw new CryptoException("CryptoEngine construct failed: cryptoInfo is NULL");
        }
        this.cryptoManager = CryptoLinkManager.getSingleton(cryptoInfo);
        this.cryptoLink = this.cryptoManager.getCryptoAPI();
        this.warningTimeThreshold = cryptoInfo.getSessionTimeout();
    }

    public String getDeviceInfo() throws CryptoException {
        return this.cryptoManager.getDeviceInfo();
    }

    public boolean idleTest() throws CryptoException {
        return this.cryptoManager.idleTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportProtectECCKey(byte[] publicKeyDataOutput) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine exportProtectECCKey Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.exportProtectECCKey(sessionHandle, publicKeyDataOutput);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine exportProtectECCKey finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine exportProtectECCKey finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importEncryptedECCKeyPairs(int keyIndex, byte[] encryptedKeyCipherData) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine importEncryptedECCKeyPairs Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.importEncryptedECCKeyPairs(sessionHandle, keyIndex, encryptedKeyCipherData);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine importEncryptedECCKeyPairs finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine importEncryptedECCKeyPairs finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateKeyPairRSA(int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine generateKeyPairRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.generateKeyPairRSA(sessionHandle, keyBits, publicKeyData, privateKeyData);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine generateKeyPairRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine generateKeyPairRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportPublicKeyRSA(int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine exportPublicKeyRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.exportPublicKeyRSA(sessionHandle, keyIndex, algType, publicKeyData);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine exportPublicKeyRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine exportPublicKeyRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateKeyPairECC(int algID, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine generateKeyPairECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.generateKeyPairECC(sessionHandle, algID, keyBits, publicKeyData, privateKeyData);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine generateKeyPairECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine generateKeyPairECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportPublicKeyECC(int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine exportPublicKeyECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.exportPublicKeyECC(sessionHandle, keyIndex, algType, publicKeyData);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine exportPublicKeyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine exportPublicKeyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalPublicKeyOperationRSA(byte[] publicKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalPublicKeyOperationRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalPublicKeyOperationRSA(sessionHandle, publicKeyData, dataInput, dataOutput, dataOutputSize);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalPublicKeyOperationRSA(int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalPublicKeyOperationRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalPublicKeyOperationRSA(sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalPrivateKeyOperationRSA(int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalPrivateKeyOperationRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalPrivateKeyOperationRSA(sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalPrivateKeyOperationRSA(byte[] privateKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalPrivateKeyOperationRSA Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalPrivateKeyOperationRSA(sessionHandle, privateKeyData, dataInput, dataOutput, dataOutputSize);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalSignECC(int keyIndex, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalSignECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalSignECC(sessionHandle, keyIndex, dataInput, dataLength, dataOutput);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalSignECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalSignECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalSignECC(int algID, byte[] privateKeyData, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalSignECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalSignECC(sessionHandle, algID, privateKeyData, dataInput, dataLength, dataOutput);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalSignECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalSignECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalVerifyECC(int keyIndex, byte[] dataInput, int dataLength, byte[] signature) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalVerifyECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalVerifyECC(sessionHandle, keyIndex, dataInput, dataLength, signature);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalVerifyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalVerifyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalVerifyECC(int algID, byte[] publicKeyData, byte[] dataInput, int dataLength, byte[] signature) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalVerifyECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalVerifyECC(sessionHandle, algID, publicKeyData, dataInput, dataLength, signature);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalVerifyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalVerifyECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalEncryptECC(int keyIndex, int algID, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalEncryptECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalEncryptECC(sessionHandle, keyIndex, algID, dataInput, dataLength, dataOutput);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalEncryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalEncryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalEncryptECC(int algID, byte[] publicKeyData, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalEncryptECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalEncryptECC(sessionHandle, algID, publicKeyData, dataInput, dataLength, dataOutput);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalEncryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalEncryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalDecryptECC(int keyIndex, int algID, byte[] encData, byte[] data, int[] dataLength) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine internalDecryptECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.internalDecryptECC(sessionHandle, keyIndex, algID, encData, data, dataLength);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine internalDecryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine internalDecryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int externalDecryptECC(int algID, byte[] privateKeyData, byte[] encData, byte[] data, int[] dataLength) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoEngine externalDecryptECC Running...");
        Long sessionHandle = this.cryptoManager.pollSessionHandle();
        try {
            returnResult = this.cryptoLink.externalDecryptECC(sessionHandle, algID, privateKeyData, encData, data, dataLength);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cryptoManager.releaseSessionHandle(sessionHandle);
            throw throwable;
        }
        this.cryptoManager.releaseSessionHandle(sessionHandle);
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoEngine externalDecryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoEngine externalDecryptECC finished, sessionHandle={},returnResult={},costTime={}", NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime);
        }
        return returnResult;
    }
}

