/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.anssi.ANSSIObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ECCCurveId {
    NIST_P192(1, "P-192", SECObjectIdentifiers.secp192r1),
    NIST_K163(2, "K-163", SECObjectIdentifiers.sect163k1),
    NIST_B163(3, "B-163", SECObjectIdentifiers.sect163r2),
    NIST_P224(4, "P-224", SECObjectIdentifiers.secp224r1),
    NIST_K233(5, "K-233", SECObjectIdentifiers.sect233k1),
    NIST_B233(6, "B-233", SECObjectIdentifiers.sect233r1),
    NIST_P256(7, "P-256", SECObjectIdentifiers.secp256r1),
    NIST_K283(8, "K-283", SECObjectIdentifiers.sect283k1),
    NIST_B283(9, "B-283", SECObjectIdentifiers.sect283r1),
    NIST_P384(10, "P-384", SECObjectIdentifiers.secp384r1),
    NIST_K409(11, "K-409", SECObjectIdentifiers.sect409k1),
    NIST_B409(12, "B-409", SECObjectIdentifiers.sect409r1),
    NIST_P521(13, "P-521", SECObjectIdentifiers.secp521r1),
    NIST_K571(14, "K-571", SECObjectIdentifiers.sect571k1),
    NIST_B571(15, "B-571", SECObjectIdentifiers.sect571r1),
    SECP112R1(16, "secp112r1", SECObjectIdentifiers.secp112r1),
    SECP112R2(17, "secp112r2", SECObjectIdentifiers.secp112r2),
    SECP128R1(18, "secp128r1", SECObjectIdentifiers.secp128r1),
    SECP128R2(19, "secp128r2", SECObjectIdentifiers.secp128r2),
    SECP160K1(20, "secp160k1", SECObjectIdentifiers.secp160k1),
    SECP160R1(21, "secp160r1", SECObjectIdentifiers.secp160r1),
    SECP160R2(22, "secp160r2", SECObjectIdentifiers.secp160r2),
    SECP192K1(23, "secp192k1", SECObjectIdentifiers.secp192k1),
    SECP224K1(24, "secp224k1", SECObjectIdentifiers.secp224k1),
    SECP256K1(25, "secp256k1", SECObjectIdentifiers.secp256k1),
    SECT113R1(26, "sect113r1", SECObjectIdentifiers.sect113r1),
    SECT113R2(27, "sect113r2", SECObjectIdentifiers.sect113r2),
    SECT131R1(28, "sect131r1", SECObjectIdentifiers.sect131r1),
    SECT131R2(29, "sect131r2", SECObjectIdentifiers.sect131r2),
    SECT163R1(30, "sect163r1", SECObjectIdentifiers.sect163r1),
    SECT193R1(31, "sect193r1", SECObjectIdentifiers.sect193r1),
    SECT193R2(32, "sect193r2", SECObjectIdentifiers.sect193r2),
    SECT239K1(33, "sect239k1", SECObjectIdentifiers.sect239k1),
    ANSIX9P192V2(34, "prime192v2", X9ObjectIdentifiers.prime192v2),
    ANSIX9P192V3(35, "prime192v3", X9ObjectIdentifiers.prime192v3),
    ANSIX9P239V1(36, "prime239v1", X9ObjectIdentifiers.prime239v1),
    ANSIX9P239V2(37, "prime239v2", X9ObjectIdentifiers.prime239v2),
    ANSIX9P239V3(38, "prime239v3", X9ObjectIdentifiers.prime239v3),
    ANSIX9C2PNB163V1(39, "c2pnb163v1", X9ObjectIdentifiers.c2pnb163v1),
    ANSIX9C2PNB163V2(40, "c2pnb163v2", X9ObjectIdentifiers.c2pnb163v2),
    ANSIX9C2PNB163V3(41, "c2pnb163v3", X9ObjectIdentifiers.c2pnb163v3),
    ANSIX9C2PNB176V1(42, "c2pnb176w1", X9ObjectIdentifiers.c2pnb176w1),
    ANSIX9C2TNB191V1(43, "c2tnb191v1", X9ObjectIdentifiers.c2tnb191v1),
    ANSIX9C2TNB191V2(44, "c2tnb191v2", X9ObjectIdentifiers.c2tnb191v2),
    ANSIX9C2TNB191V3(45, "c2tnb191v3", X9ObjectIdentifiers.c2tnb191v3),
    ANSIX9C2PNB208W1(46, "c2pnb208w1", X9ObjectIdentifiers.c2pnb208w1),
    ANSIX9C2TNB239V1(47, "c2tnb239v1", X9ObjectIdentifiers.c2tnb239v1),
    ANSIX9C2TNB239V2(48, "c2tnb239v2", X9ObjectIdentifiers.c2tnb239v2),
    ANSIX9C2TNB239V3(49, "c2tnb239v3", X9ObjectIdentifiers.c2tnb239v3),
    ANSIX9C2PNB272W1(50, "c2pnb272w1", X9ObjectIdentifiers.c2pnb272w1),
    ANSIX9C2PNB304W1(51, "c2pnb304w1", X9ObjectIdentifiers.c2pnb304w1),
    ANSIX9C2TNB359V1(52, "c2tnb359v1", X9ObjectIdentifiers.c2tnb359v1),
    ANSIX9C2PNB368W1(53, "c2pnb368w1", X9ObjectIdentifiers.c2pnb368w1),
    ANSIX9C2TNB431R1(54, "c2tnb431r1", X9ObjectIdentifiers.c2tnb431r1),
    BRAINPOOLP160R1(55, "brainpoolp160r1", TeleTrusTObjectIdentifiers.brainpoolP160r1),
    BRAINPOOLP160T1(56, "brainpoolp160t1", TeleTrusTObjectIdentifiers.brainpoolP160t1),
    BRAINPOOLP192R1(57, "brainpoolp192r1", TeleTrusTObjectIdentifiers.brainpoolP192r1),
    BRAINPOOLP192T1(58, "brainpoolp192t1", TeleTrusTObjectIdentifiers.brainpoolP192t1),
    BRAINPOOLP224R1(59, "brainpoolp224r1", TeleTrusTObjectIdentifiers.brainpoolP224r1),
    BRAINPOOLP224T1(60, "brainpoolp224t1", TeleTrusTObjectIdentifiers.brainpoolP224t1),
    BRAINPOOLP256R1(61, "brainpoolp256r1", TeleTrusTObjectIdentifiers.brainpoolP256r1),
    BRAINPOOLP256T1(62, "brainpoolp256t1", TeleTrusTObjectIdentifiers.brainpoolP256t1),
    BRAINPOOLP320R1(63, "brainpoolp320r1", TeleTrusTObjectIdentifiers.brainpoolP320r1),
    BRAINPOOLP320T1(64, "brainpoolp320t1", TeleTrusTObjectIdentifiers.brainpoolP320t1),
    BRAINPOOLP384R1(65, "brainpoolp384r1", TeleTrusTObjectIdentifiers.brainpoolP384r1),
    BRAINPOOLP384T1(66, "brainpoolp384t1", TeleTrusTObjectIdentifiers.brainpoolP384t1),
    BRAINPOOLP512R1(67, "brainpoolp512r1", TeleTrusTObjectIdentifiers.brainpoolP512r1),
    BRAINPOOLP512T1(68, "brainpoolp512t1", TeleTrusTObjectIdentifiers.brainpoolP512t1),
    FRP256V1(-2147479551, "frp256v1", ANSSIObjectIdentifiers.frp256v1);

    private final int curveId;
    private final String curveName;
    private final ASN1ObjectIdentifier curveOID;
    private static final ECCCurveId[] VALUES;
    private static final Map<String, ECCCurveId> ECC_CURVE_IDS;

    private static final Map<String, ECCCurveId> cacheECCCurveIds(ECCCurveId[] curveIds) {
        ConcurrentHashMap<String, ECCCurveId> mapping = new ConcurrentHashMap<String, ECCCurveId>(256);
        if (curveIds != null) {
            for (ECCCurveId value : curveIds) {
                mapping.put(value.getCurveName(), value);
                mapping.put(value.getCurveOID(), value);
                mapping.put(Integer.toString(value.getCurveId()), value);
            }
        }
        mapping.put("prime192v1", NIST_P192);
        mapping.put("prime256v1", NIST_P256);
        return mapping;
    }

    private ECCCurveId(int curveId, String curveName, ASN1ObjectIdentifier curveOID) {
        this.curveId = curveId;
        this.curveName = curveName;
        this.curveOID = curveOID;
    }

    public int getCurveId() {
        return this.curveId;
    }

    public String getCurveName() {
        return this.curveName;
    }

    public String getCurveOID() {
        return this.curveOID.getId();
    }

    public String toString() {
        return String.format("%08X %-15s %s", this.curveId, this.curveName, this.curveOID);
    }

    public static final ECCCurveId findECCCurveId(int curveId) {
        ECCCurveId curve = null;
        if (0 < curveId && curveId <= ECCCurveId.BRAINPOOLP512T1.curveId) {
            curve = VALUES[curveId - 1];
        } else if (curveId == ECCCurveId.FRP256V1.curveId) {
            curve = FRP256V1;
        }
        return curve;
    }

    public static final ECCCurveId findECCCurveId(String curveName) {
        ECCCurveId curve = null;
        if (curveName != null) {
            curve = ECC_CURVE_IDS.get(curveName);
        }
        return curve;
    }

    static {
        VALUES = ECCCurveId.values();
        ECC_CURVE_IDS = ECCCurveId.cacheECCCurveIds(VALUES);
    }
}

