/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoInfo;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.PropertiesReader;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.util.Properties;

public final class CryptoInfoFactory {
    private static final int DEFAULT_CARD_ENABLE_TYPE = 7;
    private static final String DEFAULT_SDFLIBPATH = "/lib64/libsdfcommon.so";
    private static final int DEFAULT_WARNING_TIME_THRESHOLD = 500;
    private static final int DEFAULT_WARNING_LONGTIME_THRESHOLD = 5000;
    private static final int DEFAULT_SESSION_NUMBER = 60;
    private static final int DEFAULT_SESSION_TIMEOUT = 500;

    private CryptoInfoFactory() {
    }

    public static CryptoInfo buildDefaultCryptoInfo() {
        int cardEnableType = 7;
        String sdfLibPath = DEFAULT_SDFLIBPATH;
        int warningTimeThreshold = 500;
        int warningLongTimeThreshold = 5000;
        int sessionNumber = 60;
        int sessionTimeout = 500;
        boolean supportIdleTest = true;
        return new CryptoInfo(7, DEFAULT_SDFLIBPATH, 500, 5000, 60, 500, true);
    }

    public static CryptoInfo buildWithConfigFile(String configFilePath) throws CryptoException {
        try {
            File configFile = FileHelper.checkFileExist(configFilePath);
            Properties properties = PropertiesReader.loadPropertiesFile(configFile);
            int cardEnableType = CryptoInfoFactory.getInt(properties, "ExtendLib.cardEnableType", 7);
            String sdfLibPath = CryptoInfoFactory.getString(properties, "ExtendLib.sdfLibPath", DEFAULT_SDFLIBPATH);
            int warningTimeThreshold = CryptoInfoFactory.getInt(properties, "ExtendLib.warningTimeThreshold", 500);
            int warningLongTimeThreshold = CryptoInfoFactory.getInt(properties, "ExtendLib.warningLongTimeThreshold", 5000);
            int sessionNumber = CryptoInfoFactory.getInt(properties, "ExtendLib.sessionNumber", 60);
            int sessionTimeout = CryptoInfoFactory.getInt(properties, "ExtendLib.sessionTimeout", 500);
            boolean supportIdleTest = "true".equalsIgnoreCase(CryptoInfoFactory.getString(properties, "ExtendLib.supportIdleTest", "true"));
            return new CryptoInfo(cardEnableType, sdfLibPath, warningTimeThreshold, warningLongTimeThreshold, sessionNumber, sessionTimeout, supportIdleTest);
        }
        catch (Exception e) {
            throw new CryptoException("buildWithConfigFile fialure: " + configFilePath, e);
        }
    }

    private static int getInt(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        int val = defaultValue;
        if (!CryptoInfoFactory.isBlank(value)) {
            try {
                val = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LoggerManager.exceptionLogger.warn("CryptoInfoConfig properties convert to int failed: {}={}", key, value, e);
            }
        }
        return val;
    }

    private static String getString(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (CryptoInfoFactory.isBlank(value)) {
            value = defaultValue;
        }
        return value;
    }

    private static boolean isBlank(CharSequence s) {
        boolean isBlank = true;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                isBlank = false;
                break;
            }
        }
        return isBlank;
    }
}

