/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.parser;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.util.encoders.Base64Kit;
import cfca.sadk.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class ASN1Parser {
    public static byte[] parseDERObj2Bytes(ASN1Encodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.DEROBJ_BYTES, PKIException.DEROBJ_BYTES_DES, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Object parseBytes2DERObj(byte[] data) throws PKIException {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream in = null;
        try {
            try {
                in = new ASN1InputStream(new ByteArrayInputStream(data));
                aSN1Primitive = in.readObject();
                Object var4_4 = null;
                if (in == null) return aSN1Primitive;
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.BYTES_DEROBJ, PKIException.BYTES_DEROBJ_DES, ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PKIException("Parsed DERData failure", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new PKIException("Parsed DERData failure", e);
        }
        in.close();
        return aSN1Primitive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Sequence parseOCT2SEQ(ASN1OctetString asn1oct) throws PKIException {
        ASN1Sequence aSN1Sequence;
        ASN1InputStream in = null;
        try {
            try {
                in = new ASN1InputStream(new ByteArrayInputStream(asn1oct.getOctets()));
                aSN1Sequence = (ASN1Sequence)in.readObject();
                Object var4_4 = null;
                if (in == null) return aSN1Sequence;
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.OCTECT_DER_ERR, PKIException.OCTECT_DER_ERR_DES, ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PKIException("Parsed DERData failure", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new PKIException("Parsed DERData failure", e);
        }
        in.close();
        return aSN1Sequence;
    }

    public static boolean isBase64Compatability(byte[] data) {
        return Base64Kit.isBase64Compatability(data);
    }

    public static byte[] deleteCRLF(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        return bos.toByteArray();
    }

    public static final ASN1Sequence getDERSequenceFrom(byte[] encoding) throws PKIException {
        try {
            byte[] data;
            if (ASN1Parser.isDERSequence(encoding)) {
                return ASN1Sequence.getInstance(encoding);
            }
            if (ASN1Parser.isBERSequence(encoding)) {
                return ASN1Sequence.getInstance(encoding);
            }
            try {
                data = Base64.decode(encoding);
            }
            catch (Exception e) {
                throw new PKIException("encoding required base64 encoding", e);
            }
            return ASN1Sequence.getInstance(data);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("encoding required DERSequence encoding", e);
        }
    }

    public static final boolean isBERSequence(byte[] encoding) throws PKIException {
        int length;
        if (encoding == null) {
            throw new PKIException("encoding should not be null");
        }
        if (encoding.length < 4) {
            throw new PKIException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        if ((length = encoding[offset++] & 0xFF) != 128) {
            return false;
        }
        return encoding[encoding.length - 1] == 0 && encoding[encoding.length - 2] == 0;
    }

    public static final boolean isDERSequence(byte[] encoding) throws PKIException {
        int length;
        if (encoding == null) {
            throw new PKIException("encoding should not be null");
        }
        if (encoding.length < 2) {
            throw new PKIException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        if ((length = encoding[offset++] & 0xFF) == 128) {
            return false;
        }
        if (length > 127) {
            int dLength = length & 0x7F;
            if (dLength > 4) {
                return false;
            }
            length = 0;
            int next = 0;
            for (int i = 0; i < dLength; ++i) {
                next = encoding[offset++] & 0xFF;
                length = (length << 8) + next;
            }
            if (length < 0) {
                return false;
            }
        }
        return encoding.length == offset + length;
    }
}

