/*
 * Decompiled with CFR 0.152.
 */
package api.loader;

import api.VoucherFileInfo;
import api.tools.FileTool;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OFDLoader {
    private ZipFile file = null;
    private String attpath = "";
    private List<String> attachments = null;

    public boolean loadOFD(String filePath) throws IOException, ParserConfigurationException, SAXException {
        this.file = new ZipFile(filePath);
        ZipArchiveEntry entry = this.file.getEntry("OFD.xml");
        if (entry == null) {
            this.file.close();
            return false;
        }
        InputStream is = this.file.getInputStream(entry);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fac.newDocumentBuilder();
        Document d = builder.parse(is);
        NodeList list = d.getElementsByTagName("ofd:DocBody");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.parserDocumentBody(node, this.file, is);
        }
        return true;
    }

    private void parserDocumentBody(Node nd, ZipFile file, InputStream is) throws ZipException, IOException, SAXException, ParserConfigurationException {
        String docpath = null;
        NodeList list = nd.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !"ofd:DocRoot".equalsIgnoreCase(node.getNodeName())) continue;
            docpath = node.getTextContent();
        }
        is.close();
        if (docpath.length() < 1) {
            return;
        }
        if (docpath.startsWith("/") || docpath.startsWith("\\")) {
            docpath = docpath.substring(1);
        }
        ZipArchiveEntry entry = file.getEntry(docpath);
        is = file.getInputStream(entry);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fac.newDocumentBuilder();
        Document d = builder.parse(is);
        this.parserDocument(d.getDocumentElement(), file, is);
    }

    private void parserDocument(Node node, ZipFile file, InputStream is) throws ZipException, IOException, ParserConfigurationException, SAXException {
        if (node.getNodeType() != 1) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node nd = list.item(i);
            if (nd.getNodeType() != 1 || !"ofd:Attachments".equalsIgnoreCase(nd.getNodeName())) continue;
            this.attpath = nd.getTextContent();
            if (this.attpath.startsWith("/") || this.attpath.startsWith("\\")) continue;
            this.attpath = "Doc_0/" + this.attpath;
        }
        is.close();
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        if (this.attpath.length() > 0) {
            ZipArchiveEntry entry = file.getEntry(this.attpath);
            is = file.getInputStream(entry);
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document d = builder.parse(is);
            this.parseAttachment(d.getDocumentElement(), file, is);
            is.close();
        }
    }

    private void parseAttachment(Node node, ZipFile file, InputStream is) {
        if (node.getNodeType() != 1) {
            return;
        }
        NodeList nlist = node.getChildNodes();
        for (int j = 0; j < nlist.getLength(); ++j) {
            Node nd = nlist.item(j);
            if (nd.getNodeType() != 1) continue;
            String path = nd.getTextContent().trim();
            if (!path.startsWith("/") && !path.startsWith("\\")) {
                path = this.attpath.substring(0, this.attpath.lastIndexOf("/") + 1) + path;
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList<String>();
            }
            this.attachments.add(path);
        }
    }

    public VoucherFileInfo extractAttach(String outputFile) throws IOException {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        if (this.attachments == null || this.file == null) {
            return null;
        }
        String outFilePath = outputFile;
        String voucherTypeValue = PropUtil.getPropValue("VoucherType", "VoucherType");
        String[] voucherTypeArray = voucherTypeValue.split(",");
        for (int i = 0; i < this.attachments.size(); ++i) {
            String fullPath = this.attachments.get(i);
            String fileName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
            if (outFilePath == null || "".equals(outFilePath)) {
                outFilePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
            }
            for (int j = 0; j < voucherTypeArray.length; ++j) {
                if (!fileName.startsWith(voucherTypeArray[j])) continue;
                this.extract(fullPath, outFilePath);
                voucherFileInfo.setVoucherType(voucherTypeArray[j]);
                voucherFileInfo.setXbrlFilePath(outFilePath);
                return voucherFileInfo;
            }
            if (this.attachments.size() - 1 != i) continue;
            voucherFileInfo.setXbrlFilePath(outFilePath);
            this.extract(fullPath, outFilePath);
        }
        return voucherFileInfo;
    }

    private void extract(String fullPath, String outFilePath) throws IOException {
        ZipArchiveEntry entry = this.file.getEntry(fullPath);
        InputStream is = this.file.getInputStream(entry);
        FileTool.saveTo(is, outFilePath);
        is.close();
    }
}

