/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.VoucherFileInfo;
import api.loader.OFDLoader;
import api.tools.PDFTool;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VoucherFileUtil {
    private static Log log = LogFactory.getLog(VoucherFileUtil.class);
    private static XbrlToJson XTJ = new XbrlToJson();
    private static JsonToXbrl JTX = new JsonToXbrl();
    private static String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath) throws Exception {
        return VoucherFileUtil.extractXBRLFromOFD(ofdFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFile) throws Exception {
        OFDLoader loader = new OFDLoader();
        loader.loadOFD(ofdFilePath);
        PropUtil.initFileMap("VoucherType");
        log.info("extract OFD file ");
        VoucherFileInfo voucherFileInfo = loader.extractAttach(outputFile);
        log.info("extract success! outputfile: " + voucherFileInfo.getXbrlFilePath());
        return voucherFileInfo;
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath) {
        return VoucherFileUtil.extractXBRLFromPDF(pdfFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFile) {
        return PDFTool.extractXBRLFileFromPDF(pdfFilePath, DEFAULT_ISSUER_XBRL_FILENAME, outputFile);
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return XTJ.convertXbrlJsonData(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return JTX.convertXbrlXml(jsonValue, configId);
    }
}

