/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.lang.reflect.Method;
import org.ujmp.core.Coordinates;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;

public abstract class BLAS {
    private static Method dgemm = null;

    public static synchronized void dgemm(int rows, int retcols, int cols, int i, double[] values, int j, int rows2, double[] m2, int k, int l, int m, double[] ret, int n, int rows3) {
        try {
            dgemm.invoke(null, "N", "N", rows, retcols, cols, i, values, j, rows2, m2, k, l, m, ret, n, rows3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isAvailable() {
        return dgemm != null;
    }

    public static final DenseDoubleMatrix2D mtimes(DefaultDenseDoubleMatrix2D A2, DefaultDenseDoubleMatrix2D B) {
        if (A2.getColumnCount() != B.getRowCount()) {
            throw new RuntimeException("matrices have wrong size: " + Coordinates.toString(A2.getSize()) + " and " + Coordinates.toString(B.getSize()));
        }
        boolean alpha = true;
        boolean beta = true;
        int acols = (int)A2.getColumnCount();
        int arows = (int)A2.getRowCount();
        int bcols = (int)B.getColumnCount();
        int brows = (int)B.getRowCount();
        double[] avalues = A2.getColumnMajorDoubleArray1D();
        double[] bvalues = B.getColumnMajorDoubleArray1D();
        double[] cvalues = new double[arows * bcols];
        BLAS.dgemm(arows, bcols, acols, 1, avalues, 0, arows, bvalues, 0, brows, 1, cvalues, 0, arows);
        DefaultDenseDoubleMatrix2D c = new DefaultDenseDoubleMatrix2D(cvalues, arows, bcols);
        return c;
    }

    static {
        try {
            Class<?> c = Class.forName("org.netlib.blas.Dgemm");
            dgemm = c.getMethod("dgemm", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE, double[].class, Integer.TYPE, Integer.TYPE, double[].class, Integer.TYPE, Integer.TYPE, Double.TYPE, double[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable e) {
            System.out.println("arpack-combo.jar not found, cannot use BLAS");
        }
    }
}

