/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesDenseMatrix2D
implements MtimesCalculation<DenseMatrix2D, DenseMatrix2D, DenseMatrix2D> {
    MtimesDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source1, DenseMatrix2D source2, DenseMatrix2D target) {
        if (source1 instanceof DenseDoubleMatrix2D && source2 instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            Mtimes.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source1, (DenseDoubleMatrix2D)source2, (DenseDoubleMatrix2D)target);
        } else {
            this.gemm(source1, source2, target);
        }
    }

    private final void gemm(final DenseMatrix2D A2, final DenseMatrix2D B, final DenseMatrix2D C) {
        VerifyUtil.verify2D(A2);
        VerifyUtil.verify2D(B);
        VerifyUtil.verify2D(C);
        final int m1RowCount = (int)A2.getRowCount();
        final int m1ColumnCount = (int)A2.getColumnCount();
        int m2RowCount = (int)B.getRowCount();
        int m2ColumnCount = (int)B.getColumnCount();
        VerifyUtil.verifyEquals(m1ColumnCount, m2RowCount, "matrices have wrong size");
        VerifyUtil.verifyEquals((long)m1RowCount, C.getRowCount(), "matrices have wrong size");
        VerifyUtil.verifyEquals((long)m2ColumnCount, C.getColumnCount(), "matrices have wrong size");
        if (m1RowCount >= Mtimes.THRESHOLD && m1ColumnCount >= Mtimes.THRESHOLD && m2ColumnCount >= Mtimes.THRESHOLD) {
            new PFor(0, m2ColumnCount - 1){

                public void step(int i) {
                    for (int irow = 0; irow < m1RowCount; ++irow) {
                        C.setAsDouble(0.0, irow, i);
                    }
                    for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                        double temp = B.getAsDouble(lcol, i);
                        if (temp == 0.0) continue;
                        for (int irow = 0; irow < m1RowCount; ++irow) {
                            C.setAsDouble(C.getAsDouble(irow, i) + A2.getAsDouble(irow, lcol) * temp, irow, i);
                        }
                    }
                }
            };
        } else {
            for (int i = 0; i < m2ColumnCount; ++i) {
                for (int irow = 0; irow < m1RowCount; ++irow) {
                    C.setAsDouble(0.0, irow, i);
                }
                for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                    double temp = B.getAsDouble(lcol, i);
                    if (temp == 0.0) continue;
                    for (int irow = 0; irow < m1RowCount; ++irow) {
                        C.setAsDouble(C.getAsDouble(irow, i) + A2.getAsDouble(irow, lcol) * temp, irow, i);
                    }
                }
            }
        }
    }
}

