/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.signContainer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.gm.ses.v1.SES_Signature;
import org.ofdrw.gm.ses.v1.SESeal;
import org.ofdrw.gm.ses.v1.TBS_Sign;
import org.ofdrw.sign.ExtendSignatureContainer;

public class SESV1Container
implements ExtendSignatureContainer {
    private final PrivateKey privateKey;
    private final SESeal seal;
    private final Certificate certificate;

    public SESV1Container(PrivateKey privateKey, SESeal seal, Certificate signCert) {
        this.privateKey = privateKey;
        this.seal = seal;
        this.certificate = signCert;
    }

    @Override
    public MessageDigest getDigestFnc() {
        return new SM3.Digest();
    }

    @Override
    public ASN1ObjectIdentifier getSignAlgOID() {
        return GMObjectIdentifiers.sm2sign_with_sm3;
    }

    @Override
    public byte[] sign(InputStream inData, String propertyInfo) throws IOException, GeneralSecurityException {
        MessageDigest md = this.getDigestFnc();
        byte[] digest = md.digest(IOUtils.toByteArray(inData));
        byte[] signUTCTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).getBytes(StandardCharsets.UTF_8);
        TBS_Sign tbsSign = new TBS_Sign().setVersion(new ASN1Integer(1L)).setEseal(this.seal).setTimeInfo(new DERBitString(signUTCTime)).setDataHash(new DERBitString(digest)).setPropertyInfo(new DERIA5String(propertyInfo)).setCert(new DEROctetString(this.certificate.getEncoded())).setSignatureAlgorithm(GMObjectIdentifiers.sm2sign_with_sm3);
        Signature signature = Signature.getInstance("SM3withSm2", new BouncyCastleProvider());
        signature.initSign(this.privateKey);
        signature.update(tbsSign.getEncoded("DER"));
        byte[] sign = signature.sign();
        SES_Signature sesSignature = new SES_Signature(tbsSign, new DERBitString(sign));
        return sesSignature.getEncoded("DER");
    }

    @Override
    public byte[] getSeal() throws IOException {
        return this.seal.getEncoded("DER");
    }

    @Override
    public SigType getSignType() {
        return SigType.Seal;
    }
}

