/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.signContainer;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.gm.sm2strut.ContentInfo;
import org.ofdrw.gm.sm2strut.OIDs;
import org.ofdrw.gm.sm2strut.SignedData;
import org.ofdrw.gm.sm2strut.builder.SignedDataBuilder;
import org.ofdrw.sign.ExtendSignatureContainer;

public class GBT35275DSContainer
implements ExtendSignatureContainer {
    private final PrivateKey prvKey;
    private final Certificate cert;
    private boolean enableFileHashBase64;

    public GBT35275DSContainer(@NotNull Certificate cert, @NotNull PrivateKey prvKey) {
        if (cert == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4f7f\u7528\u8bc1\u4e66\uff08cert\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prvKey == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4f7f\u7528\u79c1\u94a5\uff08prvKey\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cert = cert;
        this.prvKey = prvKey;
        this.enableFileHashBase64 = false;
    }

    @Override
    public MessageDigest getDigestFnc() {
        return new SM3.Digest();
    }

    @Override
    public ASN1ObjectIdentifier getSignAlgOID() {
        return GMObjectIdentifiers.sm2sign_with_sm3;
    }

    @Override
    public byte[] sign(InputStream inData, String propertyInfo) throws GeneralSecurityException, IOException {
        SM3.Digest md = new SM3.Digest();
        byte[] plaintext = md.digest(IOUtils.toByteArray(inData));
        if (this.enableFileHashBase64) {
            plaintext = Base64.encode(plaintext);
        }
        Signature signatureFnc = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), new BouncyCastleProvider());
        signatureFnc.initSign(this.prvKey);
        signatureFnc.update(plaintext);
        byte[] signature = signatureFnc.sign();
        SignedData signedData = SignedDataBuilder.signedData(plaintext, signature, this.cert);
        ContentInfo contentInfo = new ContentInfo(OIDs.signedData, signedData);
        return contentInfo.getEncoded();
    }

    @Override
    public byte[] getSeal() throws IOException {
        return null;
    }

    @Override
    public SigType getSignType() {
        return SigType.Sign;
    }

    public void setEnableFileHashBase64(boolean state) {
        this.enableFileHashBase64 = state;
    }
}

