/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.tool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.ofdrw.pkg.tool.OFDNameSpaceModifier;
import org.ofdrw.pkg.tool.SAXReaderFactory;

public class ElemCup {
    private static final OFDNameSpaceModifier SpaceModifier = new OFDNameSpaceModifier();
    private static final OutputFormat PrettyPrint = OutputFormat.createPrettyPrint();
    public static boolean ENABLE_DEBUG_PRINT = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element inject(Path file) throws DocumentException {
        SAXReader reader = SAXReaderFactory.create();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Document document = reader.read(in);
            Element element = document.getRootElement();
            return element;
        }
        catch (IOException e) {
            throw new DocumentException(e);
        }
    }

    public static void dump(Element e, Path to) throws IOException {
        if (e == null) {
            return;
        }
        if (to == null) {
            throw new IllegalArgumentException("\u6587\u6863\u5143\u7d20\u5e8f\u5217\u5316\u76ee\u6807\u76ee\u5f55\uff08to\uff09\u4e3a\u7a7a");
        }
        if (Files.notExists(to, new LinkOption[0])) {
            if (Files.notExists(to.getParent(), new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
            }
            Files.createFile(to, new FileAttribute[0]);
        }
        Document doc = DocumentHelper.createDocument();
        if (e.getDocument() != null) {
            e = (Element)e.clone();
        }
        doc.add(e);
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            XMLWriter writeToFile = ENABLE_DEBUG_PRINT ? new XMLWriter(out, PrettyPrint) : new XMLWriter(out);
            writeToFile.write(doc);
            writeToFile.close();
        }
    }

    public static void dumpUpNS(Element e, Path to) throws IOException {
        if (e == null) {
            return;
        }
        if (to == null) {
            throw new IllegalArgumentException("\u6587\u6863\u5143\u7d20\u5e8f\u5217\u5316\u76ee\u6807\u76ee\u5f55\uff08to\uff09\u4e3a\u7a7a");
        }
        if (Files.notExists(to, new LinkOption[0])) {
            if (Files.notExists(to.getParent(), new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
            }
            Files.createFile(to, new FileAttribute[0]);
        }
        Document doc = DocumentHelper.createDocument();
        if (e.getDocument() != null) {
            e = (Element)e.clone();
        }
        doc.add(e);
        doc.accept(SpaceModifier);
        try (OutputStream out = Files.newOutputStream(to, new OpenOption[0]);){
            XMLWriter writeToFile = ENABLE_DEBUG_PRINT ? new XMLWriter(out, PrettyPrint) : new XMLWriter(out);
            writeToFile.write(doc);
            writeToFile.close();
        }
    }

    public static byte[] dump(Element e) throws IOException {
        Document doc = DocumentHelper.createDocument();
        if (e.getDocument() != null) {
            e = (Element)e.clone();
        }
        doc.add(e);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLWriter writeToFile = ENABLE_DEBUG_PRINT ? new XMLWriter(bout, PrettyPrint) : new XMLWriter(bout);
        writeToFile.write(doc);
        writeToFile.close();
        return bout.toByteArray();
    }
}

