/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.awt.geom.Rectangle2D;
import org.ofdrw.font.EnvFont;
import org.ofdrw.font.Font;
import org.ofdrw.layout.element.TextFontInfo;

public class TxtGlyph {
    private Rectangle2D bounds;
    private final char txt;
    private final TextFontInfo textFontInfo;

    public TxtGlyph(char txt, TextFontInfo span) {
        this.txt = txt;
        this.textFontInfo = span;
    }

    public double getW() {
        Font font = this.textFontInfo.getFont();
        if (font.hasWidthMath()) {
            double w = this.textFontInfo.getLetterSpacing();
            return w += this.textFontInfo.getFontSize() * font.getCharWidthScale(this.txt);
        }
        if (this.bounds == null) {
            this.bounds = EnvFont.strBounds(font.getName(), font.getFamilyName(), String.valueOf(this.txt), this.textFontInfo.getFontSize());
        }
        return this.textFontInfo.getLetterSpacing() + this.bounds.getWidth();
    }

    public double getH() {
        Font font = this.textFontInfo.getFont();
        if (font.hasWidthMath()) {
            return this.textFontInfo.getFontSize();
        }
        if (this.bounds == null) {
            this.bounds = EnvFont.strBounds(font.getName(), font.getFamilyName(), String.valueOf(this.txt), this.textFontInfo.getFontSize());
        }
        return this.bounds.getHeight();
    }
}

