/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.edit;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.annotation.pageannot.AnnotType;
import org.ofdrw.core.annotation.pageannot.Appearance;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.layout.element.canvas.Drawer;

public class Annotation {
    private Drawer drawer;
    private AnnotType type;
    private String creator;
    private LocalDate lastModDate;
    private String subtype = null;
    private Boolean visible = null;
    private Boolean noRotate = null;
    private LinkedHashMap<String, String> parameters = null;
    private String remark = null;
    private Boolean readOnly;
    private Boolean print = null;
    private Boolean noZoom;
    private ST_Box boundary;

    private Annotation() {
    }

    public Annotation(double x, double y, double width, double height, AnnotType type, Drawer drawer) {
        this(new ST_Box(x, y, width, height), type, drawer);
    }

    public Annotation(ST_Box boundary, AnnotType type, Drawer drawer) {
        if (boundary == null) {
            throw new IllegalArgumentException("\u6ce8\u91ca\u5bf9\u8c61\u7ed8\u5236\u7a7a\u95f4(boundary)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (type == null) {
            throw new IllegalArgumentException("\u6ce8\u89e3\u5bf9\u8c61\u7c7b\u578b(type)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (drawer == null) {
            throw new IllegalArgumentException("\u6ce8\u89e3\u7ed8\u5236\u5668(drawer)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setDrawer(drawer);
        this.type = type;
        this.boundary = boundary;
    }

    public Annot build() {
        Annot annot = new Annot().setType(this.type).setCreator(this.creator == null ? "OFD R&W" : this.creator).setLastModDate(this.lastModDate == null ? LocalDate.now() : this.lastModDate);
        if (this.visible != null) {
            annot.setVisible(this.visible);
        }
        if (this.subtype != null) {
            annot.setSubtype(this.subtype);
        }
        if (this.print != null) {
            annot.setPrint(this.print);
        }
        if (this.noZoom != null) {
            annot.setNoZoom(this.noZoom);
        }
        if (this.noRotate != null) {
            annot.setNoRotate(this.noRotate);
        }
        if (this.readOnly != null) {
            annot.setReadOnly(this.readOnly);
        }
        if (this.remark != null) {
            annot.setRemark(this.remark);
        }
        if (this.parameters != null) {
            this.parameters.forEach(annot::addParameter);
        }
        annot.setAppearance(new Appearance(this.boundary));
        return annot;
    }

    public ST_Box getBoundary() {
        return this.boundary;
    }

    public void setBoundary(ST_Box boundary) {
        this.boundary = boundary;
    }

    public Drawer getDrawer() {
        return this.drawer;
    }

    public Annotation setDrawer(Drawer drawer) {
        this.drawer = drawer;
        return this;
    }

    public Annotation setType(AnnotType type) {
        this.type = type;
        return this;
    }

    public AnnotType getType() {
        return this.type;
    }

    public Annotation setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public Annotation setLastModDate(LocalDate lastModDate) {
        this.lastModDate = lastModDate;
        return this;
    }

    public LocalDate getLastModDate() {
        return this.lastModDate;
    }

    public Annotation setSubtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Annotation setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public Boolean getVisible() {
        if (this.visible == null) {
            return true;
        }
        return this.visible;
    }

    public Annotation setPrint(boolean print) {
        this.print = print;
        return this;
    }

    public Boolean getPrint() {
        if (this.print == null) {
            return true;
        }
        return this.print;
    }

    public Annotation setNoZoom(boolean noZoom) {
        this.noZoom = noZoom;
        return this;
    }

    public Boolean getNoZoom() {
        if (this.noZoom == null) {
            return false;
        }
        return this.noZoom;
    }

    public Annotation setNoRotate(boolean noRotate) {
        this.noRotate = noRotate;
        return this;
    }

    public Boolean getNoRotate() {
        if (this.noRotate == null) {
            return false;
        }
        return this.noRotate;
    }

    public Annotation setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getReadOnly() {
        if (this.readOnly == null) {
            return true;
        }
        return this.readOnly;
    }

    public Annotation setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public Annotation addParameter(String name, String parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        if (name == null) {
            return this;
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }
}

