/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout;

import java.util.List;
import java.util.Map;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.text.CT_CGTransform;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.font.Font;
import org.ofdrw.font.FontName;
import org.ofdrw.layout.OFDDoc;
import org.ofdrw.layout.element.Paragraph;
import org.ofdrw.reader.ContentExtractor;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.extractor.ExtractorFilter;

public class DocContentReplace {
    private OFDDoc ofdDoc;
    @Deprecated
    private ReplaceTextCgTransformHandler replaceTextCgTransformHandler;
    private ReplaceTextHandler replaceTextHandler;

    public DocContentReplace(OFDDoc ofdDoc) {
        this.ofdDoc = ofdDoc;
        if (ofdDoc == null) {
            throw new IllegalArgumentException("OFDDoc\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public DocContentReplace(OFDDoc ofdDoc, ReplaceTextHandler replaceTextHandler) {
        this.ofdDoc = ofdDoc;
        this.replaceTextHandler = replaceTextHandler;
    }

    public void replaceText(int pageNum, Map<String, String> textMap) {
        this.replaceText(pageNum, textMap, null);
    }

    public void replaceText(Map<String, String> textMap) {
        this.replaceText(textMap, null);
    }

    public void replaceText(int pageNum, Map<String, String> textMap, ExtractorFilter contentExtractorFilter) {
        ContentExtractor contentExtractor = new ContentExtractor(this.getReader(), contentExtractorFilter);
        this.replaceTextByTextObject(textMap, contentExtractor.getPageTextObject(pageNum));
    }

    public void replaceText(Map<String, String> textMap, ExtractorFilter contentExtractorFilter) {
        ContentExtractor contentExtractor = new ContentExtractor(this.getReader(), contentExtractorFilter);
        this.replaceTextByTextObject(textMap, contentExtractor.extractAllTextObject());
    }

    protected void replaceTextByTextObject(Map<String, String> textMap, List<TextObject> txtObjectList) {
        if (txtObjectList == null || txtObjectList.isEmpty()) {
            return;
        }
        txtObjectList.forEach(txtObj -> txtObj.getTextCodes().forEach(txtCode -> {
            String newText;
            String oldText = txtCode.getContent();
            if (oldText != null && oldText.trim().length() > 0 && (newText = (String)textMap.get(oldText)) != null) {
                List<CT_CGTransform> ctCgTransformList = txtObj.getCGTransforms();
                if (ctCgTransformList != null && ctCgTransformList.size() > 0) {
                    txtObj.removeOFDElemByNames(ctCgTransformList.get(0).getName());
                }
                String fontRefId = txtObj.getFont().getRefId().toString();
                CT_Font ctFont = this.getReader().getResMgt().getFont(fontRefId);
                Font font = null;
                CT_CGTransform cgTransform = null;
                if (this.replaceTextHandler != null) {
                    cgTransform = this.replaceTextHandler.handleCgTransform((TextObject)txtObj, newText, ctFont);
                    font = this.replaceTextHandler.handleNewFont((TextObject)txtObj, newText, ctFont);
                } else if (this.replaceTextCgTransformHandler != null) {
                    cgTransform = this.replaceTextCgTransformHandler.createCgTransformHandler((TextObject)txtObj, newText, ctFont.getFontFile());
                }
                if (cgTransform != null) {
                    txtObj.addCGTransform(cgTransform);
                }
                if (font == null) {
                    String fontName = ctFont.getFontName();
                    font = new Font(fontName, ctFont.getFamilyName());
                    if ("Times New Roman".equals(fontName)) {
                        font.setPrintableAsciiWidthMap(FontName.TIMES_NEW_ROMAN_PRINTABLE_ASCII_MAP);
                    }
                }
                Paragraph paragraph = ((Paragraph)new Paragraph().setFontSize(txtObj.getSize()).setDefaultFont(font).setXY(txtCode.getX(), txtCode.getY())).add(newText);
                txtCode.setContent(newText);
                txtCode.setDeltaX(paragraph.getContents().get(0).getDeltaX());
            }
        }));
    }

    public ReplaceTextHandler getReplaceTextHandler() {
        return this.replaceTextHandler;
    }

    public void setReplaceTextHandler(ReplaceTextHandler replaceTextHandler) {
        this.replaceTextHandler = replaceTextHandler;
    }

    public OFDReader getReader() {
        return this.ofdDoc.getReader();
    }

    public ReplaceTextCgTransformHandler getReplaceTextCgTransformHandler() {
        return this.replaceTextCgTransformHandler;
    }

    public void setReplaceTextCgTransformHandler(ReplaceTextCgTransformHandler replaceTextCgTransformHandler) {
        this.replaceTextCgTransformHandler = replaceTextCgTransformHandler;
    }

    static interface ReplaceTextHandler {
        default public CT_CGTransform handleCgTransform(TextObject textObject, String newText, CT_Font beforeCtFont) {
            return null;
        }

        default public Font handleNewFont(TextObject textObject, String newText, CT_Font beforeCtFont) {
            return null;
        }
    }

    @Deprecated
    static interface ReplaceTextCgTransformHandler {
        public CT_CGTransform createCgTransformHandler(TextObject var1, String var2, ST_Loc var3);
    }
}

