/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.graphics2d;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.ColorSpaces;
import org.ofdrw.core.basicStructure.res.resources.CompositeGraphicUnits;
import org.ofdrw.core.basicStructure.res.resources.DrawParams;
import org.ofdrw.core.basicStructure.res.resources.Fonts;
import org.ofdrw.core.basicStructure.res.resources.MultiMedias;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.pkg.container.DocDir;

public class ResManager {
    private AtomicInteger maxUnitID;
    private DocDir docDir;
    private MultiMedias medias;
    private DrawParams drawParams;
    private Fonts fonts;
    private ColorSpaces colorSpaces;
    private CompositeGraphicUnits compositeGraphicUnits;
    private final HashMap<Integer, ST_ID> resObjHash = new HashMap();

    private ResManager() {
    }

    public ResManager(DocDir docDir, AtomicInteger maxUnitID) {
        this();
        this.docDir = docDir;
        this.maxUnitID = maxUnitID;
    }

    public Res pubRes() {
        try {
            return this.docDir.getPublicRes();
        }
        catch (FileNotFoundException | DocumentException e) {
            Res publicRes = new Res().setBaseLoc(ST_Loc.getInstance("Res"));
            this.docDir.setPublicRes(publicRes);
            this.document().getCommonData().addPublicRes(ST_Loc.getInstance("PublicRes.xml"));
            return publicRes;
        }
    }

    public Res docRes() {
        try {
            return this.docDir.getDocumentRes();
        }
        catch (FileNotFoundException | DocumentException e) {
            Res docRes = new Res().setBaseLoc(ST_Loc.getInstance("Res"));
            this.docDir.setDocumentRes(docRes);
            this.document().getCommonData().addDocumentRes(ST_Loc.getInstance("DocumentRes.xml"));
            return docRes;
        }
    }

    private Document document() {
        try {
            return this.docDir.getDocument();
        }
        catch (FileNotFoundException | DocumentException ex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u7f3a\u5c11Document.xml \u6587\u4ef6");
        }
    }

    public ST_ID addRawWithCache(OFDElement resObj) {
        if (resObj == null) {
            return null;
        }
        resObj.removeAttr("ID");
        int key = resObj.asXML().hashCode();
        ST_ID objId = this.resObjHash.get(key);
        if (objId != null) {
            resObj.setObjID(objId);
            return objId;
        }
        objId = new ST_ID(this.maxUnitID.incrementAndGet());
        resObj.setObjID(objId);
        this.resObjHash.put(key, objId);
        if (resObj instanceof CT_ColorSpace) {
            Res resMenu = this.pubRes();
            if (this.colorSpaces == null) {
                this.colorSpaces = new ColorSpaces();
                resMenu.addResource(this.colorSpaces);
            }
            this.colorSpaces.addColorSpace((CT_ColorSpace)resObj);
        } else if (resObj instanceof CT_Font) {
            Res resMenu = this.pubRes();
            if (this.fonts == null) {
                this.fonts = new Fonts();
                resMenu.addResource(this.fonts);
            }
            this.fonts.addFont((CT_Font)resObj);
        } else if (resObj instanceof CT_DrawParam) {
            Res resMenu = this.docRes();
            if (this.drawParams == null) {
                this.drawParams = new DrawParams();
                resMenu.addResource(this.drawParams);
            }
            this.drawParams.addDrawParam((CT_DrawParam)resObj);
        } else if (resObj instanceof CT_MultiMedia) {
            Res resMenu = this.docRes();
            if (this.medias == null) {
                this.medias = new MultiMedias();
                resMenu.addResource(this.medias);
            }
            this.medias.addMultiMedia((CT_MultiMedia)resObj);
        } else if (resObj instanceof CT_VectorG) {
            Res resMenu = this.docRes();
            if (this.compositeGraphicUnits == null) {
                this.compositeGraphicUnits = new CompositeGraphicUnits();
                resMenu.addResource(this.compositeGraphicUnits);
            }
            this.compositeGraphicUnits.addCompositeGraphicUnit((CT_VectorG)resObj);
        }
        return objId;
    }
}

