/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.sm2strut.builder;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.gm.cert.CertTools;
import org.ofdrw.gm.sm2strut.ContentInfo;
import org.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import org.ofdrw.gm.sm2strut.OIDs;
import org.ofdrw.gm.sm2strut.SignedData;
import org.ofdrw.gm.sm2strut.SignerInfo;

public final class PKCS9SignedDataBuilder {
    public static SignedData signedData(@NotNull byte[] plaintext, @NotNull Signature signFnc, @NotNull java.security.cert.Certificate signCert, @Nullable List<java.security.cert.Certificate> extCertArr) throws GeneralSecurityException, IOException {
        if (plaintext == null || plaintext.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u539f\u6587(plaintext)\u4e3a\u7a7a");
        }
        if (signCert == null) {
            throw new IllegalArgumentException("\u8bc1\u4e66(signCert)\u4e3a\u7a7a");
        }
        if (signFnc == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u51fd\u6570(signFnc)\u4e3a\u7a7a");
        }
        DERSet digestAlgorithms = new DERSet(new AlgorithmIdentifier(OIDs.sm3));
        ContentInfo contentInfo = new ContentInfo(OIDs.data, null);
        SM3.Digest md = new SM3.Digest();
        byte[] digest = md.digest(plaintext);
        int len = 1;
        int i = 0;
        if (extCertArr != null) {
            len += extCertArr.size();
        }
        ASN1Encodable[] certArr = new ASN1Encodable[len];
        Certificate signerCert = CertTools.asn1(signCert);
        certArr[0] = signerCert;
        if (extCertArr != null) {
            for (java.security.cert.Certificate c : extCertArr) {
                certArr[i] = CertTools.asn1(c);
                ++i;
            }
        }
        DERSet certificates = new DERSet(certArr);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(signerCert.getIssuer(), signerCert.getSerialNumber());
        SignerInfo signerInfo = PKCS9SignedDataBuilder.sign(digest, signFnc, isn);
        DERSet signerInfos = new DERSet(new ASN1Encodable[]{signerInfo});
        return new SignedData(digestAlgorithms, contentInfo, certificates, signerInfos);
    }

    public static SignerInfo sign(byte[] digest, Signature signFnc, IssuerAndSerialNumber isn) throws GeneralSecurityException {
        Attribute contentType = new Attribute(CMSAttributes.contentType, new DERSet(OIDs.data));
        Attribute signingTime = new Attribute(CMSAttributes.signingTime, new DERSet(new ASN1UTCTime(new Date(), Locale.CHINA)));
        Attribute messageDigest = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(digest)));
        DERSet authenticatedAttributes = new DERSet(new ASN1Encodable[]{contentType, signingTime, messageDigest});
        try {
            signFnc.update(authenticatedAttributes.getEncoded());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] signature = signFnc.sign();
        SignerInfo res = new SignerInfo(isn, new AlgorithmIdentifier(OIDs.sm3), new AlgorithmIdentifier(OIDs.sm2Sign), new DEROctetString(signature));
        res.setAuthenticatedAttributes(authenticatedAttributes);
        return res;
    }
}

