/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.sm2strut;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.ofdrw.gm.cert.CertTools;
import org.ofdrw.gm.sm2strut.ContentInfo;
import org.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import org.ofdrw.gm.sm2strut.OIDs;
import org.ofdrw.gm.sm2strut.SignedData;
import org.ofdrw.gm.sm2strut.SignerInfo;
import org.ofdrw.gm.sm2strut.VerifyInfo;

public class GBT35275Validate {
    public static VerifyInfo validate(String alg, byte[] tbsContent, byte[] signedValue) throws GeneralSecurityException {
        ContentInfo contentInfo = ContentInfo.getInstance(signedValue);
        if (contentInfo == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790ContentInfo\u7ed3\u6784");
        }
        if (!OIDs.signedData.equals(contentInfo.getContentType())) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u7b7e\u540d\u6570\u636e\u7c7b\u578b\uff0c\u7c7b\u578b\uff1a" + contentInfo.getContentType());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        if (signedData == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7b7e\u540d\u503c\u683c\u5f0f\uff0c\u4e0d\u7b26 GBT35275");
        }
        SM3.Digest md = new SM3.Digest();
        byte[] digestAct = md.digest(tbsContent);
        byte[] plaintext = null;
        ASN1Encodable dataContent = signedData.getContentInfo().getContent();
        if (dataContent != null && !Arrays.equals(digestAct, plaintext = DEROctetString.getInstance(dataContent).getOctets())) {
            try {
                byte[] decode = Base64.decode(new String(plaintext));
                if (!Arrays.equals(digestAct, decode)) {
                    return VerifyInfo.Err("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
                }
            }
            catch (Exception e) {
                return VerifyInfo.Err("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
            }
        }
        for (ASN1Encodable item : signedData.getSignerInfos()) {
            SignerInfo signerInfo = SignerInfo.getInstance(item);
            ASN1Set authenticatedAttributes = signerInfo.getAuthenticatedAttributes();
            if (authenticatedAttributes != null) {
                AttributeTable attributes = new AttributeTable(authenticatedAttributes);
                Attribute attr = attributes.get(CMSAttributes.messageDigest);
                ASN1Primitive asn1Primitive = attr.getAttrValues().getObjectAt(0).toASN1Primitive();
                if (!(asn1Primitive instanceof ASN1OctetString)) {
                    throw new IllegalArgumentException("PKCS#9 message-digest \u5c5e\u6027\u7c7b\u578b\u4e0d\u662f 'OCTET STRING'");
                }
                ASN1OctetString signedMessageDigest = (ASN1OctetString)asn1Primitive;
                byte[] digest = signedMessageDigest.getOctets();
                if (!Arrays.equals(digestAct, digest)) {
                    return VerifyInfo.Err("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
                }
                try {
                    plaintext = authenticatedAttributes.getEncoded();
                }
                catch (IOException e) {
                    plaintext = null;
                }
            }
            if (plaintext == null) {
                throw new IllegalArgumentException("GBT35275\u7b7e\u540d\u503c\u683c\u5f0f\u9519\u8bef");
            }
            IssuerAndSerialNumber iaSn = signerInfo.getIssuerAngSerialNumber();
            Certificate c = signedData.getSignCert(iaSn);
            if (c == null) {
                return VerifyInfo.Err("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8bc1\u4e66\u65e0\u6cd5\u9a8c\u8bc1\u7b7e\u540d");
            }
            java.security.cert.Certificate cert = CertTools.obj(c);
            Signature sg = Signature.getInstance(alg, new BouncyCastleProvider());
            sg.initVerify(cert.getPublicKey());
            sg.update(plaintext);
            byte[] signature = signerInfo.getEncryptedDigest().getOctets();
            if (sg.verify(signature)) continue;
            return VerifyInfo.Err("\u7b7e\u540d\u503c\u4e0d\u4e00\u81f4");
        }
        return VerifyInfo.OK();
    }
}

