/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.ses.v4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Iterable;

public class CertInfoList
extends ASN1Object
implements Iterable<ASN1OctetString> {
    private final List<ASN1OctetString> dataSequence;

    public CertInfoList() {
        this.dataSequence = new ArrayList<ASN1OctetString>();
    }

    public CertInfoList(ASN1OctetString[] arr) {
        this();
        this.dataSequence.addAll(Arrays.asList(arr));
    }

    public CertInfoList(ASN1Sequence seq) {
        this.dataSequence = new ArrayList<ASN1OctetString>(seq.size());
        for (int i = 0; i != seq.size(); ++i) {
            this.add(DEROctetString.getInstance(seq.getObjectAt(i)));
        }
    }

    public static CertInfoList getInstance(Object obj) {
        if (obj instanceof CertInfoList) {
            return (CertInfoList)obj;
        }
        if (obj != null) {
            return new CertInfoList(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public CertInfoList add(ASN1OctetString obj) {
        this.dataSequence.add(obj);
        return this;
    }

    public ASN1OctetString get(int index) {
        return this.dataSequence.get(index);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(this.dataSequence.size());
        this.dataSequence.forEach(v::add);
        return new DERSequence(v);
    }

    @Override
    public Iterator<ASN1OctetString> iterator() {
        return this.dataSequence.iterator();
    }
}

