/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.ses.v4;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;

public class CertDigestObj
extends ASN1Object {
    private DERPrintableString type;
    private ASN1OctetString value;

    public CertDigestObj() {
    }

    public CertDigestObj(DERPrintableString type, ASN1OctetString value) {
        this.type = type;
        this.value = value;
    }

    public CertDigestObj(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.type = DERPrintableString.getInstance(e.nextElement());
        this.value = ASN1OctetString.getInstance(e.nextElement());
    }

    public static CertDigestObj getInstance(Object o) {
        if (o instanceof CertDigestObj) {
            return (CertDigestObj)o;
        }
        if (o != null) {
            return new CertDigestObj(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public DERPrintableString getType() {
        return this.type;
    }

    public CertDigestObj setType(DERPrintableString type) {
        this.type = type;
        return this;
    }

    public CertDigestObj setType(String type) {
        this.type = new DERPrintableString(type);
        return this;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public CertDigestObj setValue(ASN1OctetString value) {
        this.value = value;
        return this;
    }

    public CertDigestObj setValue(byte[] value) {
        this.value = new DEROctetString(value);
        return this;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.type);
        v.add(this.value);
        return new DERSequence(v);
    }
}

