/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.ses.v1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.ofdrw.gm.ses.v1.SESeal;

public class TBS_Sign
extends ASN1Object {
    private ASN1Integer version;
    private SESeal eseal;
    private ASN1BitString timeInfo;
    private ASN1BitString dataHash;
    private DERIA5String propertyInfo;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgorithm;

    public TBS_Sign() {
    }

    public TBS_Sign(ASN1Integer version, SESeal eseal, ASN1BitString timeInfo, ASN1BitString dataHash, DERIA5String propertyInfo, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm) {
        this.version = version;
        this.eseal = eseal;
        this.timeInfo = timeInfo;
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public TBS_Sign(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = ASN1Integer.getInstance(e.nextElement());
        this.eseal = SESeal.getInstance(e.nextElement());
        Object timeInfoObj = e.nextElement();
        this.timeInfo = timeInfoObj instanceof DEROctetString ? new DERBitString(((DEROctetString)timeInfoObj).getOctets()) : DERBitString.getInstance(timeInfoObj);
        Object dataHashObj = e.nextElement();
        this.dataHash = dataHashObj instanceof DEROctetString ? new DERBitString(((DEROctetString)dataHashObj).getOctets()) : DERBitString.getInstance(dataHashObj);
        this.propertyInfo = DERIA5String.getInstance(e.nextElement());
        this.cert = ASN1OctetString.getInstance(e.nextElement());
        this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
    }

    public static TBS_Sign getInstance(Object o) {
        if (o instanceof TBS_Sign) {
            return (TBS_Sign)o;
        }
        if (o != null) {
            return new TBS_Sign(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public TBS_Sign setVersion(ASN1Integer version) {
        this.version = version;
        return this;
    }

    public SESeal getEseal() {
        return this.eseal;
    }

    public TBS_Sign setEseal(SESeal eseal) {
        this.eseal = eseal;
        return this;
    }

    public ASN1BitString getTimeInfo() {
        return this.timeInfo;
    }

    public TBS_Sign setTimeInfo(ASN1BitString timeInfo) {
        this.timeInfo = timeInfo;
        return this;
    }

    public ASN1BitString getDataHash() {
        return this.dataHash;
    }

    public TBS_Sign setDataHash(ASN1BitString dataHash) {
        this.dataHash = dataHash;
        return this;
    }

    public DERIA5String getPropertyInfo() {
        return this.propertyInfo;
    }

    public TBS_Sign setPropertyInfo(DERIA5String propertyInfo) {
        this.propertyInfo = propertyInfo;
        return this;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public TBS_Sign setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public TBS_Sign setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(7);
        v.add(this.version);
        v.add(this.eseal);
        v.add(this.timeInfo);
        v.add(this.dataHash);
        v.add(this.propertyInfo);
        v.add(this.cert);
        v.add(this.signatureAlgorithm);
        return new DERSequence(v);
    }
}

