/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.cert;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS12Tools {
    public static PrivateKey ReadPrvKey(Path userP12, String pwd) throws GeneralSecurityException, IOException {
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            PrivateKey privateKey = PKCS12Tools.ReadPrvKey(rootKsIn, pwd);
            return privateKey;
        }
    }

    public static PrivateKey ReadPrvKey(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        String alias = ks.aliases().nextElement();
        return (PrivateKey)ks.getKey(alias, pwd.toCharArray());
    }

    public static PrivateKey ReadPrvKey(Path userP12, String alias, String pwd) throws GeneralSecurityException, IOException {
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            PrivateKey privateKey = PKCS12Tools.ReadPrvKey(rootKsIn, alias, pwd);
            return privateKey;
        }
    }

    public static PrivateKey ReadPrvKey(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        return (PrivateKey)ks.getKey(alias, pwd.toCharArray());
    }

    public static Certificate[] ReadCertChain(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        String alias = ks.aliases().nextElement();
        return ks.getCertificateChain(alias);
    }

    public static Certificate ReadUserCert(Path userP12, String pwd) throws GeneralSecurityException, IOException {
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            Certificate certificate = PKCS12Tools.ReadUserCert(rootKsIn, pwd);
            return certificate;
        }
    }

    public static Certificate ReadUserCert(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(rootKsIn, pwd)[0];
    }

    public static Certificate[] ReadCertChain(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        return ks.getCertificateChain(alias);
    }

    public static Certificate ReadUserCert(Path userP12, String alias, String pwd) throws GeneralSecurityException, IOException {
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            Certificate certificate = PKCS12Tools.ReadUserCert(rootKsIn, alias, pwd);
            return certificate;
        }
    }

    public static Certificate ReadUserCert(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(rootKsIn, alias, pwd)[0];
    }
}

