/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.awt.geom.AffineTransform;
import org.ofdrw.converter.point.Tuple2;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;

public class MatrixUtils {
    public static Matrix base() {
        DenseDoubleMatrix2D matrix = DenseMatrix.Factory.zeros(3L, 3L);
        matrix.setAsDouble(1.0, 0L, 0L);
        matrix.setAsDouble(1.0, 1L, 1L);
        matrix.setAsDouble(1.0, 2L, 2L);
        return matrix;
    }

    public static Matrix create(double d1, double d2, double d3, double d4, double d5, double d6) {
        Matrix matrix = MatrixUtils.base();
        matrix.setAsDouble(d1, 0L, 0L);
        matrix.setAsDouble(d2, 0L, 1L);
        matrix.setAsDouble(d3, 1L, 0L);
        matrix.setAsDouble(d4, 1L, 1L);
        matrix.setAsDouble(d5, 2L, 0L);
        matrix.setAsDouble(d6, 2L, 1L);
        return matrix;
    }

    public static Matrix scale(Matrix matrix, double x, double y) {
        return matrix.mtimes(MatrixUtils.create(x, 0.0, 0.0, y, 0.0, 0.0));
    }

    public static Matrix move(Matrix matrix, double x, double y) {
        return matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, x, y));
    }

    public static Matrix ctm(Double ... ctm) {
        return MatrixUtils.create(ctm[0], ctm[1], ctm[2], ctm[3], ctm[4], ctm[5]);
    }

    public static Matrix imageMatrix(Matrix matrix, double a, double b, double c) {
        Matrix image = DenseMatrix.Factory.zeros(3L, 3L);
        image.setAsDouble(a * a - b * b, 0L, 0L);
        image.setAsDouble(2.0 * a * b, 0L, 1L);
        image.setAsDouble(2.0 * a * b, 1L, 0L);
        image.setAsDouble(-(a * a - b * b), 1L, 1L);
        image.setAsDouble(2.0 * a * c, 2L, 0L);
        image.setAsDouble(2.0 * b * c, 2L, 1L);
        image.setAsDouble(-(a * a + b * b), 2L, 2L);
        image = image.times(-1.0 / (a * a + b * b));
        return matrix.mtimes(image);
    }

    public static AffineTransform createAffineTransform(Matrix matrix) {
        return new AffineTransform(matrix.getAsFloat(0L, 0L), matrix.getAsFloat(0L, 1L), matrix.getAsFloat(1L, 0L), matrix.getAsFloat(1L, 1L), matrix.getAsFloat(2L, 0L), matrix.getAsFloat(2L, 1L));
    }

    public static Tuple2<Double, Double> leftTop(Matrix matrix) {
        Matrix m = MatrixUtils.base();
        m.setAsFloat(matrix.getAsFloat(0L, 0L), 0L, 0L);
        m.setAsFloat(matrix.getAsFloat(0L, 1L), 0L, 1L);
        m.setAsFloat(matrix.getAsFloat(1L, 0L), 1L, 0L);
        m.setAsFloat(matrix.getAsFloat(1L, 1L), 1L, 1L);
        m.setAsFloat(matrix.getAsFloat(2L, 0L), 2L, 0L);
        m.setAsFloat(matrix.getAsFloat(2L, 1L), 2L, 1L);
        m.setAsFloat(1.0f, 2L, 2L);
        double x = 0.0;
        double y = 0.0;
        Tuple2<Double, Double> tuple = MatrixUtils.leftTop(m, 0.0f, 0.0f);
        x = tuple.getFirst();
        y = tuple.getSecond();
        MatrixUtils.leftTop(m, 1.0f, 0.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        MatrixUtils.leftTop(m, 1.0f, 1.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        MatrixUtils.leftTop(m, 0.0f, 1.0f);
        if (tuple.getFirst() < x) {
            x = tuple.getFirst();
        }
        if (tuple.getSecond() < y) {
            y = tuple.getSecond();
        }
        return new Tuple2<Double, Double>(x, y);
    }

    private static Tuple2<Double, Double> leftTop(Matrix matrix, float x, float y) {
        DenseDoubleMatrix2D m = DenseMatrix.Factory.zeros(1L, 3L);
        m.setAsFloat(x, 0L, 0L);
        m.setAsFloat(x, 0L, 1L);
        m.setAsFloat(1.0f, 0L, 2L);
        Matrix result = m.mtimes(matrix);
        return new Tuple2<Double, Double>(result.getAsDouble(0L, 0L), result.getAsDouble(0L, 1L));
    }

    public static Tuple2<Double, Double> pointTransform(Matrix ctm, Double x, Double y) {
        Matrix m = DenseMatrix.Factory.zeros(1L, 3L);
        m.setAsDouble(x, 0L, 0L);
        m.setAsDouble(y, 0L, 1L);
        m.setAsDouble(1.0, 0L, 2L);
        m = m.mtimes(ctm);
        return new Tuple2<Double, Double>(m.getAsDouble(0L, 0L), m.getAsDouble(0L, 1L));
    }
}

